/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nga.servlet.dsp.parser.DefaultParameterParser;
import nga.servlet.dsp.parser.PropertyValueParserCollection;
import nga.servlet.dsp.writer.DefaultResultWriter;
import nga.servlet.spi.CongaServletFactory;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.util.Resource;

public class DefaultCongaServletFactory
implements CongaServletFactory {
    private static final String DEFAULT_MESSAGE_RESOURCE = "nga.servlet.dsp.Message";
    private Map<Locale, Map<String, Resource>> messageMap = new HashMap<Locale, Map<String, Resource>>();

    public DefaultCongaServletFactory() {
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        map.put(DEFAULT_MESSAGE_RESOURCE, new Resource(DEFAULT_MESSAGE_RESOURCE));
        this.messageMap.put(Locale.getDefault(), map);
    }

    public ParameterParser createParameterParser() {
        DefaultParameterParser parser = new DefaultParameterParser();
        parser.registerValueParser(String.class, PropertyValueParserCollection.FOR_STRING);
        parser.registerValueParser(Character.TYPE, PropertyValueParserCollection.FOR_CHARACTOR);
        parser.registerValueParser(Character.class, PropertyValueParserCollection.FOR_CHARACTOR);
        parser.registerValueParser(Boolean.TYPE, PropertyValueParserCollection.FOR_BOOLEAN);
        parser.registerValueParser(Boolean.class, PropertyValueParserCollection.FOR_BOOLEAN);
        parser.registerValueParser(Integer.TYPE, PropertyValueParserCollection.FOR_INTEGER);
        parser.registerValueParser(Integer.class, PropertyValueParserCollection.FOR_INTEGER);
        parser.registerValueParser(Long.TYPE, PropertyValueParserCollection.FOR_LONG);
        parser.registerValueParser(Long.class, PropertyValueParserCollection.FOR_LONG);
        parser.registerValueParser(Short.TYPE, PropertyValueParserCollection.FOR_SHORT);
        parser.registerValueParser(Short.class, PropertyValueParserCollection.FOR_SHORT);
        parser.registerValueParser(Byte.TYPE, PropertyValueParserCollection.FOR_BYTE);
        parser.registerValueParser(Byte.class, PropertyValueParserCollection.FOR_BYTE);
        parser.registerValueParser(Float.TYPE, PropertyValueParserCollection.FOR_FLOAT);
        parser.registerValueParser(Float.class, PropertyValueParserCollection.FOR_FLOAT);
        parser.registerValueParser(Double.TYPE, PropertyValueParserCollection.FOR_DOUBLE);
        parser.registerValueParser(Double.class, PropertyValueParserCollection.FOR_DOUBLE);
        parser.registerValueParser(BigDecimal.class, PropertyValueParserCollection.FOR_BIGDECIMAL);
        parser.registerValueParser(BigInteger.class, PropertyValueParserCollection.FOR_BIGINTEGER);
        parser.registerValueParser(java.util.Date.class, PropertyValueParserCollection.FOR_DATE);
        parser.registerValueParser(Date.class, PropertyValueParserCollection.FOR_SQLDATE);
        parser.registerValueParser(Time.class, PropertyValueParserCollection.FOR_SQLTIME);
        parser.registerValueParser(Timestamp.class, PropertyValueParserCollection.FOR_SQLTIMESTAMP);
        return parser;
    }

    public ResultWriter createResultWriter() {
        return new DefaultResultWriter();
    }

    public Resource getResource(Locale locale, String resourceName) {
        Resource resource;
        Map<String, Resource> map;
        String defaultResourceName = this.getDefaultResourceName();
        if (defaultResourceName == null) {
            defaultResourceName = DEFAULT_MESSAGE_RESOURCE;
        }
        if (resourceName == null) {
            resourceName = defaultResourceName;
        }
        if ((map = this.messageMap.get(locale)) == null) {
            map = new HashMap<String, Resource>();
            this.messageMap.put(locale, map);
        }
        if ((resource = map.get(resourceName)) == null) {
            resource = new Resource(resourceName, locale);
            if (!resourceName.equals(defaultResourceName)) {
                resource.setParent(this.getResource(locale, defaultResourceName));
            } else if (!resourceName.equals(DEFAULT_MESSAGE_RESOURCE)) {
                resource.setParent(this.getResource(locale, DEFAULT_MESSAGE_RESOURCE));
            }
            map.put(resourceName, resource);
        }
        return resource;
    }

    protected String getDefaultResourceName() {
        return null;
    }
}

