/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.parser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import nga.model.UpdatableByText;
import nga.servlet.NameUtil;
import nga.servlet.ServiceInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.dsp.parser.PropertyValue;
import nga.servlet.dsp.parser.PropertyValueParser;
import nga.servlet.dsp.parser.PropertyValueParserCollection;
import nga.servlet.spi.ParameterParser;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;
import nga.util.Resource;

public class DefaultParameterParser
implements ParameterParser {
    private Resource resource = new Resource("nga.servlet.dsp.Message");
    private Map<Class, PropertyValueParser> valueParserMap = new HashMap<Class, PropertyValueParser>();
    private Map<String, Object> containers = new HashMap<String, Object>(400);
    private Object topContainer;
    private PropertyInfoMap propertyInfoMap;
    private PropertyInfo emptyPropertyInfo = new PropertyInfo();
    private ObjectOperator objectOperator = new ObjectOperator();
    private PropertyValue propertyValue;

    public void registerValueParser(Class type, PropertyValueParser parser) {
        this.valueParserMap.put(type, parser);
        this.valueParserMap.put(parser.getClass(), parser);
    }

    public boolean parse(ServiceInfo serviceInfo) throws IOException, ServletException {
        HttpServletRequest request = serviceInfo.getRequest();
        this.containers.clear();
        this.topContainer = serviceInfo.getPageObject();
        this.propertyInfoMap = serviceInfo.getPropertyInfoMap();
        this.propertyValue = new PropertyValue(serviceInfo);
        boolean success = true;
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (key.charAt(0) == '_') continue;
            try {
                if (this.set(key, request.getParameter(key))) continue;
                success = false;
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException(e.getCause());
            }
        }
        return success;
    }

    private boolean set(String fullName, String value) throws IllegalAccessException, InvocationTargetException {
        Object container = this.getContainer(NameUtil.getContainerName(fullName));
        if (container == null) {
            throw new ConfigurationException(this.message("m_no_container", NameUtil.getContainerName(fullName)));
        }
        String fieldName = NameUtil.getFieldName(fullName);
        this.objectOperator.init(container, fieldName, NameUtil.getIndex(fullName));
        PropertyInfo pi = (PropertyInfo)this.propertyInfoMap.get(fieldName);
        if (pi == null) {
            this.emptyPropertyInfo.setName(fullName);
            pi = this.emptyPropertyInfo;
        }
        UpdatableByText forUpdate = this.objectOperator.getUpdatableObject();
        this.propertyValue.setup(fullName, value, pi, forUpdate);
        PropertyValueParser parser = this.getParameterValueParser(pi, this.objectOperator.type);
        if (parser.parse(this.propertyValue)) {
            this.objectOperator.set(this.propertyValue.getObject());
            return true;
        }
        return false;
    }

    private PropertyValueParser getParameterValueParser(PropertyInfo pi, Class type) {
        String parserName;
        if (pi != null && (parserName = PropertyValueParser.getParser(pi)) != null) {
            return this.getPropertyParser(parserName);
        }
        PropertyValueParser parser = this.valueParserMap.get(type);
        if (parser == null) {
            if (UpdatableByText.class.isAssignableFrom(type)) {
                parser = PropertyValueParserCollection.FOR_TEXTCONVERTIBLE;
            } else {
                throw new ConfigurationException(this.message("m_no_parser", type.getSimpleName()));
            }
        }
        return parser;
    }

    private PropertyValueParser getPropertyParser(String parserName) {
        PropertyValueParser parser = this.valueParserMap.get(parserName);
        if (parser == null) {
            try {
                Class<?> c = Class.forName(parserName);
                parser = (PropertyValueParser)c.newInstance();
                this.valueParserMap.put(c, parser);
            }
            catch (Exception e) {
                throw new ConfigurationException(this.message("invalid_class", parserName), e);
            }
        }
        return parser;
    }

    private Object getContainer(String name) throws IllegalAccessException, InvocationTargetException {
        if (name == null) {
            return this.topContainer;
        }
        Object o = this.containers.get(name);
        if (o == null) {
            Object con = this.getContainer(NameUtil.getContainerName(name));
            if (con == null) {
                return null;
            }
            Method m = MethodOperator.getGetterMethod(con.getClass(), NameUtil.getFieldName(name));
            Class<?> rt = m.getReturnType();
            o = MethodOperator.get(m, con);
            if (o == null) {
                return null;
            }
            if (rt.isArray()) {
                o = Array.get(o, NameUtil.getIndex(name));
            } else if (List.class.isAssignableFrom(rt)) {
                o = ((List)o).get(NameUtil.getIndex(name));
            }
            this.containers.put(name, o);
        }
        return o;
    }

    private String message(String key, Object ... args) {
        return this.resource.message(key, args);
    }

    private class ObjectOperator {
        Class type;
        Object container;
        Method setterMethod;
        UpdatableByText object;
        Class arrayType;
        Object array;
        String fieldName;
        int index;

        private ObjectOperator() {
        }

        public UpdatableByText getUpdatableObject() {
            return this.object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(Object value) throws IllegalAccessException, InvocationTargetException {
            if (this.array != null) {
                if (this.arrayType.isArray()) {
                    Array.set(this.array, this.index, value);
                    return;
                } else {
                    if (!List.class.isAssignableFrom(this.arrayType)) throw new ConfigurationException(DefaultParameterParser.this.message("m_invalid_list_type", new Object[]{this.fieldName, this.arrayType}));
                    ((List)this.array).set(this.index, value);
                }
                return;
            } else {
                MethodOperator.set(this.setterMethod, this.container, value);
            }
        }

        private void initArrayType(Object container, String propertyName) throws IllegalAccessException, InvocationTargetException {
            Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
            if (getterMethod == null) {
                throw new ConfigurationException(DefaultParameterParser.this.message("m_no_getter_method", new Object[]{container.getClass().getName(), propertyName}));
            }
            this.arrayType = getterMethod.getReturnType();
            this.array = MethodOperator.get(getterMethod, container);
            if (this.array == null) {
                throw new ConfigurationException(DefaultParameterParser.this.message("m_null_array", new Object[]{propertyName}));
            }
            if (this.arrayType.isArray()) {
                this.type = this.arrayType.getComponentType();
                if (UpdatableByText.class.isAssignableFrom(this.type)) {
                    this.object = (UpdatableByText)Array.get(this.array, this.index);
                }
            } else if (List.class.isAssignableFrom(this.arrayType)) {
                this.type = this.getClass((List)this.array);
                if (UpdatableByText.class.isAssignableFrom(this.type)) {
                    this.object = (UpdatableByText)((List)this.array).get(this.index);
                }
            } else {
                throw new ConfigurationException(DefaultParameterParser.this.message("m_invalid_list_type", new Object[]{propertyName, this.arrayType}));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void init(Object container, String propertyName, int index) throws IllegalAccessException, InvocationTargetException {
            this.type = null;
            this.object = null;
            this.array = null;
            this.arrayType = null;
            this.setterMethod = null;
            this.container = container;
            this.fieldName = propertyName;
            this.index = index;
            if (index > -1) {
                this.initArrayType(container, propertyName);
                return;
            }
            this.setterMethod = MethodOperator.getSetterMethod(container.getClass(), propertyName);
            if (this.setterMethod == null) {
                Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
                if (getterMethod == null) {
                    throw new ConfigurationException(DefaultParameterParser.this.message("m_no_setter_method", new Object[]{container.getClass().getName(), propertyName}));
                }
                this.type = getterMethod.getReturnType();
                if (!UpdatableByText.class.isAssignableFrom(this.type)) throw new ConfigurationException(DefaultParameterParser.this.message("m_no_setter_method", new Object[]{container.getClass().getName(), propertyName}));
                this.object = (UpdatableByText)MethodOperator.get(getterMethod, container);
                return;
            } else {
                Method getterMethod;
                Class<?>[] pt = this.setterMethod.getParameterTypes();
                if (pt == null || pt.length == 0) {
                    throw new ConfigurationException(DefaultParameterParser.this.message("m_invalid_setter_method", new Object[]{container.getClass().getName(), propertyName}));
                }
                this.type = pt[0];
                if (!UpdatableByText.class.isAssignableFrom(this.type) || (getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName)) == null) return;
                this.type = getterMethod.getReturnType();
                this.object = (UpdatableByText)MethodOperator.get(getterMethod, container);
            }
        }

        private Class getClass(List list) {
            for (int i = 0; i < list.size(); ++i) {
                Object o = list.get(i);
                if (o == null) continue;
                return o.getClass();
            }
            return null;
        }
    }
}

