/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import nga.model.UpdatableByText;
import nga.servlet.ErrorInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.dsp.parser.PropertyValue;
import nga.servlet.dsp.parser.PropertyValueParser;
import nga.util.FormatUtil;

public class PropertyValueParserCollection {
    public static final PropertyValueParser FOR_STRING = new StringPropertyParser();
    public static final PropertyValueParser FOR_CHARACTOR = new CharactorPropertyParser();
    public static final PropertyValueParser FOR_BOOLEAN = new BooleanPropertyParser();
    public static final PropertyValueParser FOR_INTEGER = new IntegerPropertyParser();
    public static final PropertyValueParser FOR_LONG = new LongPropertyParser();
    public static final PropertyValueParser FOR_SHORT = new ShortPropertyParser();
    public static final PropertyValueParser FOR_BYTE = new BytePropertyParser();
    public static final PropertyValueParser FOR_FLOAT = new FloatPropertyParser();
    public static final PropertyValueParser FOR_DOUBLE = new DoublePropertyParser();
    public static final PropertyValueParser FOR_BIGDECIMAL = new BigDecimalPropertyParser();
    public static final PropertyValueParser FOR_BIGINTEGER = new BigIntegerPropertyParser();
    public static final PropertyValueParser FOR_DATE = new DatePropertyParser();
    public static final PropertyValueParser FOR_SQLDATE = new SqlDatePropertyParser();
    public static final PropertyValueParser FOR_SQLTIME = new SqlTimePropertyParser();
    public static final PropertyValueParser FOR_SQLTIMESTAMP = new SqlTimestampPropertyParser();
    public static final PropertyValueParser FOR_TEXTCONVERTIBLE = new TextConvertibleParser();

    public static class TextConvertibleParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (!this.checkRequired(pv)) {
                return false;
            }
            String value = pv.getValue();
            if (value == null || value.length() == 0) {
                return true;
            }
            try {
                ((UpdatableByText)pv.getObject()).update(value);
            }
            catch (ParseException e) {
                PropertyInfo constraints = pv.getPropertyInfo();
                ErrorInfo errorInfo = pv.getErrorInfo();
                String name = pv.getName();
                String label = TextConvertibleParser.getLabel(constraints);
                if (label != null) {
                    errorInfo.add(name, value, "m_cannot_text_convert2", value, label);
                } else {
                    errorInfo.add(name, value, "m_cannot_text_convert1", value);
                }
                return false;
            }
            return true;
        }
    }

    public static class SqlTimestampPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (this.toDate(pv, pv.getResourceText("f_timestamp"))) {
                pv.setObject(FormatUtil.toTimestamp((Date)pv.getObject()));
                return true;
            }
            return false;
        }
    }

    public static class SqlTimePropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (this.toDate(pv, pv.getResourceText("f_time"))) {
                pv.setObject(FormatUtil.toTime((Date)pv.getObject()));
                return true;
            }
            return false;
        }
    }

    public static class SqlDatePropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (this.toDate(pv, pv.getResourceText("f_date"))) {
                pv.setObject(FormatUtil.toDate((Date)pv.getObject()));
                return true;
            }
            return false;
        }
    }

    public static class DatePropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            return this.toDate(pv, pv.getResourceText("f_date"));
        }
    }

    public static class BigIntegerPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new BigInteger(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class BigDecimalPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new BigDecimal(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class DoublePropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Double(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class FloatPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Float(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class BytePropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Byte(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class ShortPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Short(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class LongPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Long(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class IntegerPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            String s = this.delC(value);
            try {
                if (this.checkNum(pv)) {
                    pv.setObject(s != null ? new Integer(s) : null);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return this.handleNumberFormatException(pv);
            }
        }
    }

    public static class BooleanPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            String value = pv.getValue();
            if (value == null) {
                pv.setObject(Boolean.FALSE);
                return true;
            }
            pv.setObject(Boolean.valueOf(value));
            return true;
        }
    }

    public static class CharactorPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (!this.checkRequired(pv)) {
                return false;
            }
            String value = pv.getValue();
            if (value == null || value.length() == 0) {
                pv.setObject(null);
                return true;
            }
            if (!this.checkCharType(pv)) {
                return false;
            }
            pv.setObject(Character.valueOf(value.charAt(0)));
            return true;
        }
    }

    public static class StringPropertyParser
    extends PropertyValueParser {
        public boolean parse(PropertyValue pv) {
            if (!this.checkRequired(pv)) {
                return false;
            }
            String value = pv.getValue();
            if (value == null || value.length() == 0) {
                pv.setObject(null);
                return true;
            }
            if (!this.checkLength(pv)) {
                return false;
            }
            if (!this.checkByteLength(pv)) {
                return false;
            }
            if (!this.checkCharType(pv)) {
                return false;
            }
            pv.setObject(value);
            return true;
        }
    }
}

