/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.spi.ResultWriter;

public abstract class AbstractResultWriter
implements ResultWriter {
    private String page;
    private String errorPage;

    public void write(ServiceInfo serviceInfo) throws IOException, ServletException {
        String errorPage;
        HttpServletRequest request = serviceInfo.getRequest();
        HttpServletResponse response = serviceInfo.getResponse();
        ResultInfo resultInfo = serviceInfo.getRequestInfo().getResultInfo();
        if (serviceInfo.getErrorInfo().hasError() && (errorPage = this.getErrorPage(resultInfo)) != null) {
            request.getRequestDispatcher(errorPage).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String page = this.getPage(resultInfo);
        if (page != null) {
            request.getRequestDispatcher(page).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.handleWrite(serviceInfo);
    }

    protected abstract void handleWrite(ServiceInfo var1) throws IOException, ServletException;

    protected String getPage(ResultInfo resultInfo) {
        return resultInfo.get("page", this.page);
    }

    protected void setPage(String page) {
        this.page = page;
    }

    protected String getErrorPage(ResultInfo resultInfo) {
        return resultInfo.get("error-page", this.errorPage);
    }

    protected void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }
}

