/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nga.servlet.ErrorInfo;
import nga.servlet.ServiceInfo;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.AbstractResultWriter;
import nga.servlet.dsp.writer.DefaultTargetValueWriter;
import nga.servlet.dsp.writer.TargetValue;
import nga.servlet.dsp.writer.TargetValueWriter;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;
import nga.util.Resource;

public class DefaultResultWriter
extends AbstractResultWriter {
    public static final TargetValueWriter DEFAULT = new DefaultTargetValueWriter();
    private static final String TARGET_VALUE = "nga.dsp.target.value";
    private Map<Class, TargetValueWriter> valueWriterMap = new HashMap<Class, TargetValueWriter>();
    private Map<String, Method> methodMap;

    protected void handleWrite(ServiceInfo serviceInfo) throws IOException, ServletException {
        Object resultObject = serviceInfo.getResultObject();
        HttpServletResponse response = serviceInfo.getResponse();
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<c");
        ErrorInfo errorInfo = serviceInfo.getErrorInfo();
        if (errorInfo.getException() != null) {
            errorInfo.getException().printStackTrace();
            String s = errorInfo.getException().getMessage();
            if (s == null) {
                s = errorInfo.getException().getClass().getName();
            }
            this.printMessage(writer, s);
        } else if (errorInfo.getErrorMessage() != null) {
            System.err.println(errorInfo.getErrorMessage());
            this.printMessage(writer, errorInfo.getErrorMessage());
        }
        if (errorInfo.hasError()) {
            writer.print(" is-error=\"true\"");
        }
        writer.println(">");
        if (resultObject != null) {
            this.methodMap = MethodOperator.getGetterMethods(resultObject.getClass());
        }
        TargetInfoList targetInfoList = serviceInfo.getTargetInfoList();
        for (int i = 0; i < targetInfoList.size(); ++i) {
            String type;
            TargetInfo ti = (TargetInfo)targetInfoList.get(i);
            writer.print("<e");
            ErrorInfo.Item item = (ErrorInfo.Item)errorInfo.get(ti.getValue());
            if (item != null) {
                writer.print(" is-error=\"true\"");
                String message = item.getMessage();
                if (message != null) {
                    this.printMessage(writer, message);
                }
            }
            String cdata = (String)ti.get("cdata");
            String include = ti.getInclude();
            TargetValueWriter valueWriter = null;
            if (include == null) {
                valueWriter = this.getWriter(ti);
            }
            if ((type = ti.getType()) == null && (include != null || valueWriter.isGenerateInnerHTML())) {
                type = "inner";
            }
            if (cdata == null && type != null) {
                cdata = "true";
            }
            if (type != null) {
                writer.print(" type=\"");
                writer.print(type);
                writer.print("\"");
            }
            TargetValue targetValue = new TargetValue(serviceInfo, writer, resultObject);
            for (Map.Entry property : ti.entrySet()) {
                String s = (String)property.getKey();
                if ("value".equals(s) || "cdata".equals(s) || "type".equals(s) || "page".equals(s) || "writer".equals(s)) continue;
                writer.print(" ");
                writer.print(s);
                writer.print("=\"");
                writer.print((String)property.getValue());
                writer.print("\"");
            }
            if ("true".equals(cdata)) {
                writer.println("><![CDATA[");
            } else {
                writer.print(">");
            }
            Object o = null;
            try {
                String valueName = ti.getValue();
                if (valueName != null) {
                    o = MethodOperator.get(this.methodMap.get(valueName), resultObject);
                }
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException(e.getCause());
            }
            targetValue.setup(o, ti);
            HttpServletRequest request = serviceInfo.getRequest();
            request.setAttribute(TARGET_VALUE, (Object)targetValue);
            if (include != null) {
                request.getRequestDispatcher(include).include((ServletRequest)request, (ServletResponse)response);
            } else {
                valueWriter.write(targetValue);
            }
            if ("true".equals(cdata)) {
                writer.println("]]>");
            }
            writer.println("</e>");
        }
        writer.println("</c>");
    }

    private void printMessage(PrintWriter writer, String message) {
        writer.print(" message=\"");
        writer.print(WriterUtil.format(message));
        writer.print("\"");
    }

    private TargetValueWriter getWriter(TargetInfo ti) {
        String writerName = (String)ti.get("writer");
        if (writerName != null) {
            return this.getWriter(writerName);
        }
        return DEFAULT;
    }

    private TargetValueWriter getWriter(String writerName) {
        TargetValueWriter writer = this.valueWriterMap.get(writerName);
        if (writer == null) {
            try {
                Class<?> c = Class.forName(writerName);
                writer = (TargetValueWriter)c.newInstance();
                this.valueWriterMap.put(c, writer);
            }
            catch (Exception e) {
                throw new ConfigurationException(Resource.getMessage("nga.sevlet.dsp.Message", "m_invalid_writer_class", writerName), e);
            }
        }
        return writer;
    }

    public static TargetValue getTargetValue(HttpServletRequest request) {
        return (TargetValue)request.getAttribute(TARGET_VALUE);
    }
}

