/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.util.Formatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nga.util.UserLocale;

public class Resource {
    private ResourceBundle resource;
    private Resource parent;

    public Resource(String resourceName) {
        this(resourceName, Locale.getDefault());
    }

    public Resource(String resourceName, Locale locale) {
        this.resource = ResourceBundle.getBundle(resourceName, locale);
    }

    public void setParent(Resource parent) {
        this.parent = parent;
    }

    public String message(String key, Object ... args) {
        if (args == null || args.length == 0) {
            return this.get(key);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = this.get((String)args[i]);
        }
        return new Formatter(UserLocale.getLocale()).format(this.get(key), args).toString();
    }

    public String get(String key) {
        try {
            return this.resource.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.parent != null) {
                return this.parent.get(key);
            }
            return key;
        }
    }

    public static String getMessage(String resourceName, String key, Object ... args) {
        return new Resource(resourceName).message(key, args);
    }

    public static String getMessage(String resourceName, Locale locale, String key, Object ... args) {
        return new Resource(resourceName, locale).message(key, args);
    }

    public static String getText(String resourceName, String key) {
        return new Resource(resourceName).get(key);
    }

    public static String getText(String resourceName, Locale locale, String key) {
        return new Resource(resourceName, locale).get(key);
    }
}

