/*
 * celcel.js
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

/**
 * Celcel 쐬B
 * @param table CelcelΏۃe[uB
 * @param fixRows Œ\sB
 * @param fixColumns Œ\񐔁B
 */
function Celcel(table, fixRows, fixColumns) {

	if(!Celcel.prototype.SCROLL_MARGIN) {
		Celcel.prototype.SCROLL_MARGIN = 16;
	}

	if(!Celcel.prototype.BORDER_WIDTH) {
		Celcel.prototype.BORDER_WIDTH = 4;
	}

	if(!arguments[1]) {
		fixRows = 0;
	}
	if(!arguments[2]) {
		fixColumns = 0;
	}

	fixRows = parseInt(fixRows);
	fixColumns = parseInt(fixColumns);

	var container = table.parentNode;

	var celcel = document.createElement("div");
	celcel.className = "celcel";
	celcel.style.position = "relative";

	/**
	 * HTML̗vfIuWFNgB
	 */
	this.htmlElement = celcel;

	/**
	 * I[hB
	 */
	this.selectionMode = "cell";

	/**
	 * I
	 */
	this.autoSelection = false;

	container.appendChild(celcel);
	handler = this;

	// col 擾B
	var colList = table.getElementsByTagName("col");

	// table 
	var headerDiv = _celcel_createDiv(handler, celcel, null, colList, 0, fixColumns);
	var rowHeaderDiv = _celcel_createDiv(handler, celcel, null, colList, 0, fixColumns);
	var columnHeaderDiv = _celcel_createDiv(handler, celcel, null, colList, fixColumns, colList.length);
	var detailDiv = _celcel_createDiv(handler, celcel, table, colList, fixColumns, colList.length);

	var header = headerDiv.firstChild;
	var rowHeader = rowHeaderDiv.firstChild;
	var columnHeader  = columnHeaderDiv.firstChild;
	var detail = table;

	// ContextMenu 쐬
	var menu = new IMenu();


	var rowLength = table.rows.length;
	var rowIndex = 0;
	for(var i=0; i < rowLength; i++) {
		var headerTr = null;
		var columnHeaderTr = null;
		var rowHeaderTr = null;

		var row = table.rows[rowIndex];
		var rowHeight = row.scrollHeight;

		if(i < fixRows) {
			headerTr = _celcel_createTr(header, rowHeight);
			columnHeaderTr = _celcel_createTr(columnHeader, rowHeight);
		}
		else {
			if(fixColumns > 0) {
				rowHeaderTr = _celcel_createTr(rowHeader, rowHeight);
			}
			rowIndex++;
		}

		var colLength = row.cells.length;
		var columnInex = 0;
		for(var j=0; j < colLength; j++) {
			var column = row.cells[columnInex];
			if(j < fixColumns) {
				if(headerTr) {
					_celcel_moveChild(row, headerTr, column);
					
					if(!_celcel_getInputNode(column)) {
						if(i==0) {
							if(j==0) {
								column.onclick = _celcel_header_onclick;
							}
							else {
								column.onclick = _celcel_columnHeader_onclick;
							}
						}
						else {
							if(j==0) {
								column.onclick = _celcel_rowHeader_onclick;
							}
						}
					}
				}
				else if(rowHeaderTr) {
					_celcel_moveChild(row, rowHeaderTr, column);
					if(j==0 && !_celcel_getInputNode(column)) {
						column.onclick = _celcel_rowHeader_onclick;
					}
				}
				else {
					// detail ɂ̂܂܎cB
					columnInex++;
				}
			}
			else {
				if(columnHeaderTr) {
					_celcel_moveChild(row, columnHeaderTr, column);
					if(i==0 && !_celcel_getInputNode(column)) {
						column.onclick = _celcel_columnHeader_onclick;
					}
				}
				else {
					// detail ɂ̂܂܎cB
					columnInex++;
				}
			}
			_celcel_setEvent(column, menu);
		}
		if(i < fixRows) {
			detail.getElementsByTagName("tbody").item(0).removeChild(row);
		}
	}


	// wb_ݒ
//	_celcel_initColumBorder(header, rowHeader, columnHeaderDiv);
//	_celcel_initColumBorder(rowHeader, header, detailDiv);
	_celcel_initColumBorder(columnHeader, detail, null);
	_celcel_initColumBorder(detail, columnHeader, null);

	// ʒuݒ
	headerDiv.style.position = "absolute";
	rowHeaderDiv.style.position = "absolute";
	columnHeaderDiv.style.position = "absolute";
	detailDiv.style.position = "absolute";

	headerDiv.style.top = 0;
	headerDiv.style.left = 0;

	columnHeaderDiv.style.top = 0;

	rowHeaderDiv.style.top = headerDiv.scrollHeight;
	detailDiv.style.top = columnHeaderDiv.scrollHeight;

	columnHeaderDiv.style.left = headerDiv.scrollWidth;
	detailDiv.style.left = rowHeaderDiv.scrollWidth;

	detailDiv.onscroll = function() {
		columnHeaderDiv.scrollLeft = detailDiv.scrollLeft;
		rowHeaderDiv.scrollTop = detailDiv.scrollTop;
	}
	rowHeaderDiv.onscroll = function() {
		detailDiv.scrollTop = rowHeaderDiv.scrollTop;
	}
	columnHeaderDiv.onscroll = function() {
		detailDiv.scrollLeft = columnHeaderDiv.scrollLeft;
	}


	// \bh`

	/**
	 * Iꂽ͈͂̓eNAB
	 */
	this.clear = function() {
		_celcel_clear(header);
		_celcel_clear(rowHeader);
		_celcel_clear(columnHeader);
		_celcel_clear(detail);
	}

	/**
	 * Iꂽ͈͂̓eNbv{[hɃRs[B
	 */
	this.copy = function() {
		_celcel_copy(header, rowHeader, columnHeader, detail);
	}

	/**
	 * e[uŜ̓eNbv{[hɃRs[B
	 */
	this.copyAll = function() {
		_celcel_copyAll(header, rowHeader, columnHeader, detail);
	}

	/**
	 * Iꂽ͈͂̓e̐؂iNbv{[hւ̃Rs[ƃNAjsȂB
	 */
	this.cut = function() {
		_celcel_copy(header, rowHeader, columnHeader, detail);
		handler.clear();
	}

	/**
	 * ݂̃Nbv{[h̓e\tB
	 */
	this.paste = function() {
		_celcel_paste(handler);
	}

	/**
	 * I͈݂͂邩ǂ𒲂ׂB
	 * @return I͈݂͂ꍇ trueB
	 */
	this.hasSelection = function() {
		return header.selection || rowHeader.selection || 
				columnHeader.selection || detail.selection;
	}

	/**
	 * \̕ݒ肷B
	 * @param width \̕B
	 */
	this.setWidth = function(width) {
		width = parseInt(width);
		columnHeaderDiv.style.width = width;
		detailDiv.style.width = width + _celcel_getScrollMargin(detailDiv);
		celcel.style.width = rowHeaderDiv.scrollWidth + parseInt(detailDiv.style.width);
	}

	/**
	 * \̍ݒ肷B
	 * @param height \̍B
	 */
	this.setHeight = function(height) {
		height = parseInt(height);
		rowHeaderDiv.style.height = height;
		detailDiv.style.height = height + _celcel_getScrollMargin(detailDiv);
		celcel.style.height = columnHeaderDiv.scrollHeight + parseInt(detailDiv.style.height);
	}

	/**
	 * \̃TCYݒ肷B
	 * @param width \̕B
	 * @param height \̍B
	 */
	this.setSize = function(width, height) {
		handler.setWidth(width);
		handler.setHeight(height);
	}

	/**
	 * XN[o[\邩Ȃݒ肷B
	 * @param scroll XN[o[\ꍇ true w肷B
	 */
	this.setScroll = function(scroll) {
		if(scroll) {
			if(detailDiv.style.overflow!="scroll") {
				detailDiv.style.overflow = "scroll";
			}
			else {
				return;
			}
		}
		else {
			detailDiv.style.overflow = "hidden";
			detailDiv.style.width = parseInt(detailDiv.style.width) - Celcel.prototype.SCROLL_MARGIN
			detailDiv.style.height = parseInt(detailDiv.style.height) - Celcel.prototype.SCROLL_MARGIN
		}
		handler.setSize(parseInt(detailDiv.style.width), parseInt(detailDiv.style.height));
	}

	this.setSize(detailDiv.scrollWidth, detailDiv.scrollHeight);


	// ݎQƍ쐬
	header.rightTable = columnHeader;
	header.lowerTable = rowHeader;
	header.crossTable = detail;

	rowHeader.upperTable = header;
	rowHeader.rightTable = detail;
	rowHeader.crossTable = columnHeader;

	columnHeader.leftTable = header;
	columnHeader.lowerTable = detail;
	columnHeader.crossTable = rowHeader;

	detail.leftTable = rowHeader;
	detail.upperTable = columnHeader;
	detail.crossTable = header;

	/**
	 * ReNXgj[֍ڒǉsȂB
	 * @param text ږ́B
	 * @param func j[NbNɎst@NVB
	 */
	this.addMenu = function(text, func) {
		menu.addItem(text, func);
	}
	this.addMenu("copyAll", handler.copyAll);
	this.addMenu("copy", handler.copy);
	this.addMenu("cut", handler.cut);
	this.addMenu("paste", handler.paste);
	this.addMenu("clear", handler.clear);

	/**
	 * ReNXgj[\B
	 * @param event j[\̋NƂȂCxgB
	 */
	this.showMenu = function(event) {
		menu.setEnabled("copyAll", true);
		var hasSelection = handler.hasSelection();
		menu.setEnabled("copy", hasSelection);
		menu.setEnabled("cut", hasSelection);
		menu.setEnabled("paste", hasSelection);
		menu.setEnabled("clear", hasSelection);
		menu.show(event);
	}

	header.menu = menu;
	rowHeader.menu = menu;
	columnHeader.menu = menu;
	detail.menu = menu;
}

function _celcel_getScrollMargin(detailDiv) {
	if(detailDiv.style.overflow=="scroll") {
		return Celcel.prototype.SCROLL_MARGIN;
	}
	else {
		return 0;
	}
}

function _celcel_initColumBorder(table, friend, rightDiv) {
	var HELF_BORDER_WIDTH = Celcel.prototype.BORDER_WIDTH/2;

	table.columnBorder = new Array();

	var border = table.border;
	var colRight = parseInt(border);

	colList = table.getElementsByTagName("col");
	for(var i = 0; i < colList.length; i++) {
		var col = colList.item(i);
		col.leftPos = colRight;

		col.rightCols = new Array();
		for(var j = i+1; j< colList.length; j++) {
			col.rightCols[j-i-1] = colList.item(j);
		}

		colRight = col.leftPos + col.scrollWidth;

		var b = new IBorder(table.parentNode, "vertical", table.scrollHeight, Celcel.prototype.BORDER_WIDTH);
		table.columnBorder[i] = b;
		b.col = col;
		b.index = i;
		if(i + 1 == colList.length) {
			b.rightDiv = rightDiv;
			col.rightDiv = rightDiv;
		}
		b.setPosition(colRight-HELF_BORDER_WIDTH, 0);

		col.border = b.htmlElement;
		col.colRight = colRight;

		b.onmove = function(left, top) {
			_celcel_onmove(this, left, top);
			friend.columnBorder[this.index].col.border.style.left = left;
			_celcel_onmove(friend.columnBorder[this.index], left, top);
		}
	}
}

function _celcel_onmove(border, left, top) {
	left = left + Celcel.prototype.BORDER_WIDTH/2;

	var currentWidth = border.col.scrollWidth;
	var newWidth = left - border.col.leftPos;
	if(newWidth < 0) {
		border.col.border.style.left = border.col.colRight;
		return;
	}

	border.col.style.width = newWidth;

	// 񕝂k܂Ȃꍇ̕␳
	if(border.col.scrollWidth > newWidth) {
		newWidth = border.col.scrollWidth;
		border.col.style.width = newWidth;
		left = border.col.leftPos + newWidth;
		border.col.border.style.left = left;
	}

	border.col.colRight = left;
	var diff = border.col.scrollWidth - currentWidth;
	for(var i=0; i<border.col.rightCols.length; i++) {
		border.col.rightCols[i].leftPos =
			border.col.rightCols[i].leftPos + diff;
		border.col.rightCols[i].border.style.left =
			parseInt(border.col.rightCols[i].border.style.left) + diff;
		if(border.col.rightCols[i].rightDiv) {
			border.col.rightCols[i].rightDiv.style.left = border.col.rightCols[i].border.style.left;
		}
	}

	if(border.rightDiv) {
		border.rightDiv.style.left = left;
	}
}

function _celcel_getInputNode(column) {
	var childlen = column.childNodes;
	for(var j=0; j < childlen.length; j++) {
		var child = childlen.item(j);
		if(child.nodeType && child.nodeType!=1) {
			continue;
		}
		return child;
	}
	return null;
}

function _celcel_setEvent(column, menu) {
	var input = _celcel_getInputNode(column);
	if(input) {
		input.onkeydown = _celcel_onkeydown;
		input.onfocus = _celcel_onfocus;
		input.onclick = _celcel_onclick;

		menu.addTarget(input);
		input.onmouseover = _celcel_onmouseover;
	}

	menu.addTarget(column);
	column.onmouseover = _celcel_onmouseover;
}

function _celcel_moveChild(src, dst, child) {
	src.removeChild(child);
	dst.appendChild(child);
}

function _celcel_createTr(table, rowHeight) {
	var tr = document.createElement("tr");
	tr.style.height = rowHeight;
	table.getElementsByTagName("tbody").item(0).appendChild(tr);
	return tr;
}

function _celcel_createDiv(handler, celcel, table, colList, startCol, colCount) {
	var div = document.createElement("div");
	div.className = "table-div";
	celcel.appendChild(div);
	div.style.display = "inline";

	if(table) {
		div.style.overflow = "scroll";
		_celcel_initTableStyle(table);
		for(var i=startCol-1; i >= 0; i--) {
			var parent = colList.item(i).parentNode;
			parent.removeChild(colList.item(i));
		}
		table.parentNode.removeChild(table);
		div.appendChild(table);
	}
	else {
		div.style.overflow = "hidden";
		table = document.createElement("table");
		_celcel_initTableStyle(table);
		div.appendChild(table);
		colgroup = document.createElement("colgroup");
		table.appendChild(colgroup);

		for(var i=startCol; i < colCount; i++) {
			var col = document.createElement("col");
			col.style.width = colList.item(i).style.width;
			colgroup.appendChild(col);
		}
		table.appendChild(document.createElement("tbody"));
	}
	table.border = "1";
	table.handler = handler;

	return div;
}

function _celcel_initTableStyle(table) {
	table.style.borderCollapse = "collapse";
	table.style.position = "relative";
    table.style.tableLayout = "fixed";
}


function _celcel_getTable(obj) {
	while(obj) {
		if(obj.nodeName=="TABLE") {
			return obj;
		}
		obj = obj.parentNode;
	}
}

function _celcel_getNextRow(input) {
	var row = _celcel_getRow(input).nextSibling;
	return _celcel_getNextNode(row); // for Moz
}

function _celcel_getNextNode(node) {
	if(node && node.nodeType && node.nodeType!=1) {
		node = node.nextSibling;
	}
	return node;
}

function _celcel_isAvailableTable(table) {
	return table && table.rows.length > 0;
}

function _celcel_getNextInput(table, input, moveNextRow) {
	var column = _celcel_getColumn(input);
	var nextInput = _celcel_getFirstInputInRow(column.parentNode, column.cellIndex + 1);

	if(nextInput) {
		return nextInput;
	}

	if(_celcel_isAvailableTable(table.rightTable)) {
		nextInput = _celcel_getFirstInputInRow(
						table.rightTable.rows[column.parentNode.rowIndex], 0);
		if(nextInput) {
			return nextInput;
		}
	}

	if(!moveNextRow) {
		return null;
	}

	var row = _celcel_getNextRow(input);
	if(row && _celcel_isAvailableTable(table.leftTable)) {
		table = table.leftTable;
		row = table.rows[row.rowIndex];
	}
	else if(!row && _celcel_isAvailableTable(table.crossTable)) {
		table = table.crossTable;
		row = table.rows[0];
	}

	if(!row) {
		return null;
	}

	input = _celcel_getFirstInputInRow(row, 0);
	if(!input && table && _celcel_isAvailableTable(table.rightTable)) {
		input = _celcel_getFirstInputInRow(table.rightTable.rows[row.rowIndex], 0);
	}
	return input;
}

function _celcel_getUpperInput(table, input) {
	var column = _celcel_getColumn(input);
	var rowIndex = column.parentNode.rowIndex - 1;
	var prevInput = _celcel_getLastInputInColumn(table, column.cellIndex, rowIndex);
	if(prevInput) {
		return prevInput;
	}

	if(table.upperTable) {
		prevInput = _celcel_getLastInputInColumn(
				table.upperTable, column.cellIndex, table.upperTable.rows.length-1);
		if(prevInput) {
			return prevInput;
		}
	}

	return input;
}

function _celcel_getLowerInput(table, input) {
	var column = _celcel_getColumn(input);
	var rowIndex = column.parentNode.rowIndex + 1;
	var nextInput = _celcel_getFirstInputInColumn(table, column.cellIndex, rowIndex);

	if(nextInput) {
		return nextInput;
	}

	if(table.lowerTable) {
		nextInput = _celcel_getFirstInputInColumn(table.lowerTable, column.cellIndex, 0);
		if(nextInput) {
			return nextInput;
		}
	}

	return input;
}

function _celcel_getRow(input) {
	return _celcel_getColumn(input).parentNode;
}

function _celcel_getPrevRow(input) {
	var row = _celcel_getRow(input).previousSibling;
	return _celcel_getPrevNode(row); // for Moz
}


function _celcel_getColumn(input) {
	return input.parentNode;
}

function _celcel_getPrevNode(node) {
	if(node && node.nodeType && node.nodeType!=1) {
		node = node.previousSibling;
	}
	return node;
}

function _celcel_getPrevInput(table, input, movePrevRow) {
	var column = _celcel_getColumn(input);
	var prevInput = _celcel_getLastInputInRow(column.parentNode, column.cellIndex - 1);

	if(prevInput) {
		return prevInput;
	}

	if(_celcel_isAvailableTable(table.leftTable)) {
		var leftRow = table.leftTable.rows[column.parentNode.rowIndex];
		prevInput = _celcel_getLastInputInRow(leftRow, leftRow.cells.length - 1);
		if(prevInput) {
			return prevInput;
		}
	}

	if(!movePrevRow) {
		return null;
	}
	var row = _celcel_getPrevRow(input);
	if(row && _celcel_isAvailableTable(table.rightTable)) {
		table = table.rightTable;
		row = table.rows[row.rowIndex];
	}
	else if(!row && _celcel_isAvailableTable(table.crossTable)) {
		table = table.crossTable;
		row = table.rows[table.rows.length-1];
	}

	if(!row) {
		return null;
	}
	input = _celcel_getLastInputInRow(row, row.cells.length - 1);
	if(!input && table && _celcel_isAvailableTable(table.leftTable)) {
		input = _celcel_getLastInputInRow(table.leftTable.rows[row.rowIndex], 
									table.leftTable.rows[row.rowIndex].cells.length - 1);
	}
	return input;
}


function _celcel_addSelection(table, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex) {
	if(!table.selection) {
		table.selection = new Array();
	}

	for(var i=startRowIndex; i<=endRowIndex; i++) {
		for(var j=startColumnIndex; j<=endColumnIndex; j++) {
			var column = table.rows[i].cells[j];
			var input = _celcel_getInputNode(column);
			if(input) {
				input.style.backgroundColor = "#ccccff";
				table.selection.push(input);
				column.style.backgroundColor = "#ccccff";
			}
		}
	}
}


function _celcel_initSelectionStartIndex(table, rowIndex, columnIndex) {

	if(!table.handler.selectionStartingTable || 
			table.handler.selectionStartingTable==table) {
		table.selectionStartRowIndex = rowIndex;
		table.selectionStartColumnIndex = columnIndex;
		return;
	}

	if(table.handler.selectionStartingTable==table.crossTable) {
		if(table.lowerTable) {
			table.selectionStartRowIndex = table.rows.length - 1;
		}
		else {
			table.selectionStartRowIndex = 0;
		}

		if(table.rightTable) {
			table.selectionStartColumnIndex = table.rows[0].cells.length - 1;
		}
		else {
			table.selectionStartColumnIndex = 0;
		}
	}
	else if(table.handler.selectionStartingTable==table.lowerTable) {
		table.selectionStartRowIndex = table.rows.length - 1;
		table.selectionStartColumnIndex = table.lowerTable.selectionStartColumnIndex;
	}
	else if(table.handler.selectionStartingTable==table.upperTable) {
		table.selectionStartRowIndex = 0;
		table.selectionStartColumnIndex = table.upperTable.selectionStartColumnIndex;
	}
	else if(table.handler.selectionStartingTable==table.rightTable) {
		table.selectionStartRowIndex = table.rightTable.selectionStartRowIndex;
		table.selectionStartColumnIndex = table.rows[0].cells.length - 1;
	}
	else if(table.handler.selectionStartingTable==table.leftTable) {
		table.selectionStartRowIndex = table.leftTable.selectionStartRowIndex;
		table.selectionStartColumnIndex = 0;
	}
}


function _celcel_updateCellSelection(input) {
	if(!input) {
		return false;
	}

	var table = _celcel_getTable(input);
	var rowIndex = _celcel_getRow(input).rowIndex;
	var columnIndex = _celcel_getColumn(input).cellIndex;

	_celcel_updateSelectionForEndingTable(table, rowIndex, columnIndex);
	_celcel_updateSelectionForOtherTable(table, rowIndex, columnIndex);

	return true;
}

function _celcel_updateSelectionForOtherTable(table, rowIndex, columnIndex) {

	if(table.handler.selectionStartingTable==table) { // SăNA
		_celcel_clearSelection(table.leftTable);
		_celcel_clearSelection(table.rightTable);
		_celcel_clearSelection(table.lowerTable);
		_celcel_clearSelection(table.upperTable);
		_celcel_clearSelection(table.crossTable);
	}
	else if(table.handler.selectionStartingTable==table.leftTable) {
		_celcel_clearSelection(table.lowerTable);
		_celcel_clearSelection(table.upperTable);
		_celcel_clearSelection(table.crossTable);
		_celcel_updateSelectionForEndingTable(table.leftTable, 
			rowIndex, table.leftTable.rows[0].cells.length - 1);
	}
	else if(table.handler.selectionStartingTable==table.rightTable) {
		_celcel_clearSelection(table.lowerTable);
		_celcel_clearSelection(table.upperTable);
		_celcel_clearSelection(table.crossTable);
		_celcel_updateSelectionForEndingTable(table.rightTable, rowIndex, 0);
	}
	else if(table.handler.selectionStartingTable==table.upperTable) {
		_celcel_clearSelection(table.leftTable);
		_celcel_clearSelection(table.rightTable);
		_celcel_clearSelection(table.crossTable);
		_celcel_updateSelectionForEndingTable(table.upperTable, 
			table.upperTable.rows.length - 1, columnIndex);
	}
	else if(table.handler.selectionStartingTable==table.lowerTable) {
		_celcel_clearSelection(table.leftTable);
		_celcel_clearSelection(table.rightTable);
		_celcel_clearSelection(table.crossTable);
		_celcel_updateSelectionForEndingTable(table.lowerTable, 0, columnIndex);
	}
	else if(table.handler.selectionStartingTable==table.crossTable) {
		var columnIndexForCross;
		var rowIndexForCross;
		if(table.leftTable) {
			columnIndexForCross = table.leftTable.rows[0].cells.length - 1;
			_celcel_updateSelectionForEndingTable(table.leftTable, rowIndex, columnIndexForCross);
		}
		if(table.rightTable) {
			columnIndexForCross = 0;
			_celcel_updateSelectionForEndingTable(table.rightTable, rowIndex, columnIndexForCross);
		}
		if(table.upperTable) {
			rowIndexForCross = table.upperTable.rows.length - 1;
			_celcel_updateSelectionForEndingTable(table.upperTable, rowIndexForCross, columnIndex);
		}
		if(table.lowerTable) {
			rowIndexForCross = 0;
			_celcel_updateSelectionForEndingTable(table.lowerTable, rowIndexForCross, columnIndex);
		}
		_celcel_updateSelectionForEndingTable(table.crossTable, rowIndexForCross, columnIndexForCross);
	}
}

function _celcel_updateSelectionForEndingTable(table, rowIndex, columnIndex) {

	if(!table.selection) {
		_celcel_initSelectionStartIndex(table, rowIndex, columnIndex);

		table.selectionMinRowIndex = table.selectionStartRowIndex;
		table.selectionMaxRowIndex = table.selectionStartRowIndex;

		table.selectionMinColumnIndex = table.selectionStartColumnIndex
		table.selectionMaxColumnIndex = table.selectionStartColumnIndex

		if(!table.handler.selectionStartingTable) {
			table.handler.selectionStartingTable = table;
		}
	}
	else {
		if(rowIndex == table.selectionMinRowIndex || rowIndex == table.selectionMaxRowIndex) {
			if(columnIndex < table.selectionMinColumnIndex) {
				_celcel_addSelection(table, 
					table.selectionMinRowIndex, table.selectionMaxRowIndex,
					columnIndex, table.selectionMinColumnIndex - 1
				);
				table.selectionMinColumnIndex = columnIndex;
				return;
			}
			else if(columnIndex > table.selectionMaxColumnIndex) {
				_celcel_addSelection(table, 
					table.selectionMinRowIndex, table.selectionMaxRowIndex,
					table.selectionMinColumnIndex + 1, columnIndex
				);
				table.selectionMaxColumnIndex = columnIndex;
				return;
			}
		}

		if(columnIndex == table.selectionMinColumnIndex || columnIndex == table.selectionMaxColumnIndex) {
			if(rowIndex < table.selectionMinRowIndex) {
				_celcel_addSelection(table, 
					rowIndex, table.selectionMinRowIndex - 1,
					table.selectionMinColumnIndex, table.selectionMaxColumnIndex
				);
				table.selectionMinRowIndex = rowIndex;
				return;
			}
			else if(rowIndex > table.selectionMaxRowIndex) {
				_celcel_addSelection(table, 
					table.selectionMaxRowIndex + 1, rowIndex,
					table.selectionMinColumnIndex, table.selectionMaxColumnIndex
				);
				table.selectionMaxRowIndex = rowIndex;
				return;
			}
		}
	}


	var maxRowIndex = Math.max(table.selectionStartRowIndex, rowIndex);
	var minRowIndex = Math.min(table.selectionStartRowIndex, rowIndex);

	var maxColumnIndex = Math.max(table.selectionStartColumnIndex, columnIndex);
	var minColumnIndex = Math.min(table.selectionStartColumnIndex, columnIndex);

	_celcel_clearSelection(table);
	table.selection = new Array();

	_celcel_addSelection(table, minRowIndex, maxRowIndex, minColumnIndex, maxColumnIndex);

	table.selectionMinRowIndex = minRowIndex;
	table.selectionMinColumnIndex = minColumnIndex;
	table.selectionMaxRowIndex = maxRowIndex;
	table.selectionMaxColumnIndex = maxColumnIndex;


	return;
}

function _celcel_clearSelection(table) {
	if(!table) {
		return;
	}

	if(table.selection) {
		for(var i=0; i<table.selection.length; i++) {
			var input = table.selection[i];
			_celcel_getColumn(input).style.backgroundColor = "white";
			input.style.backgroundColor = "white";
		}
	}
	table.selection = null;
}

function _celcel_getFirstInputInRow(row, index) {
	for(var i=index; i < row.cells.length; i++) {
		var input = _celcel_getInputNode(row.cells[i]);
		if(input) {
			return input;
		}
	}
	return null;
}

function _celcel_getFirstInput(table) {
	if(table.firstInput) {
		return table.firstInput;
	}
	for(var i=0; i < table.rows.length; i++) {
		var input = _celcel_getFirstInputInRow(table.rows[i], 0);
		if(input) {
			table.firstInput = input;
			return input;
		}
	}
	return null;
}

function _celcel_getFirstInputInColumn(table, columnIndex, rowIndex) {
	for(var i=rowIndex; i < table.rows.length; i++) {
		var input = _celcel_getInputNode(table.rows[i].cells[columnIndex]);
		if(input) {
			return input;
		}
	}
	return null;
}

function _celcel_getLastInputInRow(row, index) {
	for(var i=index; i >= 0; i--) {
		var input = _celcel_getInputNode(row.cells[i]);
		if(input) {
			return input;
		}
	}
	return null;
}

function _celcel_getLastInput(table) {
	if(table.lastInput) {
		return table.lastInput;
	}
	for(var i=table.rows.length-1; i >= 0; i--) {
		var input = _celcel_getLastInputInRow(table.rows[i], table.rows[i].cells.length-1);
		if(input) {
			table.lastInput = input;
			return input;
		}
	}
	return null;
}

function _celcel_getLastInputInColumn(table, columnIndex, rowIndex) {
	for(var i=rowIndex; i >= 0; i--) {
		var input = _celcel_getInputNode(table.rows[i].cells[columnIndex]);
		if(input) {
			return input;
		}
	}
	return null;
}

function _celcel_selectColumn(table, index) {
	if(_celcel_updateCellSelection(_celcel_getFirstInputInColumn(table, index, 0))) {
		_celcel_updateCellSelection(_celcel_getLastInputInColumn(table, index, table.rows.length-1));
	}
}

function _celcel_selectRow(table, row) {
	if(_celcel_updateCellSelection(_celcel_getFirstInputInRow(row, 0))) {
		_celcel_updateCellSelection(_celcel_getLastInputInRow(row, row.cells.length-1));
	}
}

function _celcel_selectAll(table) {
	if(_celcel_updateCellSelection(_celcel_getFirstInput(table))) {
		_celcel_updateCellSelection(_celcel_getLastInput(table));
	}
}

function _celcel_clearAllSelections(table) {
	table.handler.selectionStartingTable = null;
	_celcel_clearSelection(table);
	if(table.upperTable) {
		_celcel_clearSelection(table.upperTable);
	}
	if(table.lowerTable) {
		_celcel_clearSelection(table.lowerTable);
	}
	if(table.leftTable) {
		_celcel_clearSelection(table.leftTable);
	}
	if(table.rightTable) {
		_celcel_clearSelection(table.rightTable);
	}
	if(table.crossTable) {
		_celcel_clearSelection(table.crossTable);
	}
}

function _celcel_updateColumnSelection(event, table, input) {
	var column;
	if(input.nodeName=="INPUT") {
		column = _celcel_getColumn(input);
	}
	else {
		column = input;
	}
	var index = column.cellIndex;
	if(_celcel_isAvailableTable(table.upperTable)) {
		_celcel_selectColumn(table.upperTable, index);
	}
	_celcel_selectColumn(table, index);
	if(_celcel_isAvailableTable(table.lowerTable)) {
		_celcel_selectColumn(table.lowerTable, index);
	}
}

function _celcel_updateRowSelection(event, table, input) {
	var row;
	if(input.nodeName=="INPUT") {
		row = _celcel_getRow(input);
	}
	else {
		row = input.parentNode;
	}
	if(_celcel_isAvailableTable(table.leftTable)) {
		_celcel_selectRow(table.leftTable, table.leftTable.rows[row.rowIndex]);
	}
	_celcel_selectRow(table, row);
	if(_celcel_isAvailableTable(table.rightTable)) {
		_celcel_selectRow(table.rightTable, table.rightTable.rows[row.rowIndex]);
	}
}

function _celcel_updateSelection(event, table, input) {
	if(table.handler.selectionMode=="cell") {
		_celcel_updateCellSelection(input);
	}
	else if(table.handler.selectionMode=="row") {
		_celcel_updateRowSelection(event, table, input);
	}
	else if(table.handler.selectionMode=="column") {
		_celcel_updateColumnSelection(event, table, input);
	}
}

function _celcel_select(event) {
	event = IWidgets.editEvent(event);
	var input = event.target;
	var table = _celcel_getTable(input);

	if(!event.ctrlKey && !event.shiftKey) {
		_celcel_clearAllSelections(table);
	}
	_celcel_updateSelection(event, table, input);
	return table.handler;
}

function _celcel_onclick(event) {
	var handler = _celcel_select(event);
	if(handler.onclick) {
		handler.onclick(event);
	}
}



function _celcel_onmouseover(event) {
	event = IWidgets.editEvent(event);
	var table = _celcel_getTable(event.target);
	if(table.handler.autoSelection) {
		_celcel_select(event);
	}
}

function _celcel_header_onclick(event) {
	event = IWidgets.editEvent(event);
	var table = _celcel_getTable(event.target);

	if(!event.ctrlKey && !event.shiftKey) {
		_celcel_clearAllSelections(table);
	}

	_celcel_selectAll(table);
	_celcel_selectAll(table.rightTable);
	_celcel_selectAll(table.lowerTable);
	_celcel_selectAll(table.crossTable);
}

function _celcel_rowHeader_onclick(event) {
	event = IWidgets.editEvent(event);
	var input = event.target;
	var table = _celcel_getTable(event.target);

	if(table.handler.selectionMode=="column") {
		return;
	}

	if(!event.ctrlKey && !event.shiftKey) {
		_celcel_clearAllSelections(table);
	}

	_celcel_updateRowSelection(event, table, input);
}

function _celcel_columnHeader_onclick(event) {
	event = IWidgets.editEvent(event);
	var input = event.target;
	var table = _celcel_getTable(input);

	if(table.handler.selectionMode=="row") {
		return;
	}

	if(!event.ctrlKey && !event.shiftKey) {
		_celcel_clearAllSelections(table);
	}

	_celcel_updateColumnSelection(event, table, input);
}

function _celcel_onfocus(event) {

	event = IWidgets.editEvent(event);
	var input = event.target;

	input.select();

	if(input.readOnly && input.createTextRange) {
		var range = input.createTextRange();
		if(range) {
			range.move("character", 0);
			range.select();
		}
	}
}

function _celcel_setFocus(input) {
	if(input && input.focus) {
		input.focus();
	}
}

function _celcel_paste(handler) {
	if(!window.clipboardData) {
		return;
	}

	var text = window.clipboardData.getData("Text");
	if(!text || text.length==0) {
		return;
	}

	var table = handler.selectionStartingTable;
	var rowIndex = table.selectionMinRowIndex;

	var rowText = text.split("\r\n");
	for(var i = 0; i<rowText.length; i++) {
		if(rowText[i].length==0) {
			break;
		}
		if(i+rowIndex >= table.rows.length) {
			if(table.lowerTable) {
				table = table.lowerTable;
				rowIndex = 0 - i;
			}
			else {
				break;
			}
		}
		var row = table.rows[i+rowIndex];
		var columnIndex = handler.selectionStartingTable.selectionMinColumnIndex;

		var columnText = rowText[i].split("\t");
		for(var j=0; j<columnText.length; j++) {
			if(j+columnIndex >= row.cells.length) {
				if(table.rightTable) {
					row = table.rightTable.rows[i+rowIndex];
					columnIndex = 0 - j;
				}
				else {
					break;
				}
			}

			var column = row.cells[j+columnIndex];
			var input = _celcel_getInputNode(column);
			if(input && !input.readOnly) {
				input.value = columnText[j];
			}
		}
	}
}


function _celcel_createTextByInput(table, i, arr, index) {
	var minColumnIndex = table.selectionMinColumnIndex;
	var maxColumnIndex = table.selectionMaxColumnIndex;

	for(var j=minColumnIndex; j<=maxColumnIndex; j++) {
		input = _celcel_getInputNode(table.rows[i].cells[j]);
		var value = "";
		if(input) {
			value = input.value;
		}
		arr[index++] = value;
		arr[index++] = "\t";
	}

	return index;
}

function _celcel_createText(leftTable, rightTable, arr, index) {
	var maxRowIndex = -1;
	var minRowIndex = Number.POSITIVE_INFINITY;

	if(leftTable.selection) {
		maxRowIndex = Math.max(leftTable.selectionMaxRowIndex, maxRowIndex);
		minRowIndex = Math.min(leftTable.selectionMinRowIndex, minRowIndex);
	}
	if(rightTable.selection) {
		maxRowIndex = Math.max(rightTable.selectionMaxRowIndex, maxRowIndex);
		minRowIndex = Math.min(rightTable.selectionMinRowIndex, minRowIndex);
	}

	if(maxRowIndex==-1 || minRowIndex==Number.POSITIVE_INFINITY) {
		return index;
	}

	for(var i=minRowIndex; i<=maxRowIndex; i++) {
		if(leftTable.selection) {
			index = _celcel_createTextByInput(leftTable, i, arr, index);
		}
		if(rightTable.selection) {
			index = _celcel_createTextByInput(rightTable, i, arr, index);
		}
		index--;
		arr[index++] = "\r\n";
	}

	return index;
}

function _celcel_createTextByColumn(table, i, arr, index) {
	for(var j = 0; j < table.rows[i].cells.length; j++) {
		var column = table.rows[i].cells[j];
		input = _celcel_getInputNode(column);
		var value = "";
		if(input) {
			value = input.value;
		}
		else {
			value = column.innerText;
		}
		arr[index++] = value;
		arr[index++] = "\t";
	}
	return index;
}

function _celcel_copyAllTable(leftTable, rightTable, arr, index) {
	var leftTableRowLength = leftTable.rows.length;
	var rightTableRowLength = rightTable.rows.length;
	var rowLength = Math.max(leftTableRowLength, rightTableRowLength);
	for(var i=0; i < rowLength; i++) {
		if(leftTableRowLength > i) { 
			index = _celcel_createTextByColumn(leftTable, i, arr, index);
		}
		if(rightTableRowLength > i ) {
			index = _celcel_createTextByColumn(rightTable, i, arr, index);
		}
		index--;
		arr[index++] = "\r\n";
	}
	return index;
}

function _celcel_copyAll(header, rowHeader, columnHeader, detail) {
	if(!window.clipboardData) {
		return;
	}
	var arr = new Array();
	var index = 0;

	index = _celcel_copyAllTable(header, columnHeader, arr, index);
	_celcel_copyAllTable(rowHeader, detail, arr, index);

	window.clipboardData.setData("Text", arr.join(""));
}

function _celcel_copy(header, rowHeader, columnHeader, detail) {

	if(!window.clipboardData) {
		return;
	}

	var arr = new Array();
	var index = 0;

	index = _celcel_createText(header, columnHeader, arr, index);
	_celcel_createText(rowHeader, detail, arr, index);

	window.clipboardData.setData("Text", arr.join(""));
}

function _celcel_clear(table) {
	if(!table.selection) {
		return;
	}

	for(var i=0; i<table.selection.length; i++) {
		if(!table.selection[i].readOnly) {
			table.selection[i].value = "";
		}
	}
}

function _celcel_onkeydown(event) {

	event = IWidgets.editEvent(event);
	var input = event.target;
	var table = _celcel_getTable(input);

	//IDebug.print("keyCode:" + event.keyCode);

	if(event.keyCode==16 || // shift
			event.keyCode==17 || event.keyCode==18 ) { // ctrl, alt	
		event.returnValue = true;
		return event.returnValue;
	}


	if(event.keyCode==46) { // delete
		if(table.selection) {
			table.handler.clear();
			event.returnValue = false;
			table.isCellEditMode = false;
			return event.returnValue;
		}
	}

	if(!table.isCellEditMode) {
		if(event.ctrlKey && event.keyCode==86) { // Ctrl+V
			table.handler.paste();
			event.returnValue = false;
			return event.returnValue;
		}
		else if(event.ctrlKey && event.keyCode==67) { // Ctrl+C
			table.handler.copy();
			event.returnValue = false;
			return event.returnValue;
		}
		else if(event.ctrlKey && event.keyCode==88) { // Ctrl+X
			table.handler.cut();
			event.returnValue = false;
			return event.returnValue;
		}
		else if(event.keyCode==8 && input && input.readOnly) { // BS
			event.returnValue = false;
			return event.returnValue;
		}
	}

	var srcInput = input;
	if(!event.shiftKey || event.keyCode==9) {
		_celcel_clearAllSelections(table);
	}

	if(!table.isCellEditMode) {
		if(event.keyCode==37) { // left
			var item = _celcel_getPrevInput(table, input, !event.shiftKey);
			if(item) {
				input = item;
			}
			_celcel_setFocus(input);
			_celcel_updateSelection(event, _celcel_getTable(input), input);
			event.returnValue = false;
		}
		else if(event.keyCode==39) { // right
			var item = _celcel_getNextInput(table, input, !event.shiftKey);
			if(item) {
				input = item;
			}
			_celcel_setFocus(input);
			_celcel_updateSelection(event, _celcel_getTable(input), input);
			event.returnValue = false;
		}
		else {
			event.returnValue = true;
			if(event.keyCode==113) { // F2
				if(input.setSelectionRange) { // for Moz
					input.setSelectionRange(input.value.length, input.value.length);
				}
				else { // for IE
					event.keyCode = 34;
				}
			}
		}
	}

	if(event.keyCode==27) { // ESC
		input.select();
	}
	else if(event.keyCode==40 || event.keyCode==13) { // down or enter
		input = _celcel_getLowerInput(table, input);
		_celcel_setFocus(input);
		_celcel_updateSelection(event, _celcel_getTable(input), input);
		event.returnValue = false;
	}
	else if(event.keyCode==38) { // up
		input = _celcel_getUpperInput(table, input);
		_celcel_setFocus(input);
		_celcel_updateSelection(event, _celcel_getTable(input), input);
		event.returnValue = false;
	}

	if(event.keyCode!=9 && srcInput==input) {
		_celcel_updateSelection(event, _celcel_getTable(input), input);
	}

	// editMode ݒ肷B
	if(
		(event.keyCode==37 && !table.isCellEditMode) || // LEFT
		(event.keyCode==39  && !table.isCellEditMode) || // RIGHT
			event.keyCode==9 || event.keyCode==27 || // TAB, ESC
			event.keyCode==40 || event.keyCode==13 || // DOWN, ENTER
			event.keyCode==38) { // UP
		table.isCellEditMode = false; // editMode  false ɂB
	}
	else { // ȊÕL[ editMode  true ɂB
		if(input && !input.readOnly) {
			table.isCellEditMode = true;
		}
		else {
			table.isCellEditMode = false;
		}
	}

	return event.returnValue;
}

