/*
 *RequestConfigInitializer.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PageInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.util.ConfigurationException;
import nga.util.Resource;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * NGXgݒt@C̓ǂݍ݂sȂNXB
 */
class RequestConfigInitializer {

	/**
	 * XMLhLgr_t@NgB
	 */
	private static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

	/**
	 * \[XB
	 */
	private Resource resource = new Resource(getClass().getPackage().getName() + ".Message");

	/**
	 * RequestConfigInitializer 쐬B
	 */
	public RequestConfigInitializer() {
		super();
	}

	/**
	 * W[擾B
	 * @param config ݒB
	 */
	public ModuleInfo getModuleInfo(String dir, ServletConfig config, ServletContext context) throws ServletException {
		ModuleInfo moduleInfo = new ModuleInfo(dir);

		// NGXgݒ񂪊i[Ăt@C擾B
		File[] file = getConfigFile(dir, config, context);
		
		// t@Cǂݍ݁CNGXgݒ̏sȂB
		for(int i=0; i<file.length; i++) {
			try {
				initModuleInfo(file[i], moduleInfo);
			}
			catch (Exception e) {
				throw new ServletException(e);
			}
		}
		return moduleInfo;
	}
	
	/**
	 * NGXgݒ񂪊i[Ăt@C擾B
	 * @return NGXgݒ񂪊i[Ăt@CB
	 */
	private File[] getConfigFile(String moduleName, ServletConfig config, ServletContext context) {
		String configDir = config.getInitParameter(CongaServlet.CONFIG_DIR);
		if(configDir==null || configDir.length()==0) {
			configDir = "conf";
		}
		
		if(configDir.charAt(0)=='/' || configDir.charAt(0)=='\\') {
			configDir = configDir.substring(1);
		}

		configDir = moduleName + "/" + configDir;

		String configFile = config.getInitParameter(CongaServlet.CONFIG_FILE);
		if(configFile==null) {
			configFile = "*request-config.xml";
		}
		int starIndex = configFile.indexOf('*');
		final String prefix = (starIndex>0)?configFile.substring(0, starIndex) : null;
		final String suffix = (starIndex<configFile.length()-1)?configFile.substring(starIndex+1) : null;

		File dir = new File(context.getRealPath(configDir));

		File[] files = dir.listFiles(
			new FilenameFilter(){
				public boolean accept(File d, String name) {
					if(prefix!=null && !name.startsWith(prefix)) {
						return false;
					}
					if(suffix!=null && !name.endsWith(suffix)) {
						return false;
					}
					return true;
				}
			}
		);

		if(files==null || files.length==0) {
			throw new ConfigurationException(message("m_not_found_config_file", (dir + File.separator + configFile)));
		}
		
		return files;
	}

	/**
	 * t@Cǂݍ݁CW[̏sȂB
	 * @param file NGXgݒ񂪊i[Ăt@CB
	 * @param moduleInfo W[B
	 */
	private void initModuleInfo(File file, ModuleInfo moduleInfo) 
			throws ConfigurationException, IOException, SAXException, ParserConfigurationException {
		Document doc = builderFactory.newDocumentBuilder().parse(file);
		addPageInfo(moduleInfo, doc);
		addRequestInfo(moduleInfo, doc);
	}
	
	/**
	 * W[ page ^ȌǉB
	 * @param moduleInfo W[B
	 * @param doc hLgB
	 */
	private void addPageInfo(ModuleInfo moduleInfo, Document doc) {
		NodeList list = doc.getElementsByTagName("page");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			PageInfo pageInfo = getPageInfo(node);
			if(moduleInfo.setPageInfo(pageInfo.getId(), pageInfo)!=null) {
				throw new ConfigurationException(message("m_dup_page", pageInfo.getId()));
			}
		}
	}
	

	/**
	 * page ^O擾B
	 * @param node 擾m[hB
	 * @return page ^OB
	 */
	private PageInfo getPageInfo(Node node) throws ConfigurationException {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_page_id"));
		}

		PageInfo pageInfo = new PageInfo(id);

		String cls = getValue(attr, "class");
		if(cls==null) {
			throw new ConfigurationException(message("m_null_page_class"));
		}

		try {
			Class c = Class.forName(cls);
			pageInfo.setPageClass(c);
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", cls), e);
		}
		
		return pageInfo;
	}


	/**
	 * W[ request ^OǉB
	 * @param moduleInfo W[B
	 * @param doc hLgB
	 */
	private void addRequestInfo(ModuleInfo moduleInfo, Document doc) {
		NodeList list = doc.getElementsByTagName("request");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			RequestInfo requestInfo = getRequestInfo(node);
			if(moduleInfo.setRequestInfo(requestInfo.getId(), requestInfo)!=null) {
				throw new ConfigurationException(message("m_dup_request", requestInfo.getId()));
			}
		}
	}

	/**
	 * request ^O̎擾sȂB
	 * @param nodde 擾m[hB
	 * @return request ^OB
	 */
	private RequestInfo getRequestInfo(Node node) throws ConfigurationException {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_request_id"));
		}

		RequestInfo requestInfo = new RequestInfo(id);
		
		// controller ̐ݒsȂB
		String controller = getValue(attr, "controller");
		if(controller!=null) {
			int dotIndex = controller.lastIndexOf('.');
			if(dotIndex < 1 || dotIndex > controller.length()-2) {
				throw new ConfigurationException(message("m_invalid_controller_attribute"));
			}

			try {
				Class c = Class.forName(controller.substring(0, dotIndex));
				requestInfo.setControllerClass(c);
				String methodName = controller.substring(dotIndex+1);
				Method[] method = c.getMethods();
				for(int i=0; i < method.length; i++ ) {
					if(method[i].getName().equals(methodName) && 
							Modifier.isPublic(method[i].getModifiers())) {
						requestInfo.setControllerMethod(method[i]);
						break;
					}
				}
				if(requestInfo.getControllerMethod()==null) {
					throw new ConfigurationException(
						message("m_invalid_controller_method", controller.substring(0, dotIndex), methodName)
					);
				}
			}
			catch (ClassNotFoundException e) {
				throw new ConfigurationException(
						message("m_class_not_found", controller.substring(0, dotIndex)), e
				);
			}
			
		}

		// page ̐ݒ
		requestInfo.setPage(getValue(attr, "page"));
		
		// \[X̐ݒsȂB
		requestInfo.setResourceName(getValue(attr, "resource"));

		// ParameterInfo, ResultInfo ݒ肷B
		NodeList nlist = node.getChildNodes();
		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			String name = child.getNodeName();
			if("parameter".equals(name)) {
				requestInfo.setParameterInfo(getParameterInfo(child));
			}
			else if("result".equals(name)) {
				requestInfo.setResultInfo(getResultInfo(child));
			}
		}

		return requestInfo;
	}

	/**
	 * result ^O擾B
	 * @param node 擾m[hB
	 * @return result ^OB
	 */
	@SuppressWarnings("unchecked")
	private ResultInfo getResultInfo(Node node) {
		ResultInfo resultInfo = new ResultInfo();

		NamedNodeMap attr = node.getAttributes();
		
		// Writer ̐ݒ
		String writerClass = getValue(attr, "writer");
		try {
			if(writerClass!=null) {
				resultInfo.setWriter((Class<ResultWriter>) Class.forName(writerClass));
			}
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", writerClass), e);
		}

		// ̐ݒ
		for(int i=0; i<attr.getLength(); i++) {
			Node n = attr.item(i);
			resultInfo.put(n.getNodeName(), n.getNodeValue());
		}

		// target ^O̐ݒ
		initTarget(resultInfo.getTargetInfoList(), node.getChildNodes());

		return resultInfo;
	}

	/**
	 * target ^O̐ݒsȂB
	 * @param targetInfoList target ^ÕXgB
	 * @param nlist 擾m[hXgB
	 */
	private void initTarget(TargetInfoList targetInfoList, NodeList nlist) {
		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			if(!"target".equals(child.getNodeName())) {
				continue;
			}
			targetInfoList.add(getTargetInfo(child));
		}
	}
	
	/**
	 * target ^O̎擾sȂB
	 * @param node 擾m[hB
	 * @return target ^OB
	 */
	private TargetInfo getTargetInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();
		TargetInfo targetInfo = new TargetInfo();

		for(int j=0; j<attr.getLength(); j++) {
			Node n = attr.item(j);
			targetInfo.put(n.getNodeName(), n.getNodeValue());
		}
		
		NodeList children = node.getChildNodes();
		if(children!=null && children.getLength()>0) {
			targetInfo.setChildren(new TargetInfoList());
			initTarget(targetInfo.getChildren(), children);
		}
		return targetInfo;
	}

	/**
	 * parameter ^O擾B
	 * @param node 擾m[hB
	 * @return parameter ^OB
	 */
	@SuppressWarnings("unchecked")
	private ParameterInfo getParameterInfo(Node node) {
		ParameterInfo parameterInfo = new ParameterInfo();
		
		NamedNodeMap attr = node.getAttributes();

		// parser class ̐ݒ
		String parserClass = getValue(attr, "parser");
		try {
			if(parserClass!=null) {
				parameterInfo.setParser((Class<ParameterParser>) Class.forName(parserClass));
			}
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", parserClass), e);
		}

		// ̐ݒ
		for(int i=0; i<attr.getLength(); i++) {
			Node n = attr.item(i);
			parameterInfo.put(n.getNodeName(), n.getNodeValue());
		}

		// vpeB̐ݒ
		initProperty(parameterInfo.getPropertyInfoMap(), node.getChildNodes());

		return parameterInfo;
	}
	

	/**
	 * property ^O̐ݒsȂB
	 * @param propertyMap property ^Õ}bvB
	 * @param nlist 擾m[hXgB
	 */
	private void initProperty(PropertyInfoMap propertyMap, NodeList nlist) {

		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			if(!"property".equals(child.getNodeName())) {
				continue;
			}
			
			PropertyInfo propertyInfo = getPropertyInfo(child);
			if(propertyMap.put(propertyInfo.getName(), propertyInfo)!=null) {
				throw new ConfigurationException(message("m_dup_property", propertyInfo.getName()));
			}
		}
	}
	
	/**
	 * property ^O̎擾sȂB
	 * @param node 擾m[hB
	 * @param nameIsRequired name wK{ǂB
	 * @return vpeBB
	 */
	private PropertyInfo getPropertyInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();
		String name = getValue(attr, "name");
		if(name==null) {
			throw new ConfigurationException(message("m_null_property_name"));
		}
		PropertyInfo propertyInfo = new PropertyInfo(name);

		for(int j=0; j<attr.getLength(); j++) {
			Node n = attr.item(j);
			propertyInfo.put(n.getNodeName(), n.getNodeValue());
		}
		return propertyInfo;
	}

	/**
	 * l擾B
	 * @param attr 擾m[h}bvB
	 * @param name B
	 * @return lB
	 */
	private String getValue(NamedNodeMap attr, String name) {
		if(attr==null) {
			return null;
		}

		Node node = attr.getNamedItem(name);
		if(node!=null) {
			return node.getNodeValue();
		}
		else {
			return null;
		}
	}

	/**
	 * bZ[WԂB
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	private String message(String key, Object... args) {
		return resource.message(key, args);
	}
}
