/*
 *DefaultCongaServletFactory.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import nga.servlet.dsp.parser.DefaultParameterParser;
import nga.servlet.dsp.parser.PropertyValueParserCollection;
import nga.servlet.dsp.writer.DefaultResultWriter;
import nga.servlet.spi.CongaServletFactory;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.util.Resource;

/**
 * {@link nga.servlet.spi.CongaServletFactory CongaServletFactory} ̃ftHgB
 */
public class DefaultCongaServletFactory implements CongaServletFactory {

	/**
	 * ftHg̃bZ[W\[XB
	 */
	private static final String DEFAULT_MESSAGE_RESOURCE = "nga.servlet.dsp.Message";
	
	/**
	 * bZ[WB
	 */
	private Map<Locale, Map<String, Resource>> messageMap = new HashMap<Locale, Map<String, Resource>>();


	/**
	 * DefaultCongaServletFactory 쐬B
	 */
	public DefaultCongaServletFactory() {
		Map<String, Resource> map = new HashMap<String, Resource>();
		map.put(DEFAULT_MESSAGE_RESOURCE, new Resource(DEFAULT_MESSAGE_RESOURCE));
		messageMap.put(Locale.getDefault(), map);
	}

	/**
	 * ParameterParser 𐶐B̎ł́C{@link DefaultParameterParser} ̃CX^X𐶐B
	 * @see nga.servlet.spi.CongaServletFactory#createParameterParser()
	 */
	public ParameterParser createParameterParser() {
		DefaultParameterParser parser = new DefaultParameterParser();

		parser.registerValueParser(String.class, PropertyValueParserCollection.FOR_STRING);
		parser.registerValueParser(Character.TYPE, PropertyValueParserCollection.FOR_CHARACTOR);
		parser.registerValueParser(Character.class, PropertyValueParserCollection.FOR_CHARACTOR);
		parser.registerValueParser(Boolean.TYPE, PropertyValueParserCollection.FOR_BOOLEAN);
		parser.registerValueParser(Boolean.class, PropertyValueParserCollection.FOR_BOOLEAN);
		parser.registerValueParser(Integer.TYPE, PropertyValueParserCollection.FOR_INTEGER);
		parser.registerValueParser(Integer.class, PropertyValueParserCollection.FOR_INTEGER);
		parser.registerValueParser(Long.TYPE, PropertyValueParserCollection.FOR_LONG);
		parser.registerValueParser(Long.class, PropertyValueParserCollection.FOR_LONG);
		parser.registerValueParser(Short.TYPE, PropertyValueParserCollection.FOR_SHORT);
		parser.registerValueParser(Short.class, PropertyValueParserCollection.FOR_SHORT);
		parser.registerValueParser(Byte.TYPE, PropertyValueParserCollection.FOR_BYTE);
		parser.registerValueParser(Byte.class, PropertyValueParserCollection.FOR_BYTE);
		parser.registerValueParser(Float.TYPE, PropertyValueParserCollection.FOR_FLOAT);
		parser.registerValueParser(Float.class, PropertyValueParserCollection.FOR_FLOAT);
		parser.registerValueParser(Double.TYPE, PropertyValueParserCollection.FOR_DOUBLE);
		parser.registerValueParser(Double.class, PropertyValueParserCollection.FOR_DOUBLE);
		parser.registerValueParser(BigDecimal.class, PropertyValueParserCollection.FOR_BIGDECIMAL);
		parser.registerValueParser(BigInteger.class, PropertyValueParserCollection.FOR_BIGINTEGER);
		parser.registerValueParser(java.util.Date.class, PropertyValueParserCollection.FOR_DATE);
		parser.registerValueParser(java.sql.Date.class, PropertyValueParserCollection.FOR_SQLDATE);
		parser.registerValueParser(java.sql.Time.class, PropertyValueParserCollection.FOR_SQLTIME);
		parser.registerValueParser(Timestamp.class, PropertyValueParserCollection.FOR_SQLTIMESTAMP);

		return parser;
	}

	/**
	 * ResultWriter 𐶐B
	 * ̎ł́C{@link DefaultResultWriter} ̃CX^X𐶐B
	 * @see nga.servlet.spi.CongaServletFactory#createResultWriter()
	 */
	public ResultWriter createResultWriter() {
		return new DefaultResultWriter();
	}

	/**
	 * w肳ꂽÕ\[X擾B
	 * @param locale \[X̃P[B
	 * @param resourceName \[XB
	 * @return \[XB
	 */
	public Resource getResource(Locale locale, String resourceName) {
		String defaultResourceName = getDefaultResourceName();
		if(defaultResourceName==null) {
			defaultResourceName = DEFAULT_MESSAGE_RESOURCE;
		}

		if(resourceName==null) {
			resourceName = defaultResourceName;
		}
		

		Map<String, Resource> map = messageMap.get(locale);
		if(map==null) {
			map = new HashMap<String, Resource>();
			messageMap.put(locale, map);
		}

		Resource resource = map.get(resourceName);
		if(resource==null) {
			resource = new Resource(resourceName, locale);
			if(!resourceName.equals(defaultResourceName)) {
				resource.setParent(getResource(locale, defaultResourceName));
			}
			else if(!resourceName.equals(DEFAULT_MESSAGE_RESOURCE)) {
				resource.setParent(getResource(locale, DEFAULT_MESSAGE_RESOURCE));
			}
			map.put(resourceName, resource);
		}
		return resource;
	}

	/**
	 * request ɖIɎw肵ȂꍇCftHgŎgp郊\[X̖O擾B
	 * ̎ł null ԂB
	 * KvɉāCTuNXI[o[ChB
	 * @return ftHgŎgp郊\[X̖OB
	 */
	protected String getDefaultResourceName() {
		return null;
	}

}
