package nga.servlet.dsp.writer;

import java.io.IOException;

import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;

/**
 * lIuWFNgɊi[ĂvpeBlo͂B
 */
public abstract class TargetValueWriter {

	/**
	 * lIuWFNgɊi[ĂvpeBlo͂B
	 * @param resultValue o͂鏈ʏB
	 */
	public abstract void write(TargetValue resultValue) throws IOException;

	/**
	 * ̃C^ HTML 𐶐邩ǂԂB
	 * @return ̃C^ HTML 𐶐ꍇ trueB
	 */
	public boolean isGenerateInnerHTML() {
		return false;
	}

	/**
	 * errorInfo ̒ɑΏۍڂ܂܂ĂꍇCG[ƂȂl\B
	 * @param resultValue o͂鏈ʏB
	 */
	protected boolean printErrorValue(TargetValue resultValue) {
		Object o =resultValue.getErrorInfo().getValue(resultValue.getTargetInfo().getValue());
		if(o!=null) {
			resultValue.getWriter().print(WriterUtil.format(o));
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * w肳ꂽ target ^O "label" (x) Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "label" Ŏw肳ꂽlB
	 */
	public static String getLabel(TargetInfo targetInfo) {
		return targetInfo.get("label");
	}

	/**
	 * w肳ꂽ target ^O "format" () Ŏw肳ꂽl擾B
	 * @param targetInfo property ^OB
	 * @param defaultFormat ftHgtH[}bgB
	 * @return "format" Ŏw肳ꂽlBw肳ĂȂꍇ defaultFormatB
	 */
	public static String getFormat(TargetInfo targetInfo, String defaultFormat) {
		return targetInfo.get("format", defaultFormat);
	}
	
	/**
	 * w肳ꂽ target ^O "format" () Ŏw肳ꂽl擾B
	 * @param targetInfo property ^OB
	 * @return "format" Ŏw肳ꂽlBw肳ĂȂꍇ nullB
	 */
	public static String getFormat(TargetInfo targetInfo) {
		return getFormat(targetInfo, null);
	}
	
	/**
	 * w肳ꂽ target ^O "scale" () Ŏw肳ꂽl擾B
	 * @param targetInfo target ^OB
	 * @return "label" Ŏw肳ꂽlB
	 */
	public static int getScale(TargetInfo targetInfo) {
		return targetInfo.get("scale", -1);
	}
}