/*
 *FormatUtil.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;


/**
 * tH[}bg֘A[eBeBB
 */
public class FormatUtil {

	/**
	 * ltH[}bgB
	 */
	private static Map<String, NumberFormat> numFmtMap = new HashMap<String, NumberFormat>();

	/**
	 * ttH[}bgB
	 */
	private static Map<String, DateFormat> dtFmtMap = new HashMap<String, DateFormat>();

	private FormatUtil() {
	}

	/**
	 * java.util.Date ^̒l java.sql.Date ^̒lɕϊB
	 * @param dd lϊtf[^ځB
	 * @return ϊꂽ java.sql.Date ^̃f[^B
	 */
	public static java.sql.Date toDate(java.util.Date dd) {
		if(dd==null) {
			return null;
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(dd);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND,0);
		return new java.sql.Date(cal.getTime().getTime());
	}

	/**
	 * java.util.Date ^̒l java.sql.Time ^̒lɕϊB
	 * @param dd lϊtf[^ځB
	 * @return ϊꂽ java.sql.Time ^̃f[^B
	 */
	public static java.sql.Time toTime(java.util.Date dd) {
		if(dd==null) {
			return null;
		}
		return new java.sql.Time(dd.getTime());
	}

	/**
	 * java.util.Date ^̒l java.sql.Timestamp ^̒lɕϊB
	 * @param dd lϊtf[^ځB
	 * @return ϊꂽ java.sql.Timestamp ^̃f[^B
	 */
	public static java.sql.Timestamp toTimestamp(java.util.Date dd) {
		if(dd==null) {
			return null;
		}
		return new java.sql.Timestamp(dd.getTime());
	}
	
	/**
	 * w肳ꂽw肳ꂽɏ] java.sql.Date ^̒lɕϊB
	 * @param dd tf[^֕ϊ镶f[^B
	 * @param fmt B
	 * @return ϊꂽ java.sql.Date ^̃f[^BϊɎsꍇ nullB
	 */
	public static java.sql.Date toDate(String dd, String fmt) {
		return toDate(parse(dd, fmt));
	}

	/**
	 * w肳ꂽw肳ꂽɏ] java.sql.Time ^̒lɕϊB
	 * @param dd tf[^֕ϊ镶f[^B
	 * @param fmt B
	 * @return ϊꂽ java.sql.Time ^̃f[^BϊɎsꍇ nullB
	 */
	public static java.sql.Time toTime(String dd, String fmt) {
		return toTime(parse(dd, fmt));
	}

	/**
	 * w肳ꂽw肳ꂽɏ] java.sql.Timestamp ^̒lɕϊB
	 * @param dd tf[^֕ϊ镶f[^B
	 * @param fmt B
	 * @return ϊꂽ java.sql.Timestamp ^̃f[^BϊɎsꍇ nullB
	 */
	public static java.sql.Timestamp toTimestamp(String dd, String fmt) {
		return toTimestamp(parse(dd, fmt));
	}

	/**
	 * w肳ꂽw肳ꂽɏ]ēt^f[^ɕϊB
	 * @param date tf[^֕ϊ镶f[^B
	 * @param fmt B
	 * @return ϊꂽtf[^BϊɎsꍇ nullB
	 */
	public static java.util.Date parse(String date, String fmt) {
		try {
			return getDateFormat(fmt).parse(date);
		}
		catch(ParseException e) {
			return null;
		}
	}
	
	/**
	 * ttH[}bg擾B
	 * @param fmt B
	 * @return ttH[}bgB
	 */
	private static DateFormat getDateFormat(String fmt) {
		DateFormat f = dtFmtMap.get(fmt);
		if(f==null) {
			f = new SimpleDateFormat(fmt);
			f.setLenient(false);
			dtFmtMap.put(fmt, f);
		}
		return f;
	}

	/**
	 * ltH[}bg擾B
	 * @param fmt B
	 * @return ltH[}bgB
	 */
	public static NumberFormat getNumberFormat(String fmt) {
		NumberFormat f = numFmtMap.get(fmt);
		if(f==null) {
			f = new DecimalFormat(fmt);
			numFmtMap.put(fmt, f);
		}
		return f;
	}


	/** 
	 * l̕ҏW\sB
	 * @param num ҏW\鐔lB
	 * @param ptn B
	 */
	public static String format(long num, String ptn){
		return getNumberFormat(ptn).format(num);
	}

	/** 
	 * l̕ҏW\sB
	 * @param num ҏW\鐔lB
	 * @param ptn B
	 */
	public static String format(double num, String ptn){
		return getNumberFormat(ptn).format(num);
	}

	/** 
	 * l̕ҏW\sB
	 * @param bd ҏW\鐔lB
	 * @param ptn B
	 */
	public static String format(java.math.BigDecimal bd, String ptn){
		return getNumberFormat(ptn).format(bd.doubleValue());
	}
	
	/**
	 * w肳ꂽt^f[^w肳ꂽ̕ɕϊB
	 * @param date ϊtf[^B
	 * @param fmt B
	 * @return ϊꂽB
	 */
	public static String format(java.util.Date date, String fmt) {
		return getDateFormat(fmt).format(date);
	}

	/**
	 * R[hƖ̂ | ŘAĕ\B
	 * @param code R[hB
	 * @param name ́B
	 * @return R[h | ́B
	 */	
	public static String codeName(String code, String name) {
		return codeName(code, name, (code==null)?0:code.length());
	}

	/**
	 * R[hƖ̂ | ŘAĕ\B
	 * @param code R[hB
	 * @param name ́B
	 * @param codeLength R[ȟB
	 * @return R[h | ́B
	 */	
	public static String codeName(String code, String name, int codeLength) {
		if(Checker.empty(code) && Checker.empty(name)) {
			return "";
		}

		if(Checker.empty(code) && !Checker.empty(name)) {
			return name;
		}

		if(!Checker.empty(code) && Checker.empty(name)) {
			return code;
		}
			
		//if(!Checker.empty(code) && !Checker.empty(name))
		return space(code, codeLength) +" | " + name;
	}

	/**
	 * s w肵ɂȂ悤ɋ󔒂El߂B
	 * @param s
	 * @param len
	 * @return
	 */
	private static String space(String s, int len) {
		if(len==0) {
			return s;
		}

		StringBuilder sb = new StringBuilder(len);
		for(int i=0; i<len; i++) {
			if(i<s.length()) {
				sb.append(s.charAt(i));
			}
			else {
				sb.append(" ");
			}
		}
		return new String(sb);
	}

}
