/*
 * Decompiled with CFR 0.152.
 */
package nga.model;

import java.util.Locale;
import nga.model.Formattable;
import nga.model.SelectableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueList<K extends Comparable, V>
extends SelectableArrayList<Entry> {
    private static final long serialVersionUID = 1L;

    public KeyValueList(int initialCapacity) {
        super(initialCapacity);
    }

    public KeyValueList() {
    }

    public KeyValueList(KeyValueList<K, V> c) {
        super(c);
    }

    public void add(K key, V value) {
        this.add(new Entry(this, key, value));
    }

    public K getSelectedKey() {
        Entry en = (Entry)this.getSelected();
        if (en == null) {
            return null;
        }
        return en.key;
    }

    public V getSelectedValue() {
        Entry en = (Entry)this.getSelected();
        if (en == null) {
            return null;
        }
        return en.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    implements Comparable,
    Formattable {
        public K key;
        public V value;

        public Entry() {
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            if (this.key != null) {
                return this.key.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.key == null) {
                return ((Entry)o).key == null;
            }
            return this.key.equals(((Entry)o).key);
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        public int compareTo(Object o) {
            Entry en = (Entry)o;
            if (en == null) {
                return 1;
            }
            if (this.key == null && en.key == null) {
                return 0;
            }
            if (this.key == null && en.key != null) {
                return -1;
            }
            if (this.key != null && en.key == null) {
                return 1;
            }
            return this.key.compareTo(en.key);
        }

        @Override
        public String format(Locale l, String format) {
            return String.format(l, format, this.key, this.value);
        }
    }
}

