/*
 * Decompiled with CFR 0.152.
 */
package nga.model;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import nga.model.SelectableArrayList;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableTable<R>
extends SelectableArrayList<R> {
    private static final long serialVersionUID = 1L;
    private String selectedColumnName;
    private boolean rowSelection;
    private boolean columnSelection;

    public SelectableTable() {
    }

    public SelectableTable(List<R> rows) {
        super(rows);
    }

    public void setSelectedColumnName(String selectedColumn) {
        this.selectedColumnName = selectedColumn;
    }

    public String getSelectedColumnName() {
        return this.selectedColumnName;
    }

    public boolean isRowSelection() {
        return this.rowSelection;
    }

    public boolean isColumnSelection() {
        return this.columnSelection;
    }

    public Object getSelectedCell() {
        Object row = this.getSelected();
        if (row == null) {
            return null;
        }
        String columnName = this.getSelectedColumnName();
        if (columnName == null) {
            return null;
        }
        try {
            return MethodOperator.get(columnName, row);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void update(String value) throws ParseException {
        if (value == null || value.length() == 0) {
            this.rowSelection = false;
            this.columnSelection = false;
            this.setSelectedIndex(-1);
            this.setSelectedColumnName(null);
            return;
        }
        int separator = value.indexOf(44);
        if (separator == -1) {
            this.rowSelection = true;
            this.columnSelection = false;
            this.setSelectedIndex(Integer.parseInt(value));
        } else if (separator == 0) {
            this.rowSelection = false;
            this.columnSelection = true;
            this.setSelectedColumnName(value.substring(1));
        } else if (separator == value.length() - 1) {
            this.rowSelection = true;
            this.columnSelection = false;
            this.setSelectedIndex(Integer.parseInt(value.substring(0, separator)));
        } else {
            this.rowSelection = true;
            this.columnSelection = true;
            this.setSelectedIndex(Integer.parseInt(value.substring(0, separator)));
            this.setSelectedColumnName(value.substring(separator + 1));
        }
    }
}

