/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.Serializable;
import java.util.HashMap;
import nga.servlet.config.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorInfo
extends HashMap<String, Item> {
    private static final long serialVersionUID = 1L;
    private ModuleInfo moduleInfo;
    private String errorMessage;
    private Throwable exception;

    public ErrorInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public ErrorInfo setMessage(String message, Object ... args) {
        if (this.errorMessage == null) {
            this.errorMessage = this.moduleInfo.getMessage(message, args);
        }
        return this;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null && this.getException() != null) {
            return this.getException().getMessage();
        }
        return this.errorMessage;
    }

    public void setException(Throwable exception) {
        if (this.errorMessage == null) {
            this.exception = exception;
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public ErrorInfo add(String name) {
        this.add(new Item(name));
        return this;
    }

    public ErrorInfo add(String name, String value) {
        Item item = new Item(name);
        item.setValue(value);
        this.add(item);
        return this;
    }

    public ErrorInfo add(String name, String value, String message, Object ... args) {
        Item item = new Item(name);
        item.setValue(value);
        item.setMessage(this.moduleInfo.getMessage(message, args));
        this.add(item);
        return this;
    }

    public ErrorInfo add(Item item) {
        this.put(item.getName(), item);
        if (this.getErrorMessage() == null && item.getMessage() != null) {
            this.errorMessage = item.getMessage();
        }
        return this;
    }

    public Object getValue(String name) {
        Item item = (Item)this.get(name);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public boolean hasError() {
        return this.errorMessage != null || this.exception != null || !this.isEmpty();
    }

    public static class Item
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private Object value;
        private String message;

        public Item(String name) {
            this.setName(name);
        }

        private void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

