/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.config;

import java.util.HashMap;
import java.util.Map;
import nga.servlet.config.PageInfo;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResourceInfo;
import nga.util.Resource;

public class ModuleInfo {
    private String id;
    private Map<String, PageInfo> pageInfoMap = new HashMap<String, PageInfo>();
    private Map<String, RequestInfo> requestInfoMap = new HashMap<String, RequestInfo>();
    private Map<String, ResourceInfo> resourceInfoMap = new HashMap<String, ResourceInfo>();
    final char resourceTag;

    public ModuleInfo(String id, char resourceTag) {
        this.id = id;
        this.resourceTag = resourceTag;
    }

    public String getId() {
        return this.id;
    }

    public PageInfo setPageInfo(String pageId, PageInfo pageInfo) {
        return this.pageInfoMap.put(pageId, pageInfo);
    }

    public PageInfo getPageInfo(String pageId) {
        return this.pageInfoMap.get(pageId);
    }

    public RequestInfo setRequestInfo(String requestId, RequestInfo requestInfo) {
        requestInfo.setModuleInfo(this);
        return this.requestInfoMap.put(requestId, requestInfo);
    }

    public RequestInfo getRequestInfo(String requestId) {
        return this.requestInfoMap.get(requestId);
    }

    public ResourceInfo setResourceInfo(String resourceId, ResourceInfo resourceInfo) {
        return this.resourceInfoMap.put(resourceId, resourceInfo);
    }

    public ResourceInfo getResourceInfo(String resourceId) {
        return this.resourceInfoMap.get(resourceId);
    }

    public String getText(String key) {
        int index = this.getSeparatorIndex(key);
        if (index <= 0) {
            return key;
        }
        Resource resource = this.getResource(key.substring(0, index));
        if (resource == null) {
            return key;
        }
        return resource.get(key.substring(index + 1));
    }

    public String getMessage(String key, Object ... args) {
        int index = this.getSeparatorIndex(key);
        if (index <= 0) {
            return key;
        }
        Resource resource = this.getResource(key.substring(0, index));
        if (resource == null) {
            return key;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = this.getText((String)args[i]);
        }
        return resource.message(key.substring(index + 1), args);
    }

    private Resource getResource(String resourceId) {
        ResourceInfo resourceInfo = this.getResourceInfo(resourceId);
        if (resourceInfo == null) {
            return null;
        }
        return resourceInfo.getResource(this);
    }

    private int getSeparatorIndex(String key) {
        if (key == null || key.length() == 0) {
            return -1;
        }
        int index = key.indexOf(46);
        if (index == key.length() - 1) {
            return -1;
        }
        return index;
    }
}

