/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import nga.servlet.config.ModuleInfo;
import nga.util.Resource;
import nga.util.UserLocale;

public class ResourceInfo {
    private static final long serialVersionUID = 1L;
    private String id;
    private String resourceName;
    private String parentId;
    private Map<Locale, Resource> resourceMap = new HashMap<Locale, Resource>();

    public ResourceInfo(String id, String resourceName, String parentId) {
        this.id = id;
        this.resourceName = resourceName;
        this.parentId = parentId;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.id;
    }

    public Resource getResource(ModuleInfo moduleInfo) {
        Locale locale = UserLocale.getLocale();
        Resource resource = this.resourceMap.get(locale);
        if (resource == null) {
            resource = new Resource(this.resourceName, locale);
            if (this.parentId != null) {
                resource.setParent(moduleInfo.getResourceInfo(this.parentId).getResource(moduleInfo));
            }
            this.resourceMap.put(locale, resource);
        }
        return resource;
    }
}

