/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import nga.servlet.config.ConfigurationInfo;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.TargetInfoList;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetInfo
extends ConfigurationInfo {
    private static final long serialVersionUID = 1L;
    private TargetInfoList children;

    public TargetInfo(ModuleInfo moduleInfo) {
        super(moduleInfo, 20);
    }

    public String getType() {
        return this.get("type");
    }

    public void setType(String type) {
        this.put("type", type);
    }

    public String getName() {
        return this.get("name");
    }

    public void setName(String value) {
        this.put("name", value);
    }

    public String getInclude() {
        return this.get("include");
    }

    public void setInclude(String include) {
        this.put("include", include);
    }

    public TargetInfoList getChildren() {
        return this.children;
    }

    public void setChildren(TargetInfoList children) {
        this.children = children;
    }

    public String getId() {
        return this.get("id", this.getName());
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        super.putAll(map);
        if (map instanceof TargetInfo) {
            TargetInfo targetInfo = (TargetInfo)map;
            if (targetInfo.children != null) {
                this.children = new TargetInfoList();
                for (TargetInfo child : targetInfo.children) {
                    TargetInfo ti = new TargetInfo(this.getModuleInfo());
                    ti.putAll(child);
                    this.children.add(ti);
                }
            }
        }
    }

    public Object getAttribute(String name, Object resultObject) {
        String s = (String)super.get(name);
        if (s != null && s.length() > 0 && s.charAt(0) == this.getModuleInfo().resourceTag && s.indexOf(46) <= 0 && resultObject != null) {
            try {
                return MethodOperator.get(s.substring(1), resultObject);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(e.getCause());
            }
        }
        return super.get(name);
    }

    public boolean getAttribute(String name, Object resultObject, boolean defaultAttribute) {
        Object o = this.getAttribute(name, resultObject);
        if (o == null) {
            return defaultAttribute;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public int getAttribute(String name, Object resultObject, int defaultAttribute) {
        Object o = this.getAttribute(name, resultObject);
        if (o == null) {
            return defaultAttribute;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultAttribute;
        }
    }

    public long getAttribute(String name, Object resultObject, long defaultAttribute) {
        Object o = this.getAttribute(name, resultObject);
        if (o == null) {
            return defaultAttribute;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            return defaultAttribute;
        }
    }
}

