/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import javax.servlet.ServletException;
import nga.servlet.config.TargetInfo;
import nga.servlet.dsp.writer.TargetValueWriter;

public class CheckBoxWriter
extends TargetValueWriter {
    public void write() throws IOException, ServletException {
        Object onchanged;
        TargetInfo ti = this.targetValue.getTargetInfo();
        Object resultObject = this.targetValue.getResultObject();
        this.print("<input").attr("type", this.getType()).attr("id", ti.getId()).attr("name", ti.getName());
        this.attr("class", ti, resultObject);
        this.setValue();
        if (!ti.getAttribute("visible", resultObject, true)) {
            this.attr("style", "display:none");
        }
        if (ti.getAttribute("disabled", resultObject, false)) {
            this.attr("disabled", "disabled");
        }
        if ((onchanged = ti.getAttribute("onchanged", resultObject)) == null) {
            onchanged = ti.getAttribute("onchange", resultObject);
        }
        StringBuilder onchangeScript = new StringBuilder();
        onchangeScript.append(this.getOnchangeScript());
        if (onchanged != null) {
            onchangeScript.append(onchanged);
        } else {
            Object request = ti.getAttribute("request-onchanged", resultObject);
            if (request != null) {
                onchangeScript.append(onchanged).append("new CongaRequest().send('" + request + "');");
            }
        }
        if (onchangeScript.length() > 0) {
            this.attr("onchange", onchangeScript);
        }
        this.print("/>");
    }

    protected String getOnchangeScript() {
        return "this.value=(this.checked)?'true':'false';";
    }

    protected String getType() {
        return "checkbox";
    }

    protected void setValue() {
        boolean value = this.getValue();
        this.attr("value", value ? "true" : "false");
        if (value) {
            this.attr("checked", "checked");
        }
    }

    private boolean getValue() {
        Object valueObject = this.targetValue.getValue();
        if (valueObject instanceof Boolean) {
            return (Boolean)valueObject;
        }
        if (valueObject instanceof String) {
            return Boolean.parseBoolean((String)valueObject);
        }
        if (valueObject != null) {
            return Boolean.parseBoolean(valueObject.toString());
        }
        return false;
    }
}

