/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.dsp.writer.AbstractResultWriter;

public abstract class Downloader
extends AbstractResultWriter {
    protected String getFileName(ResultInfo resultInfo) {
        return resultInfo.get("file", "test.txt");
    }

    protected String getContentType(ResultInfo resultInfo, String charset) {
        return resultInfo.get("content-type", "application/octet-stream; charset=" + charset);
    }

    protected void handleWrite(ServiceInfo serviceInfo) throws IOException, ServletException {
        HttpServletRequest request = serviceInfo.getRequest();
        HttpServletResponse response = serviceInfo.getResponse();
        ResultInfo resultInfo = serviceInfo.getResultInfo();
        this.setResponseHeader(request, response, resultInfo);
        this.write(resultInfo, response.getOutputStream(), serviceInfo.getResultObject());
    }

    protected abstract void write(ResultInfo var1, ServletOutputStream var2, Object var3) throws IOException, ServletException;

    protected void setResponseHeader(HttpServletRequest request, HttpServletResponse response, ResultInfo resultInfo) {
        response.setContentType(this.getContentType(resultInfo, request.getCharacterEncoding()));
        response.addHeader("Content-Disposition", "attachment; filename=\"" + this.getFileName(resultInfo) + "\"");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Expires", "0");
    }
}

