/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import javax.servlet.ServletException;
import nga.servlet.ErrorInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.dsp.writer.TargetValueWriter;

public class TextInputWriter
extends TargetValueWriter {
    public void write() throws IOException, ServletException {
        int length;
        TargetInfo ti = this.targetValue.getTargetInfo();
        Object resultObject = this.targetValue.getResultObject();
        StringBuilder style = new StringBuilder();
        this.print("<input").attr("type", "text").attr("id", ti.getId());
        this.attr("class", ti, resultObject);
        String inputType = ti.get("input-type", "text");
        if ("number".equals(inputType)) {
            this.attr("onfocus", "ITextInput.delComma(this)");
            style.append("ime-mode:disabled;text-align:right;");
            length = ti.get("length", 0x7FFFFFFD);
            boolean positiveOnly = ti.get("positive-only", false);
            int scale = ti.get("scale", 0);
            this.attr("onkeypress", scale > 0 ? "ITextInput.chkDec(event)" : "ITextInput.chkInt(event)");
            int ilen = length;
            if (scale > 0) {
                ilen = length - scale;
                ++length;
            }
            if (!positiveOnly) {
                ++length;
            }
            this.attr("maxlength", length);
            this.attr("onchange", "ITextInput.chkNum(event,this," + ilen + "," + scale + "," + positiveOnly + ")");
        } else {
            this.attr("onfocus", "this.select()");
            length = ti.get("length", 0);
            if (length > 0) {
                this.attr("maxlength", length);
            }
            if ("alnum".equals(inputType)) {
                this.attr("onchange", "ITextInput.chkAlnum(event,this)");
            }
            if ("alnum".equals(inputType) || "date".equals(inputType) || "time".equals(inputType)) {
                style.append("ime-mode:disabled;");
            }
        }
        this.attr("name", ti.getName());
        ErrorInfo.Item errorItem = this.getErrorItem();
        if (errorItem != null) {
            style.append("background-color:pink;");
            String message = errorItem.getMessage();
            if (message != null) {
                this.attr("title", message);
                style.append("cursor:help;");
            }
            this.attr("value", errorItem.getValue());
        } else {
            this.attr("value", this.targetValue.getValue(), TextInputWriter.getFormat(ti));
        }
        if (!ti.getAttribute("visible", resultObject, true)) {
            style.append("display:none;");
        }
        if (ti.getAttribute("disabled", resultObject, false)) {
            this.attr("disabled", "disabled");
        }
        if (ti.getAttribute("read-only", resultObject, false)) {
            this.attr("readonly", "readonly");
        }
        this.attr("style", new String(style));
        this.print("/>");
    }
}

