/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nga.model.Tree;
import nga.model.TreeNode;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.TargetValueWriter;

public class TreeWriter
extends TargetValueWriter {
    protected TargetInfo targetInfo;
    private Map<String, TargetInfo> nodeInfoMap;
    private String openedNodeIcon;
    private String closedNodeIcon;
    private String nodeIcon;
    private String plusIcon;
    private String minusIcon;

    public void write() throws IOException {
        this.init();
        this.printTree((Tree)this.targetValue.getValue());
    }

    protected void init() {
        this.targetInfo = this.targetValue.getTargetInfo();
        TargetInfoList nodeInfoList = this.targetInfo.getChildren();
        if (nodeInfoList != null && !nodeInfoList.isEmpty()) {
            this.nodeInfoMap = new HashMap<String, TargetInfo>();
            for (TargetInfo nodeInfo : nodeInfoList) {
                this.nodeInfoMap.put(nodeInfo.getType(), nodeInfo);
            }
        }
        this.openedNodeIcon = TreeWriter.getOpenedNodeIcon(this.targetInfo);
        this.closedNodeIcon = TreeWriter.getClosedNodeIcon(this.targetInfo);
        this.nodeIcon = TreeWriter.getNodeIcon(this.targetInfo);
        this.plusIcon = TreeWriter.getPlusIcon(this.targetInfo);
        this.minusIcon = TreeWriter.getMinusIcon(this.targetInfo);
    }

    public static String getOpenedNodeIcon(TargetInfo targetInfo) {
        return targetInfo.get("opened-node-icon", null);
    }

    public static String getClosedNodeIcon(TargetInfo targetInfo) {
        return targetInfo.get("closed-node-icon", null);
    }

    public static String getNodeIcon(TargetInfo targetInfo) {
        return targetInfo.get("node-icon", null);
    }

    public static String getPlusIcon(TargetInfo targetInfo) {
        return targetInfo.get("plus-icon", null);
    }

    public static String getMinusIcon(TargetInfo targetInfo) {
        return targetInfo.get("minus-icon", null);
    }

    protected void printTree(Tree tree) {
        this.print("<div");
        this.attr("class", "itree").attr("id", this.targetInfo.getId()).attr("style", "overflow:auto");
        this.println(">");
        this.print("<input type=\"hidden\" name=\"").print(this.targetInfo.getName()).println("\">");
        this.printNode(tree.getRootNode());
        this.print("</div>");
    }

    protected void printNode(TreeNode node) {
        this.print("<div class=\"node\" id=\"");
        this.print(node.getId());
        if (node.isRootNode()) {
            this.print("\" style=\"left:0px;");
        }
        this.println("\">");
        this.printOpenerIcon(node);
        this.printNodeIcon(node);
        this.printNodeValue(node);
        if (!node.isLeaf()) {
            this.print("<div class=\"children\" style=\"display:");
            this.print(node.isOpened() ? "block" : "none");
            this.println("\">");
            List children = node.getChildren();
            for (TreeNode childNode : children) {
                this.printNode(childNode);
            }
            this.println("</div>");
        }
        this.print("</div>");
    }

    protected void printNodeValue(TreeNode node) {
        TargetInfo nodeInfo;
        this.print("<input class=\"value\" onfocus=\"this.select()\" readonly  onmouseover=\"this.style.textDecoration='underline'\" onmouseout=\"this.style.textDecoration='none'\" onclick=\"ITree.input_onclick(event)\" onkeydown=\"ITree.input_onkeydown(event)\" value=\"");
        String nodeType = node.getNodeType();
        String format = null;
        if (nodeType != null && (nodeInfo = this.nodeInfoMap.get(nodeType)) != null) {
            format = TreeWriter.getFormat(nodeInfo);
        }
        String value = WriterUtil.format(node.getNodeValue(), format);
        this.print(value).print("\" title=\"").print(value).println("\">");
    }

    protected void printOpenerIcon(TreeNode node) {
        this.print("<span class=\"opener\"");
        if (node.isLeaf()) {
            this.print(">");
        } else {
            this.print(" onmousedown=\"ITree.opener_onmousedown(event)\">");
            this.printIcon(node, this.minusIcon, this.plusIcon);
        }
        this.println("</span>");
    }

    private void printIcon(TreeNode node, String openedIcon, String closedIcon) {
        if (openedIcon != null && closedIcon != null && !openedIcon.equals(closedIcon)) {
            this.print("<img src=\"");
            this.print(closedIcon);
            this.print("\"");
            this.print(node.isOpened() ? " style=\"display:none\"" : "");
            this.print(">");
            this.print("<img src=\"");
            this.print(openedIcon);
            this.print("\"");
            this.print(node.isOpened() ? "" : " style=\"display:none\"");
            this.print(">");
        } else {
            String icon = null;
            if (openedIcon != null) {
                icon = openedIcon;
            } else if (closedIcon != null) {
                icon = closedIcon;
            }
            if (icon != null) {
                this.print("<img src=\"");
                this.print(icon);
                this.print("\">");
            }
        }
    }

    protected void printNodeIcon(TreeNode node) {
        TargetInfo nodeInfo = null;
        String nodeType = node.getNodeType();
        if (nodeType != null && this.nodeInfoMap != null) {
            nodeInfo = this.nodeInfoMap.get(nodeType);
        }
        String icon = this.getNodeIcon0(nodeInfo);
        this.print("<span class=\"icon\"");
        if (node.isLeaf()) {
            this.print(">");
            this.print("<img src=\"");
            this.print(icon);
            this.print("\">");
        } else {
            this.print(" onclick=\"ITree.icon_onclick(event)\">");
            this.printIcon(node, this.getOpenedNodeIcon0(nodeInfo, icon), this.getClosedNodeIcon0(nodeInfo, icon));
        }
        this.println("</span>");
    }

    private String getNodeIcon0(TargetInfo nodeInfo) {
        String icon = nodeInfo != null ? TreeWriter.getNodeIcon(nodeInfo) : this.nodeIcon;
        return icon;
    }

    private String getOpenedNodeIcon0(TargetInfo nodeInfo, String icon) {
        String openedNodeIcon = null;
        if (nodeInfo != null) {
            openedNodeIcon = TreeWriter.getOpenedNodeIcon(nodeInfo);
        }
        if (openedNodeIcon == null) {
            openedNodeIcon = this.openedNodeIcon;
        }
        if (openedNodeIcon != null) {
            icon = openedNodeIcon;
        }
        return icon;
    }

    private String getClosedNodeIcon0(TargetInfo nodeInfo, String icon) {
        String closedNodeIcon = null;
        if (nodeInfo != null) {
            closedNodeIcon = TreeWriter.getClosedNodeIcon(nodeInfo);
        }
        if (closedNodeIcon == null) {
            closedNodeIcon = this.closedNodeIcon;
        }
        if (closedNodeIcon != null) {
            icon = closedNodeIcon;
        }
        return icon;
    }
}

