/*
 * Decompiled with CFR 0.152.
 */
package nga.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nga.sql.Selecter;
import nga.sql.impl.SQLImplBase;
import nga.sql.impl.Where;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelecterImpl<R>
extends SQLImplBase
implements Selecter<R> {
    private List<Method> methodList;
    private Class<? extends R> resultClass;
    private Where where;
    private int queryTimeout = -1;
    private int maxRows = Integer.MAX_VALUE;
    private boolean exceeded;

    public SelecterImpl(Connection con, Class<? extends R> resultClass, String sql) {
        this(con, resultClass, sql, null);
    }

    public SelecterImpl(Connection con, Class<? extends R> resultClass, String sql, Object ... parameterObject) {
        super(con, "");
        this.resultClass = resultClass;
        this.createWhere(sql, parameterObject);
    }

    public void setParameter(Object ... parameterObject) {
        this.where.setParameter(parameterObject);
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private void createMethodList() {
        if (this.methodList != null) {
            return;
        }
        if (this.resultClass == null) {
            this.methodList = Collections.emptyList();
            return;
        }
        Map<String, Method> fieldMap = MethodOperator.getSetterMethods(this.resultClass);
        String temp = new String(this.where.getUserSQL()).toUpperCase();
        int index = temp.indexOf(" FROM ");
        if (index == -1) {
            throw new ConfigurationException(this.message("m_not_found_from", temp));
        }
        ArrayList<Method> list = new ArrayList<Method>(fieldMap.size());
        if ((temp = temp.substring(0, index)).indexOf(40) > -1) {
            temp = this.removeFunc(temp);
        }
        StringTokenizer st = new StringTokenizer(temp, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            Method field;
            String s = st.nextToken().trim();
            int dotIndex = (s = s.substring(s.lastIndexOf(32) + 1)).lastIndexOf(46);
            if (dotIndex > 0) {
                s = s.substring(dotIndex + 1);
            }
            if ((field = fieldMap.get(s)) == null) {
                throw new ConfigurationException(this.message("m_no_setter_method", this.resultClass.getName(), s));
            }
            list.add(field);
            ++i;
        }
        this.methodList = list;
    }

    private String removeFunc(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '(') continue;
            sb.append(s.substring(start, i));
            start = i = this.skip(s, i + 1);
        }
        sb.append(s.substring(start));
        return new String(sb);
    }

    private int skip(String s, int start) {
        int cnt = 0;
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(') {
                ++cnt;
                continue;
            }
            if (c != ')') continue;
            if (cnt <= 0) {
                return i + 1;
            }
            --cnt;
        }
        return s.length();
    }

    @Override
    public Selecter<R> add(String s) {
        this.where.handleAdd(s);
        return this;
    }

    @Override
    public Selecter<R> and(String s) {
        this.where.handleAnd(s);
        return this;
    }

    @Override
    public Selecter<R> or(String s) {
        this.where.handleOr(s);
        return this;
    }

    private Where createWhere(String sql, Object ... params) {
        this.where = new Where(this.connection, sql, params);
        this.where.setDebugMode(this.isDebugMode());
        return this.where;
    }

    private String getParsedSQL(boolean count) {
        this.createMethodList();
        String sql = this.where.getParsedSQL();
        if (count) {
            int index = new String(sql).toUpperCase().indexOf(" FROM ");
            return "SELECT COUNT(*) FROM " + sql.substring(index + 6);
        }
        return sql;
    }

    @Override
    public List<R> find() throws SQLException {
        return this.find((R)new ArrayList(100));
    }

    @Override
    public List<R> find(List<R> list) throws SQLException {
        if (list == null) {
            throw new IllegalArgumentException(this.message("m_argument_is_null", new Object[0]));
        }
        if (this.resultClass == null) {
            throw new IllegalArgumentException(this.message("m_resultclass_is_null", new Object[0]));
        }
        long startTime = this.start();
        ResultSet rs = null;
        try {
            rs = this.executeQuery(false);
            int maxRows = this.getMaxRows();
            for (int i = 0; i < maxRows && rs.next(); ++i) {
                R o = this.resultClass.newInstance();
                list.add(this.createResult(rs, o));
            }
            if (rs.next()) {
                this.setExceeded(true);
            }
            List<R> list2 = list;
            return list2;
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        finally {
            this.close(rs);
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R find(R object) throws SQLException {
        if (object == null) {
            throw new IllegalArgumentException(this.message("m_argument_is_null", new Object[0]));
        }
        if (this.resultClass == null) {
            throw new IllegalArgumentException(this.message("m_resultclass_is_null", new Object[0]));
        }
        long startTime = this.start();
        ResultSet rs = null;
        try {
            rs = this.executeQuery(false);
            if (!rs.next()) {
                R r = null;
                return r;
            }
            this.createResult(rs, object);
            if (rs.next()) {
                this.setExceeded(true);
            }
            R r = object;
            return r;
        }
        finally {
            this.close(rs);
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() throws SQLException {
        long startTime = this.start();
        ResultSet rs = null;
        try {
            rs = this.executeQuery(true);
            boolean b = rs.next();
            if (!b) {
                int n = 0;
                return n;
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            this.close(rs);
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        long startTime = this.start();
        try {
            ResultSet resultSet = this.executeQuery(false);
            return resultSet;
        }
        finally {
            this.end(startTime);
        }
    }

    private ResultSet executeQuery(boolean count) throws SQLException {
        try {
            this.setExceeded(false);
            String sql = this.getParsedSQL(count);
            PreparedStatement ps = this.prepareStatement(sql);
            if (this.getQueryTimeout() > -1) {
                ps.setQueryTimeout(this.getQueryTimeout());
            }
            if (this.getMaxRows() != Integer.MAX_VALUE) {
                ps.setMaxRows(this.getMaxRows() + 1);
            }
            if (this.where != null) {
                this.where.setParameter(ps);
            }
            if (this.where != null) {
                this.where.printSQL(sql);
            } else {
                this.printSQL(sql, null);
            }
            return ps.executeQuery();
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    private R createResult(ResultSet rs, R result) throws SQLException {
        try {
            for (int i = 0; i < this.methodList.size(); ++i) {
                MethodOperator.set(this.methodList.get(i), result, this.getResult(rs, this.methodList.get(i).getParameterTypes()[0], i + 1));
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private Object getResult(ResultSet rs, Class type, int index) throws SQLException {
        if (type.equals(String.class)) {
            return rs.getString(index);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(rs.getInt(index));
        }
        if (type.equals(BigDecimal.class)) {
            return rs.getBigDecimal(index);
        }
        if (type.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        if (type.equals(Date.class)) {
            return rs.getDate(index);
        }
        if (type.equals(Time.class)) {
            return rs.getTime(index);
        }
        if (type.equals(Boolean.TYPE)) {
            return new Boolean(rs.getBoolean(index));
        }
        if (type.equals(Character.TYPE)) {
            String s = rs.getString(index);
            if (rs.wasNull()) {
                return new Character('\u0000');
            }
            if (s != null && s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (type.equals(Long.TYPE)) {
            return new Long(rs.getLong(index));
        }
        if (type.equals(Short.TYPE)) {
            return new Short(rs.getShort(index));
        }
        if (type.equals(Float.TYPE)) {
            return new Float(rs.getFloat(index));
        }
        if (type.equals(Double.TYPE)) {
            return new Double(rs.getDouble(index));
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(rs.getByte(index));
        }
        if (type.equals(Integer.class)) {
            int i = rs.getInt(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Integer(i);
        }
        if (type.equals(Boolean.class)) {
            boolean b = rs.getBoolean(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Boolean(b);
        }
        if (type.equals(Long.class)) {
            long l = rs.getLong(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (type.equals(Short.class)) {
            short s = rs.getShort(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (type.equals(Float.class)) {
            float f = rs.getFloat(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (type.equals(Double.class)) {
            double d = rs.getDouble(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (type.equals(Byte.class)) {
            byte b = rs.getByte(index);
            if (rs.wasNull()) {
                return null;
            }
            return new Byte(b);
        }
        if (type.equals(Character.class)) {
            String s = rs.getString(index);
            if (rs.wasNull()) {
                return null;
            }
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return null;
        }
        return rs.getObject(index);
    }

    @Override
    public String toString() {
        return this.where.toString();
    }

    private void setExceeded(boolean exceeded) {
        this.exceeded = exceeded;
    }

    @Override
    public boolean isExceeded() {
        return this.exceeded;
    }

    @Override
    public void setDebugMode(boolean debug) {
        super.setDebugMode(debug);
        if (this.where != null) {
            this.where.setDebugMode(debug);
        }
    }
}

