/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Cache<K, V> {
    private int size;
    private Map<K, Value> values;
    private Value firstValue;
    private Value lastValue;

    public Cache(int size) {
        this.setMaxSize(size);
    }

    public Cache() {
        this(50);
    }

    public void setMaxSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.values = new HashMap<K, Value>((int)((float)size / 0.75f) + 1, 0.75f);
    }

    public int getMaxSize() {
        return this.size;
    }

    public V put(K key, V value) {
        Object oldValue;
        if (value == null) {
            throw new NullPointerException();
        }
        Value v = this.values.get(key);
        if (v == null) {
            v = new Value(key, value);
            if (this.firstValue == null) {
                this.firstValue = v;
            }
            if (this.values.size() >= this.size) {
                this.remove(this.firstValue.key);
            }
            this.values.put(key, v);
            oldValue = null;
        } else {
            oldValue = v.value;
            v.value = value;
            if (v == this.lastValue) {
                return (V)oldValue;
            }
            if (v.prevValue != null) {
                v.prevValue.nextValue = v.nextValue;
            }
            if (v.nextValue != null) {
                v.nextValue.prevValue = v.prevValue;
            }
            if (v == this.firstValue) {
                this.firstValue = v.nextValue;
            }
        }
        if (this.lastValue != null) {
            this.lastValue.nextValue = v;
            v.prevValue = this.lastValue;
        }
        this.lastValue = v;
        v.nextValue = null;
        return (V)oldValue;
    }

    public V get(K key) {
        Value v = this.values.get(key);
        if (v == null) {
            return null;
        }
        if (v != this.lastValue) {
            if (v.prevValue != null) {
                v.prevValue.nextValue = v.nextValue;
            }
            if (v.nextValue != null) {
                v.nextValue.prevValue = v.prevValue;
            }
            if (v == this.firstValue) {
                this.firstValue = v.nextValue;
            }
            this.lastValue.nextValue = v;
            v.prevValue = this.lastValue;
            this.lastValue = v;
            v.nextValue = null;
        }
        return (V)v.value;
    }

    public synchronized V remove(K key) {
        Value v = this.values.remove(key);
        if (v == null) {
            return null;
        }
        if (v.prevValue != null) {
            v.prevValue.nextValue = v.nextValue;
        }
        if (v.nextValue != null) {
            v.nextValue.prevValue = v.prevValue;
        }
        if (v == this.firstValue) {
            this.firstValue = v.nextValue;
        }
        if (v == this.lastValue) {
            this.lastValue = v.prevValue;
        }
        return (V)v.value;
    }

    public int size() {
        return this.values.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Value {
        private K key;
        private V value;
        private Value prevValue;
        private Value nextValue;

        private Value(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public boolean equals(Object o) {
            if (o instanceof Value) {
                return ((Value)o).key.equals(this.key) && ((Value)o).value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

