/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nga.util.Checker;

public class FormatUtil {
    private static Map<String, NumberFormat> numFmtMap = new HashMap<String, NumberFormat>();
    private static Map<String, DateFormat> dtFmtMap = new HashMap<String, DateFormat>();

    private FormatUtil() {
    }

    public static java.sql.Date toDate(Date dd) {
        if (dd == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dd);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public static Time toTime(Date dd) {
        if (dd == null) {
            return null;
        }
        return new Time(dd.getTime());
    }

    public static Timestamp toTimestamp(Date dd) {
        if (dd == null) {
            return null;
        }
        return new Timestamp(dd.getTime());
    }

    public static java.sql.Date toDate(String dd, String fmt) {
        return FormatUtil.toDate(FormatUtil.parse(dd, fmt));
    }

    public static Time toTime(String dd, String fmt) {
        return FormatUtil.toTime(FormatUtil.parse(dd, fmt));
    }

    public static Timestamp toTimestamp(String dd, String fmt) {
        return FormatUtil.toTimestamp(FormatUtil.parse(dd, fmt));
    }

    public static Date parse(String date, String fmt) {
        try {
            return FormatUtil.getDateFormat(fmt).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static DateFormat getDateFormat(String fmt) {
        DateFormat f = dtFmtMap.get(fmt);
        if (f == null) {
            f = new SimpleDateFormat(fmt);
            f.setLenient(false);
            dtFmtMap.put(fmt, f);
        }
        return f;
    }

    public static NumberFormat getNumberFormat(String fmt) {
        NumberFormat f = numFmtMap.get(fmt);
        if (f == null) {
            f = new DecimalFormat(fmt);
            numFmtMap.put(fmt, f);
        }
        return f;
    }

    public static String format(long num, String ptn) {
        return FormatUtil.getNumberFormat(ptn).format(num);
    }

    public static String format(double num, String ptn) {
        return FormatUtil.getNumberFormat(ptn).format(num);
    }

    public static String format(BigDecimal bd, String ptn) {
        return FormatUtil.getNumberFormat(ptn).format(bd.doubleValue());
    }

    public static String format(Date date, String fmt) {
        return FormatUtil.getDateFormat(fmt).format(date);
    }

    public static String codeName(String code, String name) {
        return FormatUtil.codeName(code, name, code == null ? 0 : code.length());
    }

    public static String codeName(String code, String name, int codeLength) {
        if (Checker.empty(code) && Checker.empty(name)) {
            return "";
        }
        if (Checker.empty(code) && !Checker.empty(name)) {
            return name;
        }
        if (!Checker.empty(code) && Checker.empty(name)) {
            return code;
        }
        return FormatUtil.space(code, codeLength) + " | " + name;
    }

    private static String space(String s, int len) {
        if (len == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (i < s.length()) {
                sb.append(s.charAt(i));
                continue;
            }
            sb.append(" ");
        }
        return new String(sb);
    }
}

