/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nga.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodOperator {
    private static final String GETTER_FLAG = "get";
    private static final String SETTER_FLAG = "set";
    private static Cache<Class, Map<String, Method>> rCache = new Cache(1000);
    private static Cache<Class, Map<String, Method>> wCache = new Cache(1000);

    public static void set(Method wm, Object object, Object value) throws IllegalAccessException, InvocationTargetException {
        if (value == null) {
            wm.invoke(object, MethodOperator.getNullValue(wm.getParameterTypes()[0]));
        } else {
            wm.invoke(object, value);
        }
    }

    public static void set(String wm, Object object, Object value) throws IllegalAccessException, InvocationTargetException {
        MethodOperator.set(MethodOperator.getSetterMethod(object.getClass(), wm), object, value);
    }

    public static Method getSetterMethod(Class c, String methodName) {
        return MethodOperator.getSetterMethods(c).get(methodName);
    }

    private static Object getNullValue(Class c) {
        if (c.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (c.equals(Boolean.TYPE)) {
            return new Boolean(false);
        }
        if (c.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (c.equals(Short.TYPE)) {
            return new Short(0);
        }
        if (c.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        if (c.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (c.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (c.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        return null;
    }

    public static Object get(Method rm, Object object) throws IllegalAccessException, InvocationTargetException {
        return rm.invoke(object, new Object[0]);
    }

    public static Object get(String rm, Object object) throws IllegalAccessException, InvocationTargetException {
        return MethodOperator.get(MethodOperator.getGetterMethods(object.getClass()).get(rm), object);
    }

    public static Method getGetterMethod(Class c, String methodName) {
        return MethodOperator.getGetterMethods(c).get(methodName);
    }

    public static Map<String, Method> getSetterMethods(Class c) {
        Map<String, Method> map = wCache.get(c);
        if (map == null) {
            map = MethodOperator.createMethodMap(c, SETTER_FLAG);
            wCache.put(c, map);
        }
        return map;
    }

    public static Map<String, Method> getGetterMethods(Class c) {
        Map<String, Method> map = rCache.get(c);
        if (map == null) {
            map = MethodOperator.createMethodMap(c, GETTER_FLAG);
            rCache.put(c, map);
        }
        return map;
    }

    private static Map<String, Method> createMethodMap(Class c, String flag) {
        HashMap<String, Method> table = new HashMap<String, Method>(){

            @Override
            public Method get(Object name) {
                try {
                    String s = (String)name;
                    return (Method)super.get(s != null ? s.toUpperCase() : null);
                }
                catch (ClassCastException e) {
                    return (Method)super.get(name);
                }
            }
        };
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            String name = method[i].getName();
            String prop = null;
            if (flag == GETTER_FLAG && name.startsWith("is") && name.length() > 2) {
                prop = name.substring(2);
            } else if (name.startsWith(flag) && name.length() > 3 && !MethodOperator.exMethod(name)) {
                prop = name.substring(3);
            }
            if (prop == null) continue;
            if (prop.length() == 1) {
                table.put(prop.toUpperCase(), method[i]);
                continue;
            }
            table.put(prop.substring(0, 1).toUpperCase() + prop.substring(1).toUpperCase(), method[i]);
        }
        return table;
    }

    private static boolean exMethod(String name) {
        return "getClass".equals(name);
    }
}

