/**
 * IMenu を作成する。
 */
function IMenu() {

	//// 変数定義
	var handler = this;
	var htmlElement = document.createElement("div");
	var container = document.body;
	var menuItem = new Array();

	//// プロパティ定義

	/**
	 * HTML実体要素オブジェクト。
	 */
	this.htmlElement = htmlElement;

	//// public メソッド定義

	/**
	 * メニューを表示する。
	 * @param event メニュー表示の起因となったイベント。
	 */
	this.show = function(event) {
		event = IWidget.getWindowPosition(event, htmlElement);
		htmlElement.style.zIndex = IWidget.getMaxZIndex();
		htmlElement.style.left = event.posX;
		htmlElement.style.top = event.posY;
		htmlElement.style.visibility = "visible";
		htmlElement.style.filter = "alpha(opacity=100)";
		return handler;
	};

	/**
	 * メニューを非表示にする。
	 */
	this.hide = function() {
		IWidget.hideSlowly(htmlElement);
		return handler;
	}


	/**
	 * メニューへ項目追加を行なう。
	 * @param text 項目名称。
	 * @param func メニュークリック時に実行するファンクション。
	 * @param accessKey アクセスキー。
	 */
	this.addItem = function(text, func, accessKey) {
		var input = document.createElement("input");
		input.type = "button";
		input.value = IResource.get(text);
		if(accessKey) {
			input.accessKey = accessKey;
		}
		input.onclick = function() {
			htmlElement.style.visibility = "hidden";
			func();
			return false;
		}

		input.onmouseover = function(event) {
			event = IWidget.editEvent(event);
			event.target.originalBackgroundColor = event.target.style.backgroundColor;
			event.target.style.backgroundColor = "#000066";
			event.target.style.color = "white";
		}

		input.onmouseout = function(event) {
			event = IWidget.editEvent(event);
			event.target.style.backgroundColor = event.target.originalBackgroundColor;
			event.target.style.color = "black";
		}


		input.style.border = "none";
		input.style.textAlign = "left";
		input.style.paddingLeft = "14px";
		htmlElement.appendChild(input);
		htmlElement.appendChild(document.createElement("br"));

		var maxWidth = 0;
		for(var i=0; i < htmlElement.childNodes.length; i++) {
			var child = htmlElement.childNodes.item(i);
			maxWidth = Math.max(maxWidth, child.offsetWidth);
		}

		for(var i=0; i < htmlElement.childNodes.length; i++) {
			var child = htmlElement.childNodes.item(i);
			if(child.nodeName=="INPUT") {
				child.style.width = maxWidth;
			}
		}

		menuItem[text] = input;
		return handler;
	}

	/**
	 * メニュー項目の選択可不可を設定する。
	 * @param text メニュー項目名。
	 * @param enabled 選択可にするときは true。不可にするときは false。
	 */
	this.setEnabled = function(text, enabled) {
		menuItem[text].disabled = !enabled;
		return handler;
	}

	/**
	 * メニューを表示するオブジェクトを指定する。
	 * @param obj メニューを表示するオブジェクト。
	 */
	this.addTarget = function(obj) {
		obj.oncontextmenu = function(event) {
			event = IWidget.editEvent(event);
			handler.show(event);
			event.returnValue = false;
			event.cancelBubble = !event.returnValue;
			return event.returnValue;
		}
		return handler;
	}

	/**
	 * IMenu を初期化する。
	 */
	function init() {
		if(!IMenu.prototype.blockedDefaultMenu) {
			document.oncontextmenu = function(event) {
				return false;
			}

			IMenu.prototype.blockedDefaultMenu = true;
		}

		IWidget.initHtmlElement(handler, htmlElement, false);

		htmlElement.style.border = "outset 2px";
		htmlElement.className = "imenu";
		htmlElement.style.position = "absolute";

		container.appendChild(htmlElement);

		htmlElement.style.visibility = "hidden";
		htmlElement.onmouseout = function(event) {
			handler.mouseover = false;
			setTimeout(
				function(){
					if(!handler.mouseover){
						handler.hide();
					}
				}
			, 200);
		}

		htmlElement.onmouseover = function(event) {
			handler.mouseover = true;
			htmlElement.style.visibility = "visible";
		}
	}


	//// インスタンスの初期化
	init();
}
