/**
 * IDiv を作成する。
 * @param width 幅。[デフォルト=0]
 * @param height 高さ。[デフォルト=0]
 * @param container IDiv のコンテナ。[デフォルト=document.body]
 */
function IDiv(width, height, container) {

	//// 変数定義
	var handler = this;
	var htmlElement = document.createElement("div");


	//// プロパティ定義

	/**
	 * HTML実体要素オブジェクト。
	 */
	this.htmlElement = htmlElement;

	//// public メソッド定義

	/**
	 * 表示位置を設定する。
	 * @param left 横位置。
	 * @param top 縦位置。
	 */
	this.setPosition = function(left, top) {
		htmlElement.style.left = left;
		htmlElement.style.top = top;
		return handler;
	};

	/**
	 * サイズを設定する。
	 * @param width 幅。
	 * @param height 高さ。
	 */
	this.setSize = function(width, height) {
		htmlElement.style.width = width;
		htmlElement.style.height = height;
		return handler;
	}

	/**
	 * 表示位置とサイズをまとめて設定する。
	 * @param width 幅。
	 * @param height 高さ。
	 */
	this.setBounds = function(left, top, width, height) {
		htmlElement.handler.setPosition(left, top);
		htmlElement.handler.setSize(width, height);
		return handler;
	}

	/**
	 * 背景色を設定する。
	 */
	this.setColor = function(color) {
		htmlElement.style.backgroundColor = color;
		return handler;
	}

	/**
	 * 内容設定を行なう。
	 */
	this.setContent = function(obj) {
		IWidget.setContent(htmlElement, obj);
		return handler;
	}


	//// イベント定義

	/**
	 * このオブジェクトがドラッグ操作で移動されたときに呼び出される。
	 * @param left オブジェクト横位置。
	 * @param top オブジェクト縦位置。
	 * @param event マウスイベント。
	 */
	this.onmove = null;

	/**
	 * このオブジェクトがダブルクリックされたときに呼び出される。
	 * @param event ダブルクリックイベント。
	 */
	this.ondblclick = null;



	//// ローカルメソッド定義

	/**
	 * IDiv を初期化する。
	 * @param width 幅。[デフォルト=0]
	 * @param height 高さ。[デフォルト=0]
	 * @param container IDiv のコンテナ。[デフォルト=document.body]
	 */
	function init(width, height, container) {
		if(!width) {
			width = 0;
		}

		if(!height) {
			height = 0;
		}

		if(!container) {
			container = document.body;
		}

		IWidget.initHtmlElement(handler, htmlElement, true);

		htmlElement.style.position = "absolute";
		htmlElement.style.fontSize = "1pt";
		if(width>0) {
			htmlElement.style.width = width;
		}
		if(height>0) {
			htmlElement.style.height = height;
		}

		container.style.position = "relative";
		container.appendChild(htmlElement);

		htmlElement.ondblclick = function(event) {
			event = IWidget.editEvent(event);
			var obj = event.target;
			while(obj) {
				if(obj.handler && obj.handler.ondblclick) {
					obj.handler.ondblclick(event);
					event.resultValue = false;
					event.cancelBubble = true;
					return false;
				}
				obj = obj.parentNode;
			}
		}
	}

	//// インスタンスの初期化
	init(width, height, container);
}


