/**
 * ITextInput。
 */
function ITextInput() {

	//// public メソッド定義

	/**
	 * 指定された入力項目の値が英数字として妥当かどうかチェックする。
	 * @param event イベント。
	 * @param obj チェック対象入力項目。
	 * @return 英数字のみの場合は true。それ以外の文字が含まれる場合は false。
	 */
	ITextInput.chkAlnum = function(event, obj) {
		var str = obj.value;

		if (str.length == 0) {
			return true;
		}

		flg = false;
		for(i=0; i<str.length; i++) {
			c = str.charCodeAt(i);
			if((c >=0x0021 && c <= 0x007e)) {
				flg = true;
			}
			else {
				flg = false;
				break;
			}
		}

		if(flg==false) {
			showAlert(event, IResource.message("ITextInput.input_alnum"), obj);
		}

		return flg;
	}

	/**
	 * 指定された入力項目の値が数値として妥当かどうかをチェックする。
	 * @param event イベント。
	 * @param obj チェック対象入力項目。
	 * @param ilen 整数部桁数。
	 * @param flen 小数部桁数。
	 * @param positiveOnly マイナス値をエラーとする場合は true を設定。
	 * @return 数値のみの場合は true。それ以外の文字が含まれる場合は false。
	 */
	ITextInput.chkNum = function(event, obj, ilen, flen, positiveOnly) {
		var str = obj.value;

		if(str.length == 0) {
			return true;
		}

		/* カンマははじく*/
		nonCommaValue = str;
		while(nonCommaValue.indexOf(",") != -1) {
			nonCommaValue = nonCommaValue.replace(",","");
		}
		str = nonCommaValue;

		if(isNaN(str)) {
			showAlert(event, IResource.message("ITextInput.input_num"), obj);
			return false;
		}
		else {
			if(str.indexOf("x") > -1 || str.indexOf("X") > -1 || 
					str.indexOf("e") > -1 || str.indexOf("E") > -1) {
				showAlert(event, IResource.message("ITextInput.input_num"), obj);
				return false;
			}
		}

		var pindex = str.indexOf(".");
		var mindex = str.indexOf("-");

		/* 整数指定がある場合は，ピリオドをチェックする */
		if((flen==0) && (pindex > -1)) {
			showAlert(event, IResource.message("ITextInput.input_int"), obj);
			return false;
		}

		/* 正数指定がある場合は，マイナス値をチェックする */
		if(positiveOnly && (mindex > -1)) {
			showAlert(event, IResource.message("ITextInput.input_pos"), obj);
			return false;
		}

		/* マイナス記号の位置をチェックする */
		if(mindex>0) {
			showAlert(event, IResource.message("ITextInput.input_num"), obj);
			return false;
		}

		/* 整数部桁数をチェックする */
		var len = str.length;
		if(pindex>-1) {
			len = pindex;
		}
		if(mindex>-1) {
			len--;
		}
		if(len>ilen) {
			showAlert(event, IResource.message("ITextInput.input_int_with", ilen), obj);
			return false;
		}

		/* 小数部桁数をチェックする */
		if(pindex>-1) {
			len = str.length - (pindex+1);
			if(len>flen) {
				showAlert(event, IResource.message("ITextInput.input_dec_with", flen), obj);
				return false;
			}
		}

		/* カンマをはじいた値を設定する */
		obj.value = str;
		return true;
	}

	/*
	 * 整数項目用インプット値チェック。
	 * 押されたキーが数字または '-' である場合のみ入力を許します。
	 * @param event イベント。
	 */
	ITextInput.chkInt = function(event) {
		event = IWidget.editEvent(event);
		if(event.keyCode>47 && event.keyCode<58) {
			event.returnValue=true;
		}
		else if(event.keyCode==45 && event.srcElement.value.indexOf("-",0)==-1) {
			event.returnValue=true;
		}
		else {
			event.returnValue=false;
		}
		return event.returnValue;
	}

	/*
	 * 小数項目用インプット値チェック。
	 * 押されたキーが数字または '-' であるか，'.' である場合のみ入力を許します。
	 * @param event イベント。
	 */
	ITextInput.chkDec = function(event) {
		event = IWidget.editEvent(event);
		if(chkInt(event)) {
			return true;
		}
		else if(event.keyCode==46 && event.srcElement.value.indexOf(".",0)==-1) {
			event.returnValue=true;
		}
		else {
			event.returnValue=false;
		}
		return event.returnValue;
	}

	/**
	 * カンマ削除。
	 * 指定された obj 項目の中からカンマ文字を削除します。
	 * @param obj カンマ文字削除対象項目。
	 */
	ITextInput.delComma = function(obj) {
		try {
			obj.value = obj.value.split(",").join("");
			obj.select();
		}
		catch(e) {
		}
	}

	//// ローカルメソッド定義

	/*
	 * アラート表示。
	 * アラートを表示し，obj 項目にカーソルを移動します。
	 * @param errorMsg エラーメッセージ。
	 * @param obj カーソルを移動する項目。
	 */
	function showAlert(event, errorMsg, obj) {
		event = IWidget.editEvent(event);
		alert(errorMsg);
		event.returnValue = false;
		obj.value = "";
		obj.focus();
	}

}
new ITextInput();


