/*
 *Tree.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.model;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import nga.servlet.NameUtil;

/**
 * c[B
 */
public class Tree<T> implements UpdatableByText {

	/**
	 * [gm[hB
	 */
	private TreeNode<T> rootNode;

	/**
	 * ݑIĂm[hB
	 */
	private TreeNode<T> selectedNode;
	
	/**
	 * m[h}bvB
	 */
	private Map<String, TreeNode<T>> nodeMap = new HashMap<String, TreeNode<T>>();

	/**
	 * Tree 쐬B
	 */
	public Tree() {
		super();
	}

	/**
	 * VKm[h쐬B
	 * @param nodeValue m[h̒lB
	 * @param leaf tm[hǂB
	 * @return VKm[hB
	 */
	public TreeNode<T> createNode(T nodeValue, boolean leaf) {
		String id = NameUtil.getId();
		TreeNode<T> node = new TreeNode<T>(this, id, nodeValue, leaf);
		nodeMap.put(id, node);
		return node;
	}
	
	/**
	 * [gm[h擾B
	 * @return [gm[hB
	 */
	public TreeNode<T> getRootNode() {
		return rootNode;
	}
	
	/**
	 * [gm[hݒ肷B
	 * @param rootNode [gm[hB
	 */
	public void setRootNode(TreeNode<T> rootNode) {
		this.rootNode = rootNode;
	}
	
	/**
	 * [gm[h쐬Cݒ肷B<br>
	 * tree.setRootNode(tree.createNode(nodeValue, leaf)) ̃V[gJbgB
	 * @param nodeValue [gm[h̒lB
	 * @return 쐬[gm[hB
	 */
	public TreeNode<T> createRootNode(T nodeValue) {
		TreeNode<T> node = createNode(nodeValue, false);
		setRootNode(node);
		return node;
	}

	/**
	 * w肳ꂽm[hIԂɂB
	 * @param node IԂɂm[hB
	 */
	public void setSelectedNode(TreeNode<T> node) {
		node.select();
		this.selectedNode = node;
	}
	
	/**
	 * ݑIĂm[h擾B
	 * @return ݑIĂm[hB
	 */
	public TreeNode<T> getSelectedNode() {
		return selectedNode;
	}

	/**
	 * w肳ꂽm[hIԂɂB
	 * @param id m[hIDB
	 */
	public void setSelectedNodeById(String id) {
		setSelectedNode(getNodeById(id));
	}
	
	/**
	 * ̃c[̒w肳ꂽ id ̃m[h擾B
	 * @param id
	 * @return@w肳ꂽ ID ̃m[hB
	 */
	public TreeNode<T> getNodeById(String id) {
		return nodeMap.get(id);
	}
	
	/**
	 * ^ꂽeLXgɂČ݂̃CX^XXVB
	 * @param value ݂̃CX^XXV邽߂̃eLXgB
	 */
	public void update(String value) {
		StringTokenizer st = new StringTokenizer(value, ",");
		while(st.hasMoreTokens()) {
			setSelectedNodeById(st.nextToken());
		}
	}

}
