/*
 *RequestConfigInitializer.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PageInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResourceInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.config.TemplateInfo;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.util.ConfigurationException;
import nga.util.ConfigurationMap;
import nga.util.Resource;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * NGXgݒt@C̓ǂݍ݂sȂNXB
 */
class RequestConfigInitializer {

	/**
	 * XMLhLgr_t@NgB
	 */
	private static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

	/**
	 * \[XB
	 */
	private Resource messageResource = new Resource(getClass().getPackage().getName() + ".Message");
	
	/**
	 * W[B
	 */
	private ModuleInfo moduleInfo;
	
	/**
	 * ev[g̃}bvB
	 */
	private Map<String, TemplateInfo> templateInfoMap = new HashMap<String, TemplateInfo>();

	/**
	 * RequestConfigInitializer 쐬B
	 */
	public RequestConfigInitializer() {
		super();
	}

	/**
	 * W[擾B
	 * @param moduleName W[B
	 * @param config ServletConfigB
	 * @param context ServletContextB
	 * @param resourceTag \[X^OB
	 */
	public ModuleInfo getModuleInfo(String moduleName, ServletConfig config, ServletContext context, char resourceTag) throws ServletException {
		moduleInfo = new ModuleInfo(moduleName, resourceTag);

		// ftHg̃ev[gt@CǂݍށB
		try {
			initModuleInfo(moduleName, new File(context.getRealPath("conf"), "template.xml"), config, context);
		}
		catch (Exception e) {
			throw new ServletException(e);
		}
		
		// w肳ꂽW[̒`t@CǂݍށB
		readModuleInfo(moduleName, config, context);

		return moduleInfo;
	}

	/**
	 * w肳ꂽW[fBNg̒`t@CǂݍށB
	 * @param moduleName W[B
	 * @param config ServletConfigB
	 * @param context ServletContextB
	 */
	private void readModuleInfo(String moduleName, ServletConfig config, ServletContext context) throws ServletException {
		// NGXgݒ񂪊i[Ăt@C擾B
		File[] file = getConfigFile(moduleName, config, context);
		
		// t@Cǂݍ݁CNGXgݒ̏sȂB
		for(int i=0; i<file.length; i++) {
			try {
				initModuleInfo(moduleName, file[i], config, context);
			}
			catch (Exception e) {
				throw new ServletException(e);
			}
		}
	}
	
	/**
	 * NGXgݒ񂪊i[Ăt@C擾B
	 * @return NGXgݒ񂪊i[Ăt@CB
	 */
	private File[] getConfigFile(String moduleName, ServletConfig config, ServletContext context) {
		String configDir = config.getInitParameter(CongaServlet.CONFIG_DIR);
		if(configDir==null || configDir.length()==0) {
			configDir = "conf";
		}
		
		if(configDir.charAt(0)=='/' || configDir.charAt(0)=='\\') {
			configDir = configDir.substring(1);
		}

		configDir = moduleName + "/" + configDir;

		// *reqest-config.xml t@C擾
		String configFile = config.getInitParameter(CongaServlet.CONFIG_FILE);
		if(configFile==null) {
			configFile = "*request-config.xml";
		}
		int starIndex = configFile.indexOf('*');
		final String prefix = (starIndex>0)?configFile.substring(0, starIndex) : null;
		final String suffix = (starIndex<configFile.length()-1)?configFile.substring(starIndex+1) : null;

		File dir = new File(context.getRealPath(configDir));

		File[] tmp = dir.listFiles(
			new FilenameFilter(){
				public boolean accept(File d, String name) {
					if(prefix!=null && !name.startsWith(prefix)) {
						return false;
					}
					if(suffix!=null && !name.endsWith(suffix)) {
						return false;
					}
					return true;
				}
			}
		);

		// template.xml t@C擾
		File[] files;
		File template = new File(dir, "template.xml");
		if(tmp!=null && template.exists()) {
			// template.xml t@C͈ԍŏɓǂݍނ悤ɂ
			files = new File[tmp.length+1];
			files[0] = template;
			if(tmp.length > 0) {
				System.arraycopy(tmp, 0, files, 1, tmp.length);
			}
		}
		else {
			files = tmp;
		}

		if(files==null || files.length==0) {
			throw new ConfigurationException(message("m_not_found_config_file", (dir + File.separator + configFile)));
		}
		
		return files;
	}

	/**
	 * t@Cǂݍ݁CW[̏sȂB
	 * @param moduleName W[B
	 * @param file `t@CB
	 * @param config ServletConfigB
	 * @param context ServletContextB
	 */
	private void initModuleInfo(String moduleName, File file, ServletConfig config, ServletContext context) 
			throws ConfigurationException, IOException, SAXException, ParserConfigurationException, ServletException {
		Document doc = builderFactory.newDocumentBuilder().parse(file);
		includeModule(moduleName, doc, config, context);
		initTemplateInfo(doc);
		addResourceInfo(doc);
		addPageInfo(doc);
		addRequestInfo(doc);
	}
	
	/**
	 * include w肳Ă郂W[̒`ǉǂݍ݂B
	 * @param moduleName W[B
	 * @param doc hLgB
	 * @param config ServletConfigB
	 * @param context ServletContextB
	 */
	private void includeModule(String moduleName, Document doc, ServletConfig config, ServletContext context) throws ServletException {
		NodeList list = doc.getElementsByTagName("include");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			NamedNodeMap attr = node.getAttributes();

			String module = getValue(attr, "module");
			if(module==null) {
				throw new ConfigurationException(message("m_null_include_module"));
			}
			if(moduleName.equals(module)) {
				throw new ConfigurationException(message("m_cannot_include_own_module", moduleName));
			}
			readModuleInfo(module, config, context);
		}
	}	

	
	
	/**
	 * ev[gB
	 * @param doc hLgB
	 */
	private void initTemplateInfo(Document doc) {
		NodeList list = doc.getElementsByTagName("template");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			initTemplateInfo(node);
		}
	}

	/**
	 * template ^O擾B
	 * @param node 擾m[hB
	 */
	private void initTemplateInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_template_id"));
		}
		
		TemplateInfo templateInfo = templateInfoMap.get(id);
		if(templateInfo==null) {			
			templateInfo = new TemplateInfo(id);
			templateInfoMap.put(id, templateInfo);
		}
		
		String base = getValue(attr, "extends");
		if(base!=null) {
			TemplateInfo baseTemplateInfo = templateInfoMap.get(base);
			if(baseTemplateInfo==null) {
				throw new ConfigurationException(message("m_null_template_base", id, base));
			}
			templateInfo.update(baseTemplateInfo);
		}
		
		NodeList nlist = node.getChildNodes();
		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			String name = child.getNodeName();
			if("target".equals(name)) {
				TargetInfo targetInfo = templateInfo.getTargetInfo();
				addAttributes(targetInfo, child.getAttributes());
				NodeList children = child.getChildNodes();
				if(children!=null && children.getLength()>0) {
					targetInfo.setChildren(new TargetInfoList());
					initTarget(targetInfo.getChildren(), children);
				}
			}
			else if("property".equals(name)) {
				addAttributes(templateInfo.getPropertyInfo(), child.getAttributes());
			}
			else if("result".equals(name)) {
				addAttributes(templateInfo.getResultInfo(), child.getAttributes());
			}
			else if("parameter".equals(name)) {
				addAttributes(templateInfo.getParameterInfo(), child.getAttributes());
			}
		}
	}

	/**
	 * @param targetInfo
	 * @param attributes
	 */
	private void addAttributes(ConfigurationMap info, NamedNodeMap attr) {
		for(int i=0; i < attr.getLength(); i++) {
			Node n = attr.item(i);
			info.put(n.getNodeName(), n.getNodeValue());
		}
	}

	/**
	 * W[ resource ^ȌǉB
	 * @param doc hLgB
	 */
	private void addResourceInfo(Document doc) {
		NodeList list = doc.getElementsByTagName("resource");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			ResourceInfo resourceInfo = getResourceInfo(node);
			if(moduleInfo.setResourceInfo(resourceInfo.getId(), resourceInfo)!=null) {
				throw new ConfigurationException(message("m_dup_resource", resourceInfo.getId()));
			}
		}
	}

	/**
	 * resource ^O擾B
	 * @param node 擾m[hB
	 * @return resource ^OB
	 */
	private ResourceInfo getResourceInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_resource_id"));
		}

		String cls = getValue(attr, "class");
		if(cls==null) {
			throw new ConfigurationException(message("m_null_resource_class"));
		}

		return new ResourceInfo(id, cls, getValue(attr, "parent"));
	}

	/**
	 * W[ page ^ȌǉB
	 * @param doc hLgB
	 */
	private void addPageInfo(Document doc) {
		NodeList list = doc.getElementsByTagName("page");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			PageInfo pageInfo = getPageInfo(node);
			if(moduleInfo.setPageInfo(pageInfo.getId(), pageInfo)!=null) {
				throw new ConfigurationException(message("m_dup_page", pageInfo.getId()));
			}
		}
	}
	

	/**
	 * page ^O擾B
	 * @param node 擾m[hB
	 * @return page ^OB
	 */
	private PageInfo getPageInfo(Node node) throws ConfigurationException {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_page_id"));
		}

		PageInfo pageInfo = new PageInfo(id);

		String cls = getValue(attr, "class");
		if(cls==null) {
			throw new ConfigurationException(message("m_null_page_class"));
		}

		try {
			Class c = Class.forName(cls);
			pageInfo.setPageClass(c);
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", cls), e);
		}
		
		return pageInfo;
	}


	/**
	 * W[ request ^OǉB
	 * @param doc hLgB
	 */
	private void addRequestInfo(Document doc) {
		NodeList list = doc.getElementsByTagName("request");
		for(int i=0; i<list.getLength(); i++) {
			Node node = list.item(i);
			RequestInfo requestInfo = getRequestInfo(node);
			if(moduleInfo.setRequestInfo(requestInfo.getId(), requestInfo)!=null) {
				throw new ConfigurationException(message("m_dup_request", requestInfo.getId()));
			}
		}
	}

	/**
	 * request ^O̎擾sȂB
	 * @param nodde 擾m[hB
	 * @return request ^OB
	 */
	private RequestInfo getRequestInfo(Node node) throws ConfigurationException {
		NamedNodeMap attr = node.getAttributes();

		String id = getValue(attr, "id");
		if(id==null) {
			throw new ConfigurationException(message("m_null_request_id"));
		}

		RequestInfo requestInfo = new RequestInfo(id);
		
		// controller ̐ݒsȂB
		String controller = getValue(attr, "controller");
		if(controller!=null) {
			int dotIndex = controller.lastIndexOf('.');
			if(dotIndex==-1) {
				requestInfo.setController(null, controller);
			}
			else {
				if(dotIndex == 0 || dotIndex > controller.length()-2) {
					throw new ConfigurationException(message("m_invalid_controller_attribute"));
				}

				try {
					Class c = Class.forName(controller.substring(0, dotIndex));
					requestInfo.setController(c, controller.substring(dotIndex+1));
				}
				catch (ClassNotFoundException e) {
					throw new ConfigurationException(
							message("m_class_not_found", controller.substring(0, dotIndex)), e
					);
				}
			}
			
		}

		// page ̐ݒ
		requestInfo.setPage(getValue(attr, "page"));
		
		// ParameterInfo, ResultInfo ݒ肷B
		NodeList nlist = node.getChildNodes();
		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			String name = child.getNodeName();
			if("parameter".equals(name)) {
				requestInfo.setParameterInfo(getParameterInfo(child));
			}
			else if("result".equals(name)) {
				requestInfo.setResultInfo(getResultInfo(child));
			}
		}

		return requestInfo;
	}

	/**
	 * result ^O擾B
	 * @param node 擾m[hB
	 * @return result ^OB
	 */
	@SuppressWarnings("unchecked")
	private ResultInfo getResultInfo(Node node) {
		ResultInfo resultInfo = new ResultInfo(moduleInfo);
		
		NamedNodeMap attr = node.getAttributes();
		initConfigurationInfo(resultInfo, node, attr, "result");
		
		// Writer ̐ݒ
		String writerClass = getValue(attr, "writer");
		try {
			if(writerClass!=null) {
				resultInfo.setWriter((Class<ResultWriter>) Class.forName(writerClass));
			}
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", writerClass), e);
		}

		// ̐ݒ
		addAttributes(resultInfo, attr);

		// target ^O̐ݒ
		initTarget(resultInfo.getTargetInfoList(), node.getChildNodes());

		return resultInfo;
	}

	/**
	 * target ^O̐ݒsȂB
	 * @param targetInfoList target ^ÕXgB
	 * @param nlist 擾m[hXgB
	 */
	private void initTarget(TargetInfoList targetInfoList, NodeList nlist) {
		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			if(child.getNodeType()==Node.ELEMENT_NODE) {
				targetInfoList.add(getTargetInfo(child));
			}
		}
	}
	
	/**
	 * target ^O̎擾sȂB
	 * @param node 擾m[hB
	 * @return target ^OB
	 */
	private TargetInfo getTargetInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();
		TargetInfo targetInfo = new TargetInfo(moduleInfo);
		initConfigurationInfo(targetInfo, node, attr, "target");

		addAttributes(targetInfo, attr);
		
		NodeList children = node.getChildNodes();
		if(children!=null && children.getLength()>0) {
			targetInfo.setChildren(new TargetInfoList());
			initTarget(targetInfo.getChildren(), children);
		}
		return targetInfo;
	}

	/**
	 * parameter ^O擾B
	 * @param node 擾m[hB
	 * @return parameter ^OB
	 */
	@SuppressWarnings("unchecked")
	private ParameterInfo getParameterInfo(Node node) {
		ParameterInfo parameterInfo = new ParameterInfo(moduleInfo);
		
		NamedNodeMap attr = node.getAttributes();

		initConfigurationInfo(parameterInfo, node, attr, "parameter");

		// parser class ̐ݒ
		String parserClass = getValue(attr, "parser");
		try {
			if(parserClass!=null) {
				parameterInfo.setParser((Class<ParameterParser>) Class.forName(parserClass));
			}
		}
		catch (ClassNotFoundException e) {
			throw new ConfigurationException(message("m_class_not_found", parserClass), e);
		}

		// ̐ݒ
		addAttributes(parameterInfo, attr);

		// vpeB̐ݒ
		initProperty(parameterInfo.getPropertyInfoMap(), node.getChildNodes());

		return parameterInfo;
	}
	

	/**
	 * property ^O̐ݒsȂB
	 * @param propertyMap property ^Õ}bvB
	 * @param nlist 擾m[hXgB
	 */
	private void initProperty(PropertyInfoMap propertyMap, NodeList nlist) {

		for(int i=0; i<nlist.getLength(); i++) {
			Node child = nlist.item(i);
			if(child.getNodeType()==Node.ELEMENT_NODE) {
				PropertyInfo propertyInfo = getPropertyInfo(child);
				if(propertyMap.put(propertyInfo.getName(), propertyInfo)!=null) {
					throw new ConfigurationException(message("m_dup_property", propertyInfo.getName()));
				}
			}
		}
	}
	
	/**
	 * property ^O̎擾sȂB
	 * @param node 擾m[hB
	 * @return vpeBB
	 */
	private PropertyInfo getPropertyInfo(Node node) {
		NamedNodeMap attr = node.getAttributes();
		String name = getValue(attr, "name");
		if(name==null) {
			throw new ConfigurationException(message("m_null_property_name"));
		}
		PropertyInfo propertyInfo = new PropertyInfo(moduleInfo);
		initConfigurationInfo(propertyInfo, node, attr, "property");

		propertyInfo.setName(name);

		addAttributes(propertyInfo, attr);

		return propertyInfo;
	}

	/**
	 * l擾B
	 * @param attr 擾m[h}bvB
	 * @param name B
	 * @return lB
	 */
	private String getValue(NamedNodeMap attr, String name) {
		if(attr==null) {
			return null;
		}

		Node node = attr.getNamedItem(name);
		if(node!=null) {
			return node.getNodeValue();
		}
		else {
			return null;
		}
	}

	/**
	 * bZ[WԂB
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	private String message(String key, Object... args) {
		return messageResource.message(key, args);
	}
	
	/**
	 * ev[g̓KpsB
	 */
	private void initConfigurationInfo(ConfigurationMap config, Node node, NamedNodeMap attr, String nodeName) {
		String template;
		if(!node.getNodeName().equals(nodeName)) {
			template = node.getNodeName();
		}
		else {
			template= getValue(attr, "template");
		}

		if(template==null) {
			return;
		}

		TemplateInfo templateInfo = templateInfoMap.get(template);
		if(templateInfo==null) {
			return;
		}
		
		if(config instanceof PropertyInfo) {
			config.putAll(templateInfo.getPropertyInfo());
		}
		else if(config instanceof TargetInfo) {
			config.putAll(templateInfo.getTargetInfo());
		}
		else if(config instanceof ResultInfo) {
			config.putAll(templateInfo.getResultInfo());
		}
		else if(config instanceof ParameterInfo) {
			config.putAll(templateInfo.getParameterInfo());
		}
	}
}
