/*
 *ResourceInfo.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import nga.util.Resource;
import nga.util.UserLocale;

/**
 * resource ^OB
 */
public class ResourceInfo {

	private static final long serialVersionUID = 1L;

	/**
	 * IDB
	 */
	private String id;
	
	/**
	 * \[XB
	 */
	private String resourceName;
	
	/**
	 * e\[XID
	 */
	private String parentId;
	
	/**
	 * \[X̃P[ʃ}bvB
	 */
	private Map<Locale, Resource> resourceMap = new HashMap<Locale, Resource>();

	/**
	 * ResourceInfo 쐬B
	 * @param id IDB
	 * @param resourceName \[XB
	 * @param parentId e\[XIDB
	 */
	public ResourceInfo(String id, String resourceName, String parentId) {
		this.id = id;
		this.resourceName = resourceName;
		this.parentId = parentId;
	}
	
	/**
	 * \[XID擾B
	 * @return \[XIDB
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * e\[XID擾B
	 * @return e\[XIDB
	 */
	public String getParentId() {
		return id;
	}
	
	/**
	 * \[X擾B
	 * @return \[XB
	 */
	public Resource getResource(ModuleInfo moduleInfo) {
		Locale locale = UserLocale.getLocale();
		Resource resource = resourceMap.get(locale);
		if(resource==null) {
			resource = new Resource(resourceName, locale);
			if(parentId!=null) {
				resource.setParent(
					moduleInfo.getResourceInfo(parentId).getResource(moduleInfo)
				);
			}
			resourceMap.put(locale, resource);
		}
		return resource;
	}

}
