package nga.servlet.dsp.parser;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

import nga.servlet.ErrorInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.spi.ParameterParser;
import nga.util.ConfigurationException;
import nga.util.FormatUtil;

/**
 * 񂩂IuWFNg֕ϊC͒ľ؂sȂB
 * @see ParameterParser
 */
public abstract class PropertyValueParser {

	/**
	 * 񂩂IuWFNg֕ϊC͒ľ؂sȂB
	 * @param propertyValue ΏۏB
	 * @return ɏI true ԂBsꍇɂ false ԂB
	 */
	public abstract boolean parse(PropertyValue propertyValue);

	/**
	 * K{͍ڃ`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkRequired(PropertyValue pv) {
		String value = pv.getValue();
		PropertyInfo constraints = pv.getPropertyInfo();
		if(value==null || value.length()==0) {
			if(!isRequired(constraints)) {
				return true;
			}
			else {
				ErrorInfo errorInfo = pv.getErrorInfo();
				String name = pv.getName();
				String label = getLabel(constraints);
				if(label!=null) {
					errorInfo.add(name, null, "dspm.required2", label);
				}
				else {
					errorInfo.add(name, null, "dspm.required1");
				}
				return false;
			}
		}
		return true;
	}

	/**
	 * w肳ꂽ̒J}폜B
	 * @param val ΏەB
	 */
	protected String delC(String val) {
		if(val==null) {
			return null;
		}

		int len = val.length();
		if(len==0) {
			return null;
		}

		StringBuilder sb = new StringBuilder(len);
		for(int i=0; i<len; i++) {
			char c = val.charAt(i);
			if(c!=',') {
				sb.append(c);
			}
		}

		if(len!=sb.length()) {
			return new String(sb);
		}
		else {
			return val;
		}
	}

	/**
	 * lw肵͈͓̔ǂ`FbNB
	 * @param value `FbNΏۂ̒lB
	 * @param len B
	 * @return `FbN OK ȂtrueBNG ̏ꍇ falseB
	 */	
	protected boolean check(long value, int len) {
		return value < Math.pow(10, len);
	}

	/**
	 * l`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkNum(PropertyValue pv) {

		// K{̓`FbNsȂB
		if(!checkRequired(pv)) {
			return false;
		}

		PropertyInfo constraints = pv.getPropertyInfo();
		int length = getLength(constraints); // Š
		int scale = getScale(constraints);  // 
		int ilen; // 
		if(length==-1) {
			scale = -1;
			ilen = -1;
		}
		else if(scale==-1) {
			ilen = length;
		}
		else {
			ilen = length - scale;
		}

		// 
		String label = getLabel(constraints);

		String name = pv.getName();
		String value = pv.getValue();
		ErrorInfo errorInfo = pv.getErrorInfo();

		if(scale>-1) {
			//bigdecimal `FbN
			BigDecimal num = new BigDecimal(value);
			double d= num.setScale(0, BigDecimal.ROUND_DOWN).doubleValue();

			if(num.scale() > scale || d >= Math.pow(10, ilen)) {
				if(label!=null) {
						errorInfo.add(name, value, "dspm.ilen_flen2", ilen, scale, label);
				}
				else {
						errorInfo.add(name, value, "dspm.ilen_flen1", ilen, scale);
				}
				return false;
			}
			return true;
		}
		else if(ilen>0) {
			long num = Long.parseLong(value);
			if(num >= Math.pow(10, ilen)) {
				if(label!=null) {
						errorInfo.add(name, value, "dspm.ilen2", ilen, label);
				}
				else {
						errorInfo.add(name, value, "dspm.ilen1", ilen);
				}
			}
			
		}

		return true;
	}
	
	/**
	 * NumberFormatException B
	 * @param pv ΏۏB
	 * @return falseB
	 */
	protected boolean handleNumberFormatException(PropertyValue pv) {
		String label = getLabel(pv.getPropertyInfo());
		String name = pv.getName();
		String value = pv.getValue();
		ErrorInfo errorInfo = pv.getErrorInfo();

		if(label!=null) {
			errorInfo.add(name, value, "dspm.number_format_exception2", label);
		}
		else {
			errorInfo.add(name, value, "dspm.number_format_exception1");
		}
		return false;
	}

	/**
	 * tϊsȂB
	 * @param pv ΏۏB
	 * @return ϊoꍇ trueBϊłȂꍇ falseB
	 */
	protected boolean toDate(PropertyValue pv, String defaultFormat) {
		if(!checkRequired(pv)) {
			return false;
		}
		
		String value = pv.getValue();
		if(value==null || value.length()==0) {
			pv.setObject(null);
			return true;
		}

		PropertyInfo pi = pv.getPropertyInfo();
		String name = pv.getName();
		ErrorInfo errorInfo = pv.getErrorInfo();

		String format = getFormat(pi, defaultFormat);
		java.util.Date d = FormatUtil.parse(value, format);
		if(d==null) {
			String label = getLabel(pi);
			if(label!=null) {
				errorInfo.add(name, value, "dspm.format_exception2", format, label);
			}
			else {
				errorInfo.add(name, value, "dspm.format_exception1", format);
			}
			return false;
		}
		pv.setObject(d);
		return true;
	}

	/**
	 * 񒷃`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkLength(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		String value = pv.getValue();

		int length = getLength(constraints);
		if(length > 0 && value.length() > length) {
			ErrorInfo errorInfo = pv.getErrorInfo();
			String name = pv.getName();
			String label = getLabel(constraints);
			if(label!=null) {
				errorInfo.add(name, value, "dspm.length2", length, label);
			}
			else {
				errorInfo.add(name, value, "dspm.length1", length);
			}
			return false;
		}
		
		return true;
	}
	
	/**
	 * oCg`FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkByteLength(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		int bytelength = getBytelength(constraints);
		String systemEncoding = pv.getServiceInfo().getSystemEncoding();
		try {
			String value = pv.getValue();
			if(bytelength > 0 && value.getBytes(systemEncoding).length > bytelength) {
				ErrorInfo errorInfo = pv.getErrorInfo();
				String name = pv.getName();
				String label = getLabel(constraints);
				if(label!=null) {
					errorInfo.add(name, value, "dspm.bytelength2", bytelength, label);
				}
				else {
					errorInfo.add(name, value, "dspm.bytelength1", bytelength);
				}
				return false;
			}
		}
		catch (UnsupportedEncodingException e) {
			throw new ConfigurationException(
				pv.getModuleInfo().getMessage("dspm.unsupported_encoding", systemEncoding), e
			);
		}
		return true;
	}

	/**
	 * `FbNsȂB
	 * @param pv ΏۏB
	 * @return G[Ȃ trueBG[ꍇ falseB
	 */
	protected boolean checkCharType(PropertyValue pv) {
		PropertyInfo constraints = pv.getPropertyInfo();
		String chartype = getChartype(constraints);
		String value = pv.getValue();
		if(chartype!=null && !value.matches(chartype)) {
			ErrorInfo errorInfo = pv.getErrorInfo();
			String name = pv.getName();
			String label = getLabel(constraints);
			String comment = getChartypeComment(constraints);
			if(label!=null) {
				errorInfo.add(name, value, "dspm.chartype2", comment, label);
			}
			else {
				errorInfo.add(name, value, "dspm.chartype1", comment);
			}
			return false;
		}
		return true;
	}

	/**
	 * w肳ꂽ property ^O "parser" ({@link PropertyValueParser PropertyValueParserNX}) 
	 * Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @return "parser" Ŏw肳ꂽlB
	 */
	public static String getParser(PropertyInfo propertyInfo) {
		return propertyInfo.get("parser");
	}
	
	/**
	 * w肳ꂽ property ^O "required" (K{͍ڂǂ)  "true" w肳Ă邩ǂ
	 * ׂB
	 * @param propertyInfo property ^OB
	 * @return "required"  "true" w肳Ăꍇ trueB
	 * w肳ĂȂꍇ falseB
	 */
	public static boolean isRequired(PropertyInfo propertyInfo) {
		return propertyInfo.get("required", false);
	}
	
	/**
	 * w肳ꂽ property ^O "label" (x) Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @return "label" Ŏw肳ꂽlB
	 */
	public static String getLabel(PropertyInfo propertyInfo) {
		return propertyInfo.get("label");
	}
	
	/**
	 * w肳ꂽ property ^O "length" () Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @return "length" Ŏw肳ꂽlBw肳ĂȂꍇ -1 ԂB
	 */
	public static int getLength(PropertyInfo propertyInfo) {
		return propertyInfo.get("length", -1);
	}
	
	/**
	 * w肳ꂽ property ^O "scale" () Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @return "flen" Ŏw肳ꂽlBw肳ĂȂꍇ -1 ԂB
	 */
	public static int getScale(PropertyInfo propertyInfo) {
		return propertyInfo.get("scale", -1);
	}
	
	/**
	 * w肳ꂽ property ^O "bytelength" (oCg) Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @return "length" Ŏw肳ꂽlBw肳ĂȂꍇ -1 ԂB
	 */
	public static int getBytelength(PropertyInfo propertyInfo) {
		return propertyInfo.get("bytelength", -1);
	}

	/**
	 * w肳ꂽ property ^O "format" () Ŏw肳ꂽl擾B
	 * @param propertyInfo property ^OB
	 * @param defaultFormat ftHgtH[}bgB
	 * @return "format" Ŏw肳ꂽlBw肳ĂȂꍇ defaultFormatB
	 */
	public static String getFormat(PropertyInfo propertyInfo, String defaultFormat) {
		return propertyInfo.get("format", defaultFormat);
	}
	
	/**
	 * w肳ꂽ property ^O "chartype" () Ŏw肳ꂽl擾B
	 * {@link String#matches(java.lang.String) String.matches} Ń`FbN\ȐK\B
	 * @param propertyInfo property ^OB
	 * @return "chartype" Ŏw肳ꂽlB
	 */
	public static String getChartype(PropertyInfo propertyInfo) {
		return propertyInfo.get("chartype");
	}
	
	/**
	 * w肳ꂽ property ^O "chartype-comment" (Rg) Ŏw肳ꂽl擾B
	 * G[bZ[WƂėpB
	 * @param propertyInfo property ^OB
	 * @return "chartype-comment" Ŏw肳ꂽlB
	 */
	public static String getChartypeComment(PropertyInfo propertyInfo) {
		return propertyInfo.get("chartype-comment", getChartype(propertyInfo));
	}

}