/*
 *SelectWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;

import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;

/**
 * select / option ^OpC^B
 */
public class SelectWriter extends TargetValueWriter {

	/**
	 * SelectWriter 쐬B
	 */
	public SelectWriter() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write()
	 */
	@Override
	public void write() throws IOException, ServletException {
		TargetInfo ti = targetValue.getTargetInfo();
		Object resultObject = targetValue.getResultObject();

		writeSelectTag(ti, resultObject);

		writeOptionTags(ti, resultObject);
		
		print("</select>");
	}

	/**
	 * select ^Ȍo͂sȂB
	 */
	protected void writeSelectTag(TargetInfo ti, Object resultObject) {
		print("<select").attr("id", ti.getId()).attr("name", ti.getName());
		attr("class", ti, resultObject);

		if(!ti.getAttribute("visible", resultObject, true)) {
			attr("style", "display:none");
		}
		if(ti.getAttribute("disabled", resultObject, false)) {
			attr("disabled", "disabled");
		}
		attr("size", ti.get("size"));

		Object onchanged = ti.getAttribute("onchanged", resultObject);
		if(onchanged==null) {
			onchanged = ti.getAttribute("onchange", resultObject);
		}

		if(onchanged!=null) {
			attr("onchange", onchanged);
		}
		else {
			printRequest("request-onchanged", "onchange", ti, resultObject);
		}
		print(">");
	}
	
	/**
	 * option ^Ȍo͂sȂB
	 */
	@SuppressWarnings("unchecked")
	protected void writeOptionTags(TargetInfo ti, Object resultObject) {
		TargetInfoList children = ti.getChildren();
		
		if(children!=null) {
			for(int i=0; i < children.size(); i++) {
				TargetInfo child = children.get(i);

				print("<option");
				if(child.getAttribute("selected", resultObject, false)) {
					attr("selected", "selected");
				}
				// request-config  "value=" or "name=" or "id="  HTML  value= ݒ\B
				String value = child.get("value");
				if(value==null) {
					value = child.get("name");
				}
				if(value==null) {
					value = child.get("id");
				}
				// ȂΔzԍgpB
				if(value==null) {
					value = String.valueOf(i);
				}
				attr("value", value);
				print(">");
				format(child.get("label"));
				print("</option>");
			}
		}
		else {
			List list = (List)targetValue.getValue();
			for(int i=0; i < list.size(); i++) {
				print("<option");
				print(WriterUtil.toSelected(list, i));
				attr("value", String.valueOf(i));
				print(">");
				format(list.get(i), ti.get("format"));
				print("</option>");
			}
		}
	}

}
