/*
 * SQL.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */
package nga.sql;

import java.sql.Connection;

import nga.sql.impl.CallerImpl;
import nga.sql.impl.SelecterImpl;
import nga.sql.impl.UpdaterImpl;

/**
 * SQL IuWFNg쐬pt@NgNXB
 * {@link Selecter Selecter} IuWFNgyсC{@link Updater Updater} IuWFNg쐬B
 */
public abstract class SQL {
	
	/**
	 * SQL 쐬B
	 */
	private SQL() {
	}

	/**
	 * ftHgfobO[hB
	 */
	private static boolean debugMode;
	
	/**
	 * ftHg̃fobO[h𒲂ׂB
	 * @return fobO[hȂ trueBfobO[hłȂ falseB
	 */
	public static boolean getDefaultDebugMode() {
		return debugMode;
	}

	/**
	 * ftHg̃fobO[hݒ肷B
	 * @param mode fobO[hƂĐݒ肵ꍇ true w肷B
	 */
	public static void setDefaultDebugMode(boolean mode) {
		debugMode = mode;
	}
	
	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql) {
		Selecter<R> select = new SelecterImpl<R>(connection, resultClass, sql);
		select.setDebugMode(getDefaultDebugMode());
		return select;
	}

	/**
	 * Select p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param resultClass ʊi[IuWFNg̃NXB
	 * @param sql SQLB
	 * @param parameterObject Where ɖߍޒli[Ăp^IuWFNgB
	 * @return Select p SQL IuWFNgB
	 */
	public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql, Object... parameterObject) {
		Selecter<R> select = new SelecterImpl<R>(connection, resultClass, sql, parameterObject);
		select.setDebugMode(getDefaultDebugMode());
		return select;
	}

	/**
	 * Update / Insert / Delete p SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sql SQLB
	 * @return Update / Insert / Delete p SQL IuWFNgB
	 */
	public static  Updater createUpdater(Connection connection, String sql) {
		Updater update = new UpdaterImpl(connection, sql);
		update.setDebugMode(getDefaultDebugMode());
		return update;
	}

	/**
	 * XgAhvV[W / XgAht@NVp SQL IuWFNg쐬B
	 * @param connection f[^x[XRlNVB
	 * @param sql SQLB
	 * @return XgAhvV[W / XgAht@NVp  SQL IuWFNgB
	 */
	public static Caller createCaller(Connection connection, String sql) {
		Caller caller = new CallerImpl(connection, sql);
		caller.setDebugMode(getDefaultDebugMode());
		return caller;
	}

}
