/*
 *TextWalker.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.util;


/**
 * CSV vpeBt@Ciinit@Cj`̃eLXgȒPɕ邽߂
 * [eBeBB<br>
 * <br>
 * <b>gpPFvpeBt@C`</b>
 * <pre class=java>
 *  // ͂eLXgɂTextWalker 쐬B
 *  TextWalker file = new TextWalker(text);
 * 
 *  while(file.isWalking()){ 
 *    // PsǂݍށB
 *    TextWalker line = file.getLine();
 * 
 *    // L[ivpeBjoB
 *    String key = line.getString('=');
 * 
 *    // loB
 *    String value = line.getString();
 * 
 *    System.out.println("["+key+"]:"+"["+value+"]");
 *  }</pre>
 * 
 * Ⴆ΁C̃vO text ϐɈȉ̂悤ȕi[Ă
 * sƁC
 * <pre class=text>
 * abc = 
 * def =
 * ghi=</pre>
 * ̂悤ɕ\B
 * <pre class=console>
 * [abc]:[]
 * [def]:[]
 * [ghi]:[]</pre>
 *
 * <br><br>
 *
 * <b>gpQFCSV</b>
 * <pre class=java>
 *  // ͂eLXgɂTextWalker 쐬B
 *  TextWalker file = new TextWalker(text);
 *  file.setCommentSkip(false);
 *  file.setSpaceSkip(false);
 * 
 *  while(file.isWalking()){ 
 *    // PsǂݍށB
 *    TextWalker line = file.getLine();
 *    while(line.isWalking()){
 *      // "," ܂ł̕oB
 *      String column = line.getString(',');
 * 
 *      // o^uŋ؂ĕ\B
 *      System.out.print(column);
 *      System.out.print("\t");
 *    }
 *  System.out.println();
 *  }</pre>
 * 
 * Ⴆ΁C̃vO text ϐɈȉ̂悤ȕi[Ă
 * sƁC
 * <pre class=text>
 * abc,defg,hij,klm
 * ,,,</pre>
 * ̂悤ɕ\B
 * <pre class=console>
 * abc    defg    hij    klm
 *       </pre>
 */
public class TextWalker {

	/**
	 * ͑ΏۂƂeLXgB
	 */
	private String text;
	
	/**
	 * ͊JnʒuB
	 */
	private int offset;
	
	/**
	 * ͏IʒuB
	 */
	private int count;
	
	/**
	 * ݈ʒuB
	 */
	private int index;
	
	/**
	 * 󔒂XLbv邩ǂB
	 */
	private boolean spaceSkip = true;
	
	/**
	 * RgXLbv邩ǂB
	 */
	private boolean commentSkip = true;
	
	/**
	 * RgJn\B
	 */
	private char commentChar = '#';
	
	/**
	 * GXP[vB
	 */
	private char escapeChar;
	
	/**
	 * ̋؂\B
	 */
	private char[] wordSeparators = {
		'!','\"','#','$','%','&','\'','(',')','*','+',',','-',
		'.','/',':',';','<','=','>','?','@','[','\\',']','^',
		'`','{','|','}','~'
	};
	
	/**
	 *  TextWalker ̎qB
	 */
	private TextWalker child;
	
	
	/**
	 * }[Nꂽʒu
	 */
	private int marked;



	/**
	 * TextWalker 쐬B
	 * @param str ͑ΏۂƂeLXgB
	 */
	public TextWalker(String str) {
		if(str==null) {
			throw new NullPointerException();
		}
	
		text = str;
		count = text.length();
	}

	/**
	 * @see #getTextWalker(int,int)
	 */
	private TextWalker(){
	}

	/**
	 * ̃eLXg̈؂oāCTextWalker 쐬B
	 */
	private TextWalker getTextWalker(int start, int end) {
		if(child==null) {
			child = new TextWalker();
			child.text = text;
			child.spaceSkip = spaceSkip;
			child.commentSkip = commentSkip;
			child.commentChar = commentChar;
			child.escapeChar = escapeChar;
			child.wordSeparators = wordSeparators;
		}
	
		child.offset = start;
		child.index = start;
	
		child.count = getEnd(start, end);
	
		return child;
	}

	private int getEnd(int start, int end) {
		if(spaceSkip) {
			while((start<end) && (isSpace(text.charAt(end-1))))
				end--;
			}
		return end;
	}


	/**
	 * GXP[vLݒ肷B<br>
	 * Ⴆ΁C"\" GXP[vLƂĐݒ肵C"abc,abc\,de,abc"
	 * ƂnĈȉ̃vOsꍇC"abc|abc,de|abc|"
	 * \B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("abc,abc\\,de,abc");
	 * tw.setEscapeChar('\\');
	 * while(tw.isWalking()){
	 *   System.out.println(tw.getString(',')+"|");
	 * }
	 * System.out.println();</pre>
	 * @param c GXP[vLB
	 * @see #getEscapeChar
	 */
	public void setEscapeChar(char c) {
		escapeChar = c;
		if(child!=null) {
			child.setEscapeChar(c);
		}
	}


	/**
	 * ݃ZbgĂGXP[vL擾B
	 * @return GXP[vLB
	 * @see #setEscapeChar
	 */
	public final char getEscapeChar() {
		return escapeChar;
	}


	/**
	 * ؂蕶̑Oɂ󔒕XLbv邩ǂݒ肷B<br>
	 * ftHg true ݒ肳ĂB<br>
	 * Ⴆ΁Cȉ̃vOsƁC"a,b,c,d," ƕ\C
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("a , b , c,  d");
	 * while(tw.isWalking()){
	 *   System.out.println(tw.getString(',')+",");
	 * }
	 * System.out.println();</pre>
	 * ̃vOł́C"a , b , c,  d," ƕ\B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("a , b , c,  d");
	 * tw.setSpaceSkip(false);
	 * while(tw.isWalking()){
	 *   System.out.println(tw.getString(',')+",");
	 * }
	 * System.out.println();</pre>
	 * ̎ł́C'\u0020' ȉ̃R[hɊ蓖Ăꂽ
	 * 󔒕ƂĈB
	 * @param b XLbvꍇ true w肷B
	 * @see #isSpaceSkip
	 */
	public void setSpaceSkip(boolean b) {
		spaceSkip = b;
		if(child!=null) {
			child.setSpaceSkip(b);
		}
	}

	/**
	 * 󔒕XLbvݒɂȂĂ邩ǂ𒲂ׂB<br>
	 * @return 󔒕XLbvݒɂȂĂ trueB
	 *         ftHg true ݒ肳ĂB
	 * @see #setSpaceSkip
	 */
	public final boolean isSpaceSkip() {
		return spaceSkip;
	}


	/**
	 * RgXLbv邩ǂݒ肷B<br>
	 * RgXLbvݒɂĂꍇCȉ̓B<br>
	 * <ul>
	 * <li>sRgn܂ꍇC̍ŝ𖳎B
	 * <li>s̓rRgn܂ꍇCRgsLO܂ł
	 *  𖳎B
	 * </ul>
	 * ftHg true ݒ肳ĂB<br>
	 * RgJnL {@link #setCommentChar} \bhŎw肷B
	 * @param b XLbvꍇ true w肷B
	 * @see #setCommentChar
	 * @see #isCommentSkip
	 */
	public void setCommentSkip(boolean b) {
		commentSkip = b;
		if(child!=null) {
			child.setCommentSkip(b);
		}
	}

	/**
	 * RgXLbvݒɂȂĂ邩ǂ𒲂ׂB<br>
	 * ftHg true ݒ肳ĂB
	 * @return RgXLbvݒɂȂĂ trueB
	 * @see #setCommentSkip
	 */
	public final boolean isCommentSkip() {
		return commentSkip;
	}
	
	/**
	 * Rgsw肷B<br>
	 * ftHg '#' ݒ肳ĂB
	 * @param c RgsB
	 * @see #setCommentSkip
	 * @see #getCommentChar
	 */
	public void setCommentChar(char c) {
		commentChar = c;
		if(child!=null) {
			child.setCommentChar(c);
		}
	}

	/**
	 * Rgs擾B<br>
	 * ftHg '#' ݒ肳ĂB
	 * @return RgsB
	 * @see #setCommentChar
	 */
	public final char getCommentChar() {
		return commentChar;
	}



	/**
	 * getWord \bhŌ̋؂蕶ƂĈZbgB<br>
	 * ftHgł́C"_" ȊŐL蓖ĂĂB<br>
	 * ȂCŎw肵Ƃ͕ʂɋ󔒁i'\u0020' ȉ̃R[hɊ蓖
	 * Ăꂽj͕K؂蕶ƂĈB
	 * @param separators ؂蕶B
	 * @see #getWord
	 * @see #getWordSeparators
	 */
	public void setWordSeparators(char[] separators) {
		wordSeparators = separators;
		if(child!=null) {
			child.setWordSeparators(separators);
		}
	}

	/**
	 * getWord \bhŌ̋؂蕶ƂĈ擾B
	 * @return ؂蕶B
	 * @see #getWord
	 * @see #setWordSeparators
	 */
	public char[] getWordSeparators() {
		return wordSeparators;
	}



	/**
	 * ͑ΏۃeLXg̏I[ɓBǂ𒲂ׂB
	 * @return I[ɓBĂꍇ falseB
	 */
	public final boolean isWalking() {
		return index<count;
	}


	/**
	 * ݈ʒu擾B
	 * @return ݈ʒuB
	 */
	public final int getCurrentIndex() {
		return index-offset;
	}

	/**
	 * w肵݈ʒuړB
	 * @param count ړ镶B
	 */
	public final void moveCurrentIndex(int count){
		int newIndex = index + count;
		if(newIndex>this.count || newIndex<offset)
			return;
		index = newIndex;
	}


	/**
	 * ݈ʒu̕擾B
	 * @return ݈ʒuɂ镶B݈ʒuI[ɒBĂꍇ -1B
	 */
	public final char getCurrentChar() {
		return (index<count)?text.charAt(index):(char)-1;
	}

	/**
	 * ݈ʒu + num ̈ʒuɂ镶擾B<br>
	 * ݈ʒu͈ړȂB
	 * @return ݈ʒu + num ̈ʒuɂ镶B
	 *         w肵ʒu̕擾łȂꍇ -1B
	 */
	public final char getChar(int i)	{
		i += index;
		return (i<0 || i>=text.length())?(char)-1:text.charAt(i);
	}

	/**
	 * ݈ʒuȍ~̍̕ŏw肵ƈvĂ邩ǂ𒲂ׂB
	 * @param s r镶B
	 * @return vĂꍇ trueB
	 */
	public boolean startsWith(String s) {
		return text.startsWith(s,index);
	}

	/**
	 * ݈ʒu̕w肵ƈvĂ邩ǂ𒲂ׂB
	 * @param c r镶B
	 * @return vĂꍇ trueB
	 */
	public boolean startsWith(char c) {
		return text.charAt(index)==c;
	}

	/**
	 * TΏە̐擪w肵ƈvĂꍇCw肵擪
	 * 폜B
	 * @param s r镶B
	 */
	public void trimHead(String s) {
		if(startsWith(s)) {
			index = index+s.length();
			skip();
		}
	}

	/**
	 * TΏە̐擪w肵ƈvĂꍇCw肵擪
	 * 폜B
	 * @param c r镶B
	 */
	public void trimHead(char c) {
		if(startsWith(c)) {
			index = index+1;
			skip();
		}
	}

	/**
	 * TΏە̖w肵ƈvĂ邩ǂ𒲂ׂB
	 * @param s r镶B
	 * @return vĂꍇ trueB
	 */
	public boolean endsWith(String s) {
		return text.startsWith(s, count - s.length());
	}

	/**
	 * TΏە̖w肵ƈvĂ邩ǂ𒲂ׂB
	 * @param c r镶B
	 * @return vĂꍇ trueB
	 */
	public boolean endsWith(char c) {
		return text.charAt(count-1)==c;
	}

	/**
	 * TΏە̖w肵ƈvĂꍇCw肵
	 * 폜B
	 * @param s r镶B
	 */
	public void trimTail(String s) {
		if(endsWith(s)) {
			count = getEnd(index, count-s.length());
		}
	}

	/**
	 * TΏە̖w肵ƈvĂꍇCw肵
	 * 폜B
	 * @param c r镶B
	 */
	public void trimTail(char c) {
		if(endsWith(c)) {
			count = getEnd(index, count-1);
		}
	}



	/**
	 *  TextWalker ͑ΏۂƂĂeLXg擾B
	 * @return ͑Ώۂ̃eLXgB
	 */
	public final String getText() {
		return text.substring(offset,count);
	}



	/**
	 *  TextWalker ͑ΏۂƂĂeLXg̕擾B
	 * @return ͑ΏۃeLXg̕B
	 */
	public final int length() {
		return (count>offset)? (count - offset) : 0;
	}


	/**
	 * w肵B
	 * @param ch  
	 * @param i   Jnʒu
	 * @param max Iʒu
	 * @return w肵̃CfbNXB
	 * w肵݂Ȃꍇ -1B
	 */
	private int indexOf(int ch, int i, int max) {
		String text = this.text;
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) {
				i = processEscape(i,max);
			}
			else if(c==ch) {
				return i;
			}
		}
	
		return -1;
	}

	/**
	 * w肵B
	 * @param ch  
	 * @param i   Jnʒu
	 * @param max Iʒu
	 * @return w肵̃CfbNXB
	 * w肵݂Ȃꍇ -1B
	 */
	private int indexOf(char[] ch, int i, int max) {
		String text = this.text;
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) {
				i = processEscape(i,max);
			}
			else {
				for(int j=0; j<ch.length; j++) {
					if(c==ch[j]) {
						return i;
					}
				}
			}
		}
	
		return -1;
	}


	/**
	 * @param c1  
	 * @param c2  
	 * @param i   Jnʒu
	 * @param max Iʒu
	 * @return w肵̃CfbNXBw肵݂Ȃꍇ -1B
	 */
	private int indexOf(int c1, int c2, int i, int max) {
		String text = this.text;
		int cnt = 0;
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) {
				i = processEscape(i,max);
			}
			else if(c==c1) {
				cnt++;
			}
			else if(c==c2) {
				if(cnt==0) {
					return i;
				}
				else {
					cnt--;
				}
			}
		}
	
		return -1;
	}



	/**
	 * s̃CfbNX擾B
	 * @param i   Jnʒu
	 * @param max Iʒu
	 * @return s̃CfbNXBw肵݂Ȃꍇ -1B
	 */
	private int indexOfEndOfLine(int i, int max) {
		String text = this.text;
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) {
				i = processEscape(i,max);
			}
			else if(c=='\r' || c=='\n') {
				return i;
			}
		}
		return -1;
	}


	/**
	 * w肵̃CfbNX擾B
	 * @param s1  Jn
	 * @param s2  I
	 * @param i  Jnʒu
	 * @param ed  Iʒu
	 * @return CfbNXBw肳ꂽ񂪂݂Ȃꍇ -1B
	 */
	private int indexOf(String s1, String s2, int i, int ed) {
		String text = this.text;
		if(i>=ed) {
		    return -1;
		}
	
		int cnt = 0;
	
		int len1 = s1.length();
		int len = s2.length();
		if(len==0) {
			return 0;
		}
	
	    int max = ed - len;
	
		char first1  = s1.charAt(0);
		char first2  = s2.charAt(0);
	
		startSearchForFirstChar:
		while(true) {
			while(i<=max) {
				char c = text.charAt(i);
	
				if(c==escapeChar) {// GXP[v͓̎̎ǂݔ΂
					i = processEscape(i,max);
				}
				else {
					if(c==first1) {
						if(text.regionMatches(i,s1,0,len1)) {
							cnt++;
							i += len1;
							continue;
						}
					}
	
					if(c==first2) {
						break;
					}
				}
	
				i++;
			}
	
			if(i>max) {
				return -1;
			}
	
			int j = i + 1;
			int end = j + len - 1;
			int k = 1;
	
			while(j<end) {
				if(text.charAt(j++)!=s2.charAt(k++)) {
					i++;
					continue startSearchForFirstChar;
				}
			}
	
			if(cnt==0) {
				return i;
			}
			else {
				cnt--;
				i++;
			}
		}
	}



	/**
	 * w肵̃CfbNX擾B
	 * @param s2  
	 * @param i  Jnʒu
	 * @param ed  Iʒu
	 * @return CfbNXBw肳ꂽ񂪂݂Ȃꍇ -1B
	 */
	private int indexOf(String s2, int i, int ed) {
		String text = this.text;
		if(i>=ed) {
		    return -1;
		}
	
		int len = s2.length();
		if(len==0) {
			return 0;
		}
	
	    int max = ed - len;
	
		char first  = s2.charAt(0);
	
		startSearchForFirstChar:
		while(true) {
			for(;i<=max;i++) {
				char c = text.charAt(i);
				if(c==escapeChar) { // GXP[v͓̎̎ǂݔ΂
					i = processEscape(i,max);
				}
				else if(c==first) {
					break;
				}
			}
	
			if(i>max) {
				return -1;
			}
	
			int j = i + 1;
			int end = j + len - 1;
			int k = 1;
	
			while(j<end) {
				if(text.charAt(j++)!=s2.charAt(k++)) {
					i++;
					continue startSearchForFirstChar;
				}
			}
	
			return i;
		}
	}



	/**
	 * Q̊̕Ԃɂ镶ɑΉ TextWalker 擾B<br>
	 * ݈ʒúCc2 ̎̕ɈړB<br>
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab{cde}fg");
	 * System.out.println(tw.between('{','}').getText());</pre>
	 * ̃vOsƁCR\[ɂ "cde" \B<br>
	 * ܂Ĉ悤Ɏw肵qɂȂĂꍇ́CO̕
	 * ɂ镶񂪎擾B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab{cde{fg}hi}jk");
	 * System.out.println(tw.between('{','}').getText());</pre>
	 * L̃vOsƁC"cde{fg}hi" \B
	 * 
	 * @param c1 擾JnB
	 * @param c2 擾IB
	 * @return c1  c2 ̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ̕ɂ c1  c2 ̂͊܂܂ȂB
	 *         ܂Cc1  c2 Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #betweenString(char,char)
	 */
	public TextWalker between(char c1, char c2) {
		int max = count;
		int start = indexOf(c1,index,max)+1;
		if(start==0)return null;
	
		start = skip(start,max);
	
		int end;
		if(c1!=c2) {
			end = indexOf(c1, c2,start,max);
		}
		else {
			end = indexOf(c2,start,max);
		}
	
		if(end==-1) {
			return null;
		}
	
		index = skip(end + 1,max);
	
		return getTextWalker(start,end);
	}


	/**
	 * Q̊̕Ԃɂ镶ɑΉ TextWalker 擾B<br>
	 * ݈ʒúCs2 ̎̕ɈړB<br>
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab<-cde->fg");
	 * System.out.println(tw.between("<-","->").getText());</pre>
	 * ̃vOsƁCR\[ɂ "cde" \B<br>
	 * ܂Ĉ悤Ɏw肵񂪓qɂȂĂꍇ́CO̕
	 * ɂ镶񂪎擾B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab<-cde<-fg->hi->jk");
	 * System.out.println(tw.between("<-","->").getText());</pre>
	 * L̃vOsƁC"cde<-fg->hi" \B
	 * @param s1 擾JnB
	 * @param s2 擾IB
	 * @return s1  s2 ̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ̕ɂ s1  s2 ̂͊܂܂ȂB
	 *         ܂Cs1  s2 Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #betweenString(String,String)
	 */
	public TextWalker between(String s1, String s2) {
		int max = count;
		int start = indexOf(s1,index,max);
		if(start==-1) {
			return null;
		}
		else {
			start = start + s1.length();
		}
	
		start = skip(start,max);
	
		int end;
		if(!s1.equals(s2)) {
			end = indexOf(s1, s2,start,max);
		}
		else {
			end = indexOf(s2,start,max);
		}
	
		if(end==-1) {
			return null;
		}
	
		index = skip(end + s2.length(),max);
	
		return getTextWalker(start,end);
	}


	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param c 镶B
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #searchString(char)
	 * @see #get(char)
	 */
	public TextWalker search(char c) {
		return search(c, true);
	}

	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * w肵Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param c 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #searchString(char, boolean)
	 * @see #get(char, boolean)
	 */
	public TextWalker search(char c, boolean next) {
		return move(c, false, next);
	}
	
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵񂪌Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param s 镶B
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #searchString(String)
	 * @see #get(String)
	 */
	public TextWalker search(String s) {
		return search(s, true);
	}

	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * w肵񂪌Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param s 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #searchString(String,boolean)
	 * @see #get(String,boolean)
	 */
	public TextWalker search(String s, boolean next) {
		return move(s, false, next);
	}


	/**
	 * ݈ʒuȍ~ɂSĂ̕ɑΉ TextWalker 擾B<br>
	 * ݈ʒúCŌ̕Ɉړi܂C{@link #isWalking} \bh
	 * false Ԃ悤ɂȂjB
	 * @return ݈ʒuȍ~ɂ镶ɑΉ TextWalkerB
	 *         ̕ɂ݈͌ʒuɂ镶܂܂B
	 * @see #getString()
	 */
	public TextWalker get() {
		int start = skip(index,count);
	
		index = count;
	
		return getTextWalker(start,count);
	}



	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵Ȃꍇ́C{@link #get()} \bh
	 * sƂƓB
	 * @param c 镶B
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ́C{@link #get()} \bhs
	 *         ƂƓB
	 * @see #getString(char)
	 * @see #get()
	 * @see #search(char)
	 */
	public TextWalker get(char c) {
		return get(c, true);
	}
	
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * w肵Ȃꍇ́C{@link #get()} \bh
	 * sƂƓB
	 * @param c 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ́C{@link #get()} \bhs
	 *         ƂƓB
	 * @see #getString(char,boolean)
	 * @see #get()
	 * @see #search(char,boolean)
	 */
	public TextWalker get(char c, boolean next) {
		return move(c, true, next);
	}
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵񂪌Ȃꍇ́C{@link #get()} \bh
	 * sƂƓB
	 * @param s 镶B
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ́C{@link #get()} \bhs
	 *         ƂƓB
	 * @see #getString(String)
	 * @see #get()
	 * @see #search(String)
	 */
	public TextWalker get(String s) {
		return get(s, true);
	}

	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * Ή TextWalker 擾B<br>
	 * w肵񂪌Ȃꍇ́C{@link #get()} \bh
	 * sƂƓB
	 * @param s 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶ɑΉ TextWalkerB
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ́C{@link #get()} \bhs
	 *         ƂƓB
	 * @see #getString(String,boolean)
	 * @see #get()
	 * @see #search(String,boolean)
	 */
	public TextWalker get(String s, boolean next) {
		return move(s, true, next);
	}


	/**
	 * ݈ʒus܂ł̊Ԃɂ镶ɑΉ TextWalker 擾B<br>
	 * ݈ʒúCs̍ŏ̕ɈړB
	 * @return ݈ʒus܂ł̕ɑΉ TextWalkerB
	 *         ݈ʒu܂݁Cs͊܂܂ȂB
	 * @see #getLineString
	 */
	public TextWalker getLine() {
		String text = this.text;
		int max = count;
		int start = skip(index,max);
		int end = indexOfEndOfLine(start,max);
	
		if(end==-1) {
			index = max;
			return getTextWalker(start,max);
		}
	
		if(end+1<max && text.charAt(end)=='\r' && text.charAt(end+1)=='\n') {
			index = skip(end + 2,max);
		}
		else {
			index = skip(end + 1,max);
		}
	
		return getTextWalker(start,end);
	}


	/**
	 * ݈ʒuw肵̊Ԃɂ镶ɑΉ TextWalker 擾B
	 * <br>
	 * next  true ̏ꍇC݈ʒu͎w肵̎̕ɈړB
	 * false ̏ꍇCw肵ɈړB
	 * @param c 镶B
	 * @param all w肵ȂꍇC̍Ō܂ł擾B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒuw肵܂ł̕ɑΉ TextWalkerB
	 *         ݈ʒu܂ݎw肵͊܂܂ȂB
	 *         all  false Ɏw肵ĂāCw肳ꂽ݂Ȃꍇ
	 *         nullB̏ꍇ݈ʒu͍XVȂB
	 */
	private TextWalker move(char c, boolean all, boolean next) {
		int max = count;
		int start = skip(index, max);
		int end = indexOf(c, start, max);
	
		if(end==-1) {
			if(all) {
				index = max;
				return getTextWalker(start, max);
			}
			else {
				return null;
			}
		}
	
		if(next) {
			index = skip(end+1, max);
		}
		else {
			index = end;
		}
	
		return getTextWalker(start, end);
	}


	/**
	 * ݈ʒuw肵̊Ԃɂ镶ɑΉ TextWalker 擾B
	 * @param s   镶B
	 * @param all w肵񂪌ȂꍇC̍Ō܂ł擾B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒuw肵܂ł̕ɑΉ TextWalkerB
	 *         ݈ʒu܂ݎw肵͊܂܂ȂB
	 *         all  false Ɏw肵ĂāCw肳ꂽ݂Ȃꍇ
	 *         nullB̏ꍇ݈ʒu͍XVȂB
	 */
	private TextWalker move(String s, boolean all, boolean next) {
		int max = count;
		int start = skip(index,max);
		int end = indexOf(s,start,max);
	
		if(end==-1) {
			if(all) {
				index = max;
				return getTextWalker(start,max);
			}
			else {
				return null;
			}
		}
	
		if(next) {
			index = skip(end + s.length(), max);
		}
		else {
			index = end;
		}
	
		return getTextWalker(start,end);
	}

	/**
	 * w肵̒ŁC݈ʒuȍ~ōŏɌ镶擾B
	 * ݈ʒúC݂ɈړB
	 * @param c 镶B
	 * @return B
	 */
	public char which(char[] c) {
		int max = count;
		int start = skip(index,max);
		int end = indexOf(c,start,max);
	
		if(end==-1) {
			return (char)-1;
		}
	
		index = skip(end, max);
	
		return getCurrentChar();
	}




	/**
	 * Q̊̕Ԃɂ镶擾B<br>
	 * ݈ʒúCc2 ̎̕ɈړB<br>
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab{cde}fg");
	 * System.out.println(tw.betweenString('{','}'));</pre>
	 * ̃vOsƁCR\[ɂ "cde" \B<br>
	 * ܂Ĉ悤Ɏw肵qɂȂĂꍇ́CO̕
	 * ɂ镶񂪎擾B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab{cde{fg}hi}jk");
	 * System.out.println(tw.betweenString('{','}'));</pre>
	 * L̃vOsƁC"cde{fg}hi" \B
	 * 
	 * @param c1 擾JnB
	 * @param c2 擾IB
	 * @return c1  c2 ̊Ԃɂ镶B
	 *         ̕ɂ c1  c2 ̂͊܂܂ȂB
	 *         ܂Cc1  c2 Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #between(char,char)
	 */
	public String betweenString(char c1, char c2) {
		int start = indexOf(c1,index,count)+1;
		if(start==0) {
			return null;
		}
		if(c1!=c2) {
			return nextString(start,c1, c2,false);
		}
		else {
			return move(start, c2, false, true);
		}
	}

	private boolean isSpace(char c) {
		return c<=' ';
	}



	/**
	 * st  c2 ̊Ԃɂ镶擾B
	 * @param i JnʒuB
	 * @param c2 B
	 * @param all Ȃꍇɂ܂Ŏ擾ԂB
	 */
	private String nextString(int i, char c1, char c2, boolean all) {
		String text = this.text;
		int max = count;
	
		// 擪̋󔒕ǂ݂Ƃ΂B
		i = skip(i,max);
	
		// ǂݍ
		StringBuffer sb = new StringBuffer((max>i)?max-i:2);
	
		int cnt = 0;
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) { // GXP[v͓̎̎ǂݔ΂
				if(++i<max) {
					sb.append(text.charAt(i));
				}
				if(text.charAt(i)=='\r' && i+1<max && text.charAt(i+1)=='\n') {
					sb.append(text.charAt(++i));
				}
			}
			else if(commentSkip && c==commentChar) {
				boolean r = true;
				if(i>0 && (text.charAt(i-1)=='\r' || text.charAt(i-1)=='\n')) {
					r = false;
				}
	
				while(++i<max && text.charAt(i)!='\n' && text.charAt(i)!='\r');
				if(r && i<max) {
					sb.append(text.charAt(i));
				}
				if(i+1<max && text.charAt(i)=='\r' && text.charAt(i+1)=='\n') {
					i++;
					if(r) {
						sb.append(text.charAt(i));
					}
				}
			}
			else if(c==c1) {
				cnt++;
				sb.append(c1);
			}
			else if(c==c2) {
				if(cnt==0) {
					break;
				}
				else {
					cnt--;
					sb.append(c2);
				}
			}
			else {
				sb.append(c);
			}
		}
	
	
		if(i<max) {
			index = skip(i+1,count);
		}
		else if(all) {
			index = max;
		}
		else {
			return null;
		}
	
		return newString(sb);
	}




	/**
	 * st  c2 ̊Ԃɂ镶擾B
	 * @param i JnʒuB
	 * @param c2 B
	 * @param all Ȃꍇɂ܂Ŏ擾ԂB
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 */
	private String move(int i, char c2, boolean all, boolean next)
		{
		String text = this.text;
		int max = count;
	
		if(!commentSkip && escapeChar==0) {
			int end = indexOf(c2,i,max);
			if(end==-1) {
				if(all) {
					end = max;
					index = end;
				}
				else {
					return null;
				}
			}
			else {
				if(next) {
					index = skip(end+1, max);
				}
				else {
					index = end;
				}
			}
	
			if(spaceSkip) {
				return text.substring(i,end).trim();
			}
			else {
				return text.substring(i,end);
			}
		}
	
	
		// 擪̋󔒕ǂ݂Ƃ΂B
		i = skip(i,max);
	
		// ǂݍ
		StringBuffer sb = new StringBuffer((max>i)?max-i:2);
	
		for(;i<max;i++) {
			char c = text.charAt(i);
			if(c==escapeChar) { // GXP[v͓̎̎ǂݔ΂
				if(++i<max) {
					sb.append(text.charAt(i));
				}
				if(text.charAt(i)=='\r' && i+1<max && text.charAt(i+1)=='\n') {
					sb.append(text.charAt(++i));
				}
			}
			else if(commentSkip && c==commentChar) {
				boolean r = true;
				if(i>0 && (text.charAt(i-1)=='\r' || text.charAt(i-1)=='\n')) {
					r = false;
				}
	
				while(++i<max && text.charAt(i)!='\n' && text.charAt(i)!='\r');
				if(r && i<max) {
					sb.append(text.charAt(i));
				}
				if(i+1<max && text.charAt(i)=='\r' && text.charAt(i+1)=='\n') {
					i++;
					if(r) {
						sb.append(text.charAt(i));
					}
				}
			}
			else if(c==c2) {
				break;
			}
			else {
				sb.append(c);
			}
		}
	
	
		if(i<max) {
			if(next) {
				index = skip(i+1, max);
			}
			else {
				index = i;
			}
		}
		else if(all) {
			index = max;
		}
		else {
			return null;
		}
	
		return newString(sb);
	}


	/**
	 * Q̊̕Ԃɂ镶擾B<br>
	 * ݈ʒúCs2 ̎̕ɈړB<br>
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab<-cde->fg");
	 * System.out.println(tw.betweenString("<-","->"));</pre>
	 * ̃vOsƁCR\[ɂ "cde" \B<br>
	 * ܂Ĉ悤Ɏw肵񂪓qɂȂĂꍇ́CO̕
	 * ɂ镶񂪎擾B
	 * <pre class=java>
	 * TextWalker tw = new TextWalker("ab<-cde<-fg->hi->jk");
	 * System.out.println(tw.between("<-","->").getText());</pre>
	 * L̃vOsƁC"cde<-fg->hi" \B
	 * @param s1 擾JnB
	 * @param s2 擾IB
	 * @return s1  s2 ̊Ԃɂ镶B
	 *         ̕ɂ s1  s2 ̂͊܂܂ȂB
	 *         ܂Cs1  s2 Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #between(String,String)
	 */
	public String betweenString(String s1, String s2) {
		TextWalker tw = between(s1,s2);
		if(tw==null) {
			return null;
		}
		else {
			return tw.getString();
		}
	}



	/**
	 * i N_Ƃ s2 ܂łɂ镶擾B
	 * @param i  JnʒuB
	 * @param s2 B
	 * @param all Ȃꍇɂ܂Ŏ擾ԂB
	 */
	private String move(int i, String s2, boolean all, boolean next) {
		String text = this.text;
		if(!commentSkip && escapeChar==0) {
			int end = indexOf(s2,i,count);
	
			if(end==-1) {
				if(all) {
					end = count;
					index = end;
				}
				else {
					return null;
				}
			}
			else {
				if(next) {
					index = skip(end + s2.length(),count);
				}
				else {
					index = end;
				}
			}
	
			if(spaceSkip) {
				return text.substring(i,end).trim();
			}
			else {
				return text.substring(i,end);
			}
		}
	
	
		int len = s2.length();
		if(len==0) {
			return s2;
		}
	
	    int max = count - len;
	
	
		// 擪̋󔒕ǂ݂Ƃ΂B
		i = skip(i,max);
	
		// ǂݍށB
		char first  = s2.charAt(0);
	
		StringBuffer sb = new StringBuffer((max>i)?max-i:2);
	
		startSearchForFirstChar:
		while(true) {
			for(;i<=max;i++) {
				char c = text.charAt(i);
				if(c==escapeChar) { // GXP[v͓̎̎ǂݔ΂
					if(++i<max) {
						sb.append(text.charAt(i));
					}
					if(text.charAt(i)=='\r' && i+1<max && text.charAt(i+1)=='\n') {
						sb.append(text.charAt(++i));
					}
				}
				else if(commentSkip && c==commentChar) {
					boolean r = true;
					if(i>0 && (text.charAt(i-1)=='\r' || text.charAt(i-1)=='\n'))
						r = false;
	
					while(++i<max && text.charAt(i)!='\n' && text.charAt(i)!='\r');
					if(r && i<max) {
						sb.append(text.charAt(i));
					}
					if(i+1<max && text.charAt(i)=='\r' && text.charAt(i+1)=='\n') {
						i++;
						if(r) {
							sb.append(text.charAt(i));
						}
					}
				}
				else if(c==first) {
					break;
				}
				else {
					sb.append(c);
				}
			}
	
			if(i>max) {
				if(all) {
					index = count;
					sb.append(text.substring(i,index));
					return newString(sb);
				}
				else {
					return null;
				}
			}
	
	
			int j = i + 1;
			int end = j + len - 1;
			int k = 1;
	
			while(j<end) {
				if(text.charAt(j++)!=s2.charAt(k++)) {
					i++;
					sb.append(s2.substring(0,k-1));
					continue startSearchForFirstChar;
				}
			}
	
			if(next) {
				index = skip(end, count);
			}
			else {
				index = end - len;
			}
	
			return newString(sb);
		}
	}



	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param c 镶B
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #search(char)
	 * @see #getString(char)
	 */
	public String searchString(char c) {
		return searchString(c, true);
	}
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * w肵Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param c 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #search(char,boolean)
	 * @see #getString(char,boolean)
	 */
	public String searchString(char c, boolean next) {
		return move(index, c, false, next);
	}
	
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵񂪌Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param s 镶B
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #search(String)
	 * @see #getString(String)
	 */
	public String searchString(String s) {
		return searchString(s, true);
	}
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵񂪌Ȃꍇ null ԂC݈ʒu
	 * ړȂB
	 * @param s 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ null ԂB
	 *         ̏ꍇC݈ʒu͍XVȂB
	 * @see #search(String,boolean)
	 * @see #getString(String,boolean)
	 */
	public String searchString(String s, boolean next) {
		return move(index, s, false, next);
	}
	
	
	
	/**
	 * ݈ʒuȍ~ɂSĂ̕擾B<br>
	 * ݈ʒúCŌ̕Ɉړi܂C{@link #isWalking} \bh
	 * false Ԃ悤ɂȂjB
	 * @return ݈ʒuȍ~ɂSĂ̕B
	 *         ̕ɂ݈͌ʒuɂ镶܂܂B
	 * @see #get()
	 */
	public String getString() {
		return move(index, (char)-1, true, true);
	}
	
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵Ȃꍇ́C{@link #getString()} \bh
	 * sƂƓB
	 * @param c 镶B
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ́C{@link #getString()} \bhs
	 *         ƂƓB
	 * @see #get(char)
	 * @see #getString()
	 * @see #searchString(char)
	 */
	public String getString(char c) {
		return getString(c, true);
	}
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * w肵Ȃꍇ́C{@link #getString()} \bh
	 * sƂƓB
	 * @param c 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu c ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ c ܂܂ȂB
	 *         c Ȃꍇ́C{@link #getString()} \bhs
	 *         ƂƓB
	 * @see #get(char,boolean)
	 * @see #getString()
	 * @see #searchString(char,boolean)
	 */
	public String getString(char c, boolean next) {
		return move(index, c, true, next);
	}
	
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * ݈ʒúCw肵̎̕ɈړB<br>
	 * w肵񂪌Ȃꍇ́C{@link #getString()} \bh
	 * sƂƓB
	 * @param s 镶B
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ́C{@link #getString()} \bhs
	 *         ƂƓB
	 * @see #get(String)
	 * @see #getString()
	 * @see #searchString(String)
	 */
	public String getString(String s) {
		return getString(s, true);
	}
	
	/**
	 * w肵C݈ʒuw肵̊Ԃɂ镶
	 * 擾B<br>
	 * w肵񂪌Ȃꍇ́C{@link #getString()} \bh
	 * sƂƓB
	 * @param s 镶B
	 * @param next true ̏ꍇ́C݈ʒuw肵̎ɈړB
	 * @return ݈ʒu s ܂ł̊Ԃɂ镶B
	 *         ݈͌̕ʒuɂ镶܂ s ܂܂ȂB
	 *         s Ȃꍇ́C{@link #getString()} \bhs
	 *         ƂƓB
	 * @see #get(String,boolean)
	 * @see #getString()
	 * @see #searchString(String,boolean)
	 */
	public String getString(String s, boolean next) {
		return move(index, s, true, next);
	}



	/**
	 * ݈ʒű؂蕶܂ł̕擾B<br>
	 * ł́C󔒕iR[h "\u0020" ȉ̕jy 
	 * {@link #setWordSeparators}\bhŎw肳ꂽ̋
	 * 蕶ƂĈB<br>
	 * ݈ʒúC̋؂蕶ɈړBAC̋؂蕶
	 * 󔒕̏ꍇ́Č̍ŏ̕ɈړB
	 * @return 擾łB󔒕Ȃꍇ́C
	 *         ̖܂œǍށB
	 * @see #setWordSeparators
	 */
	public String getWord() {
		String text = this.text;
		int max = count;
		int i = index;
	
		// 󔒕ǂ݂Ƃ΂B
		i = skip(i,max);
	
		// 擾B
		StringBuffer sb = new StringBuffer();
		if(i<max) {
			if(!isSeparatorChar(text.charAt(i))) {
				for(;i<max && !isSpace(text.charAt(i)) && 
						!isSeparatorChar(text.charAt(i));i++) {
					sb.append(text.charAt(i));
				}
			}
			else {
				sb.append(text.charAt(i++));
			}
		}
	
		index = skip(i,max);
		return new String(sb);
	}

	/**
	 * w肵̋؂蕶ǂ𒲂ׂB
	 * @param ch 肷镶B
	 */
	private boolean isSeparatorChar(char ch) {
		char[] sc = wordSeparators;
		for(int i=0;i<sc.length;i++) {
			if(sc[i]==ch) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * ݈ʒus܂ł̊Ԃɂ镶擾B<br>
	 * ݈ʒúCs̍ŏ̕ɈړB
	 * @return ݈ʒus܂ł̕B
	 *         ݈ʒu܂݁Cs͊܂܂ȂB
	 * @see #getLine
	 */
	public String getLineString() {
		return getLine().getString();
	}
	
	private String newString(StringBuffer sb) {
		if(spaceSkip) {
			int end = sb.length();
			while((0<end) && (isSpace(sb.charAt(end-1)))) {
				end--;
			}
			sb.setLength(end);
		}
	
		return new String(sb);
	}
	
	
	/**
	 * w肳ꂽ񂪌݈ʒuȍ~͑̕ΏۃeLXgɊ
	 * ܂Ă邩ǂ𒲂ׂB
	 * @param s ׂ镶B
	 * @return ܂܂Ăꍇ trueB
	 */
	public boolean contains(String s) {
		return (indexOf(s,index,count)!=-1);
	}
	
	/**
	 * w肳ꂽ݈ʒuȍ~͑̕ΏۃeLXgɊ
	 * ܂Ă邩ǂ𒲂ׂB
	 * @param c ׂ镶B
	 * @return ܂܂Ăꍇ trueB
	 */
	public boolean contains(char c) {
		return (indexOf(c,index,count)!=-1);
	}
	
	
	
	
	/**
	 * w肳ꂽ̎̕Ɍ݈ʒuړB
	 * @param s 镶B
	 * @return w肵񂪌ꍇ trueBȂꍇ
	 *         falseB̏ꍇC݈ʒu͍XVȂB
	 */
	public boolean skip(String s) {
		int i = indexOf(s,index,count);
		if(i==-1) {
			return false;
		}
		else {
			index = skip(i + s.length(),count);
			return true;
		}
	}
	
	/**
	 * w肳ꂽ̎̕Ɍ݈ʒuړB
	 * @param c 镶B
	 * @return w肵ꍇ trueBȂꍇ
	 *         falseB̏ꍇC݈ʒu͍XVȂB
	 */
	public boolean skip(char c) {
		int i = indexOf(c,index,count);
		if(i==-1) {
			return false;
		}
		else {
			index = skip(i + 1,count);
			return true;
		}
	}
	
	
	/**
	 * setSpaceSkip(true) w肵Ă΋󔒕ǂ݂Ƃ΂C
	 * setCommentSkip(true) w肵Ă΃Rgǂ݂Ƃ΂B
	 */
	public void skip() {
		index = skip(index,count);
	}
	
	
	/**
	 * ݂̈ʒuL^ĂC{@link #reset} \bhĂяoꂽƂ
	 * ߂邱Ƃł悤ɂB
	 */
	public void mark() {
		marked = index;
	}
	
	/**
	 * {@link #mark} \bhŋL^ʒuɖ߂B
	 */
	public void reset() {
		index = marked;
	}
	
	
	/**
	 * CX^X̓e𕶎ƂĎ擾B
	 */
	public String toString() {
		return 
			" [text]    :" + getText() +   " / " +
			" [spaceS]  :" + spaceSkip +   " / " +
			" [commentS]:" + commentSkip + " / " +
			" [commentC]:" + commentChar + " / " +
			" [escapeC] :" + escapeChar ;
	}
	
	
	private int skip(int i, int max) {
		String text = this.text;
		if(i>=0) {
			for(;i<max;i++) {
				char c = text.charAt(i);
				if(spaceSkip && isSpace(c)) {
					continue;
				}
				else if(commentSkip && c==commentChar) {
					i = skipComment(i,max);
				}
				else {
					break;
				}
			}
		}
		return i;
	}
	
	private int skipComment(int i, int max) {
		String text = this.text;
		while(++i<max && text.charAt(i)!='\n' && text.charAt(i)!='\r')
			;
		if(i+1<max && text.charAt(i)=='\r' && text.charAt(i+1)=='\n') {
			i++;
		}
		return i;
	}
	
	private int processEscape(int i, int max) {
		String text = this.text;
		i++;
		if(text.charAt(i)=='\r' && i+1<max && text.charAt(i+1)=='\n') {
			i++;
		}
		return i;
	}

}
