/*
 * Decompiled with CFR 0.152.
 */
package nga.model;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import nga.model.UpdatableByText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
implements Iterable<String>,
UpdatableByText {
    private static final String DELIM = "\t";
    private LinkedList<String> list = new LinkedList();
    private int maxSize = 10;

    public History() {
    }

    public History(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.list.clear();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void add(String o) {
        int t;
        if (!this.list.remove(o) && this.list.size() == this.getMaxSize()) {
            this.list.removeLast();
        }
        if ((t = o.indexOf(DELIM)) > -1) {
            o = o.replaceAll(DELIM, "");
        }
        this.list.addFirst(o);
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public void update(String value) throws ParseException {
        if (value == null || value.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(value, DELIM);
        this.setMaxSize(Integer.parseInt(st.nextToken()));
        while (st.hasMoreTokens()) {
            this.add(st.nextToken());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMaxSize()).append(DELIM);
        for (String s : this) {
            sb.append(s).append(DELIM);
        }
        return new String(sb);
    }
}

