/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.CongaServletAdapterMultiCaster;
import nga.servlet.ErrorInfo;
import nga.servlet.Page;
import nga.servlet.PageStack;
import nga.servlet.RequestConfigInitializer;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.dsp.DefaultCongaServletFactory;
import nga.servlet.dsp.adapter.ExceptionLogger;
import nga.servlet.spi.CongaServletAdapter;
import nga.servlet.spi.CongaServletFactory;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.servlet.spi.UserAuth;
import nga.util.ClassDictionary;
import nga.util.ConfigurationException;
import nga.util.Resource;
import nga.util.UserLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CongaServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String WINDOW_ID = "_nga.window.id";
    public static final String ASYNC = "_nga.async";
    public static final String SYSTEM_ENCODING = "nga.servlet.system.encoding";
    public static final String CHARSET = "nga.servlet.charset";
    public static final String CONFIG_DIR = "nga.servlet.request-config-dir";
    public static final String CONFIG_FILE = "nga.servlet.request-config-file";
    public static final String FACTORY = "nga.servlet.factory";
    public static final String ADAPTER = "nga.servlet.adapter";
    public static final String RESOURCE_TAG = "nga.servlet.resource-tag";
    public static final String CLASS_DICTIONARY_PATH = "nga.servlet.class-dictionary-path";
    private static final String SERVICE_INFO = "nga.service.info";
    private static final String SESSION_BINDING_LISTENER = "nga.session.binding.listener";
    private CongaServletFactory factory;
    private List<Class<? extends CongaServletAdapter>> adapterClassList;
    private Map<String, ModuleInfo> moduleInfoMap = new HashMap<String, ModuleInfo>();
    private Map<String, String> charsetMap = new HashMap<String, String>();
    private Resource resource = new Resource(((Object)((Object)this)).getClass().getPackage().getName() + ".Message");
    private char resourceTag = (char)64;
    private ThreadLocal<CongaServletAdapter> adapter = new ThreadLocal<CongaServletAdapter>(){

        @Override
        protected synchronized CongaServletAdapter initialValue() {
            return new CongaServletAdapterMultiCaster(CongaServlet.this.adapterClassList);
        }
    };
    private static ThreadLocal<Map<String, ParameterParser>> parserMap = new ThreadLocal<Map<String, ParameterParser>>(){

        @Override
        protected synchronized Map<String, ParameterParser> initialValue() {
            return new HashMap<String, ParameterParser>();
        }
    };
    private static ThreadLocal<Map<String, ResultWriter>> writerMap = new ThreadLocal<Map<String, ResultWriter>>(){

        @Override
        protected synchronized Map<String, ResultWriter> initialValue() {
            return new HashMap<String, ResultWriter>();
        }
    };
    private String systemEncoding;
    private ClassDictionary classDictionary;

    public void init() throws ServletException {
        this.initResourceTag();
        this.initClassDictionary();
        this.initFactory();
        this.initAdapter();
        this.initEncoding();
        this.adapter.get().init(this);
    }

    private void initResourceTag() {
        String tag = this.getServletConfig().getInitParameter(RESOURCE_TAG);
        if (tag != null && tag.length() > 0) {
            this.resourceTag = tag.charAt(0);
        }
    }

    private void initClassDictionary() {
        String path = this.getServletConfig().getInitParameter(CLASS_DICTIONARY_PATH);
        if (path == null) {
            path = "conf/ClassDictionary.properties";
        }
        try {
            this.classDictionary = new ClassDictionary(this.getServletContext().getRealPath(path));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private void initAdapter() throws ServletException {
        this.adapterClassList = new ArrayList<Class<? extends CongaServletAdapter>>();
        String adapterList = this.getServletConfig().getInitParameter(ADAPTER);
        if (adapterList == null) {
            this.adapterClassList.add(ExceptionLogger.class);
        } else {
            try {
                StringTokenizer st = new StringTokenizer(adapterList, " ,\n\r;:");
                while (st.hasMoreTokens()) {
                    this.adapterClassList.add(Class.forName(st.nextToken()).asSubclass(CongaServletAdapter.class));
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void initEncoding() {
        String cs;
        this.systemEncoding = this.getServletConfig().getInitParameter(SYSTEM_ENCODING);
        if (this.systemEncoding == null) {
            this.systemEncoding = System.getProperty("file.encoding");
        }
        if ((cs = this.getServletConfig().getInitParameter(CHARSET)) == null) {
            this.charsetMap.put(null, this.systemEncoding);
        } else {
            StringTokenizer st = new StringTokenizer(cs, " ;,:\t\n\r");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int index = line.indexOf(61);
                String locale = null;
                String charset = this.systemEncoding;
                if (index > 0 && index < line.length() - 1) {
                    locale = line.substring(0, index).trim();
                    charset = line.substring(index + 1).trim();
                }
                this.charsetMap.put(locale, charset);
            }
        }
    }

    private void initFactory() throws ServletException {
        String factoryClassName = this.getServletConfig().getInitParameter(FACTORY);
        if (factoryClassName != null) {
            try {
                this.factory = this.newInstance(Class.forName(factoryClassName).asSubclass(CongaServletFactory.class));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            this.factory = new DefaultCongaServletFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            ServiceInfo serviceInfo = new ServiceInfo(this, request, response, this.systemEncoding);
            request.setAttribute(SERVICE_INFO, (Object)serviceInfo);
            String requestId = request.getServletPath();
            serviceInfo.setRequestId(requestId);
            this.checkSession(serviceInfo);
            this.initLocale(serviceInfo);
            this.initCharset(request);
            try {
                PageStack pageStack = this.getPageStack(request);
                Page page = pageStack.getPage();
                serviceInfo.setPageStack(pageStack);
                this.adapter.get().begin(serviceInfo);
                RequestInfo requestInfo = this.getRequestInfo(requestId);
                if (requestInfo == null) {
                    throw new ConfigurationException(this.resource.message("m_request_not_found", requestId));
                }
                serviceInfo.setErrorInfo(new ErrorInfo(requestInfo.getResultInfo().getModuleInfo()));
                if (this.lock(request, page)) {
                    try {
                        this.mainProc(serviceInfo, requestInfo, pageStack);
                        break block10;
                    }
                    finally {
                        page.unlock();
                    }
                }
                response.setContentType("text/xml; charset=UTF-8");
                PrintWriter writer = response.getWriter();
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<c></c>");
            }
            catch (Throwable e) {
                this.adapter.get().abort(serviceInfo, e);
            }
            finally {
                this.adapter.get().end(serviceInfo, requestId);
            }
        }
    }

    private void initLocale(ServiceInfo serviceInfo) {
        UserAttribute attr;
        User user = UserAuth.getUser(serviceInfo);
        if (user != null && user.isAuthorized() && (attr = user.getAttribute()) != null) {
            UserLocale.setLocale(attr.getLocale());
            return;
        }
        UserLocale.setLocale(serviceInfo.getRequest().getLocale());
    }

    private void checkSession(ServiceInfo serviceInfo) throws ServletException {
        HttpSession session = serviceInfo.getSession();
        if (session.getAttribute(SESSION_BINDING_LISTENER) == null) {
            session.setAttribute(SESSION_BINDING_LISTENER, (Object)new HttpSessionBindingListener(){

                public void valueBound(HttpSessionBindingEvent event) {
                }

                public void valueUnbound(HttpSessionBindingEvent event) {
                    ((CongaServletAdapter)CongaServlet.this.adapter.get()).sessionDestroyed(CongaServlet.this, event.getSession());
                }
            });
            this.adapter.get().sessionCreated(serviceInfo);
        }
    }

    private boolean lock(HttpServletRequest request, Page page) {
        String param = request.getParameter(ASYNC);
        if (param == null) {
            while (true) {
                if (!page.isLocked()) {
                    page.lock();
                    return true;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {}
            }
        }
        if (Boolean.parseBoolean(param)) {
            return true;
        }
        if (!page.isLocked()) {
            page.lock();
            return true;
        }
        return false;
    }

    private void mainProc(ServiceInfo serviceInfo, RequestInfo requestInfo, PageStack pageStack) throws Throwable {
        HttpServletRequest request = serviceInfo.getRequest();
        Page page = pageStack.getPage();
        Object pageObject = this.getPageObject(request, requestInfo, page);
        serviceInfo.setPageObject(pageObject);
        serviceInfo.setRequestInfo(requestInfo);
        Object resultObject = null;
        boolean parsed = true;
        ParameterInfo parameterInfo = requestInfo.getParameterInfo();
        if (parameterInfo != null && pageObject != null && parameterInfo.isDefined()) {
            parsed = this.getParameterParser(parameterInfo).parse(serviceInfo);
        }
        if (parsed) {
            resultObject = this.execController(serviceInfo, requestInfo, pageObject, page);
        }
        if (resultObject == null) {
            resultObject = pageObject;
        }
        serviceInfo.setResultObject(resultObject);
        if (!serviceInfo.hasError()) {
            serviceInfo.updatePageStack();
        }
        if (serviceInfo.isForwarding()) {
            if (serviceInfo.getResultInfo() != null) {
                this.getResultWriter(serviceInfo.getResultInfo()).write(serviceInfo);
            }
            String nextRequestId = serviceInfo.getNextRequestId();
            this.adapter.get().forwarding(serviceInfo, serviceInfo.getRequestId(), nextRequestId);
            page.unlock();
            request.getRequestDispatcher(nextRequestId).forward((ServletRequest)request, (ServletResponse)serviceInfo.getResponse());
            return;
        }
        this.getResultWriter(serviceInfo.getResultInfo()).write(serviceInfo);
    }

    private void initCharset(HttpServletRequest request) throws UnsupportedEncodingException {
        int index;
        String charset = null;
        String contentType = request.getContentType();
        int n = index = contentType != null ? contentType.lastIndexOf("charset=") : -1;
        if (index > -1) {
            charset = contentType.substring(index + 8);
        } else {
            Locale locale = UserLocale.getLocale();
            if (locale != null) {
                charset = this.charsetMap.get(locale.toString());
            }
            if (charset == null && (charset = this.charsetMap.get(null)) == null) {
                charset = this.systemEncoding;
            }
        }
        request.setCharacterEncoding(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo getRequestInfo(String path) throws ServletException {
        ModuleInfo moduleInfo;
        int index = path.lastIndexOf(47);
        String moduleName = path.substring(0, index);
        String requestId = path.substring(index + 1);
        Map<String, ModuleInfo> map = this.moduleInfoMap;
        synchronized (map) {
            moduleInfo = this.moduleInfoMap.get(moduleName);
            if (moduleInfo == null) {
                moduleInfo = new RequestConfigInitializer().getModuleInfo(moduleName, this.getServletConfig(), this.getServletContext(), this.resourceTag);
            }
        }
        return moduleInfo.getRequestInfo(requestId);
    }

    public static ServiceInfo getServiceInfo(HttpServletRequest request) {
        return (ServiceInfo)request.getAttribute(SERVICE_INFO);
    }

    private PageStack getPageStack(HttpServletRequest request) {
        String pageStackKey = request.getParameter(WINDOW_ID) + "@pageStack";
        HttpSession session = request.getSession();
        PageStack pageStack = (PageStack)session.getAttribute(pageStackKey);
        if (pageStack == null) {
            pageStack = new PageStack();
            session.setAttribute(pageStackKey, (Object)pageStack);
        }
        return pageStack;
    }

    public static String getWindowId() {
        return "w" + System.currentTimeMillis();
    }

    private Object getPageObject(HttpServletRequest request, RequestInfo requestInfo, Page page) throws InstantiationException, IllegalAccessException {
        String pageId = requestInfo.getPageId();
        String moduleId = requestInfo.getModuleInfo().getId();
        Class pageClass = null;
        try {
            pageClass = requestInfo.getPageClass();
            if (pageClass == null) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.resource.message("m_class_not_found", requestInfo.getPage()), e);
        }
        Object pageObject = pageId != null ? (moduleId.equals(page.getModuleId()) && pageId.equals(page.getPageId()) ? page.getPageObject() : this.newInstance(pageClass)) : this.newInstance(pageClass);
        page.setModuleId(moduleId);
        page.setPageId(pageId);
        page.setPageObject(pageObject);
        return pageObject;
    }

    private ParameterParser getParameterParser(ParameterInfo parameterInfo) {
        ParameterParser parser;
        Class<ParameterParser> parserClass = parameterInfo.getParser();
        String parserClassName = "";
        if (parserClass != null) {
            parserClassName = parserClass.getName();
        }
        if ((parser = parserMap.get().get(parserClassName)) == null) {
            parser = "".equals(parserClassName) ? this.factory.createParameterParser() : this.newInstance(parserClass);
            parserMap.get().put(parserClassName, parser);
        }
        return parser;
    }

    private Object execController(ServiceInfo serviceInfo, RequestInfo requestInfo, Object valueObject, Page page) throws Throwable {
        Object controller = null;
        Method method = null;
        Object[] param = null;
        if (requestInfo.hasController()) {
            Class c = requestInfo.getControllerClass();
            if (c != null) {
                controller = page.getController(c);
                if (controller == null) {
                    controller = this.newInstance(c);
                    page.putController(c, controller);
                }
                method = requestInfo.getControllerMethod();
            } else {
                controller = valueObject;
                method = requestInfo.getControllerMethod(controller.getClass());
            }
            Class<?>[] paramClass = method.getParameterTypes();
            param = new Object[paramClass.length];
            for (int i = 0; i < param.length; ++i) {
                if (paramClass[i].isAssignableFrom(ServiceInfo.class)) {
                    param[i] = serviceInfo;
                    continue;
                }
                if (paramClass[i].isAssignableFrom(HttpServletRequest.class)) {
                    param[i] = serviceInfo.getRequest();
                    continue;
                }
                if (paramClass[i].isAssignableFrom(HttpServletResponse.class)) {
                    param[i] = serviceInfo.getResponse();
                    continue;
                }
                if (valueObject == null || !paramClass[i].isAssignableFrom(valueObject.getClass())) continue;
                param[i] = valueObject;
            }
        }
        Object resultObject = null;
        if (this.adapter.get().checkParameter(serviceInfo, controller, method, param)) {
            try {
                if (controller != null && method != null) {
                    resultObject = method.invoke(controller, param);
                }
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            this.adapter.get().editResult(serviceInfo, controller, method, resultObject);
        }
        return resultObject;
    }

    private ResultWriter getResultWriter(ResultInfo resultInfo) {
        ResultWriter writer;
        Class<ResultWriter> writerClass = resultInfo.getWriter();
        String writerClassName = "";
        if (writerClass != null) {
            writerClassName = writerClass.getName();
        }
        if ((writer = writerMap.get().get(writerClassName)) == null) {
            writer = "".equals(writerClassName) ? this.factory.createResultWriter() : this.newInstance(writerClass);
            writerMap.get().put(writerClassName, writer);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.adapter.get().destroy(this);
        }
        finally {
            super.destroy();
        }
    }

    public char getResourceTag() {
        return this.resourceTag;
    }

    public <T> T newInstance(Class<T> cls) {
        return this.classDictionary.newInstance(cls);
    }

    public <T> T getSingleInstance(Class<T> cls) {
        return this.classDictionary.getSingleInstance(cls);
    }
}

