/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PageInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResourceInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.config.TemplateInfo;
import nga.util.ConfigurationException;
import nga.util.ConfigurationMap;
import nga.util.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class RequestConfigInitializer {
    private static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private Resource messageResource = new Resource(this.getClass().getPackage().getName() + ".Message");
    private ModuleInfo moduleInfo;
    private Map<String, TemplateInfo> templateInfoMap = new HashMap<String, TemplateInfo>();

    public ModuleInfo getModuleInfo(String moduleName, ServletConfig config, ServletContext context, char resourceTag) throws ServletException {
        this.moduleInfo = new ModuleInfo(moduleName, resourceTag);
        try {
            this.initModuleInfo(moduleName, new File(context.getRealPath("conf"), "template.xml"), config, context);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.readModuleInfo(moduleName, config, context);
        return this.moduleInfo;
    }

    private void readModuleInfo(String moduleName, ServletConfig config, ServletContext context) throws ServletException {
        File[] file = this.getConfigFile(moduleName, config, context);
        for (int i = 0; i < file.length; ++i) {
            try {
                this.initModuleInfo(moduleName, file[i], config, context);
                continue;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private File[] getConfigFile(String moduleName, ServletConfig config, ServletContext context) {
        File[] files;
        int starIndex;
        String configDir = config.getInitParameter("nga.servlet.request-config-dir");
        if (configDir == null || configDir.length() == 0) {
            configDir = "conf";
        }
        if (configDir.charAt(0) == '/' || configDir.charAt(0) == '\\') {
            configDir = configDir.substring(1);
        }
        configDir = moduleName + "/" + configDir;
        String configFile = config.getInitParameter("nga.servlet.request-config-file");
        if (configFile == null) {
            configFile = "*request-config.xml";
        }
        final String prefix = (starIndex = configFile.indexOf(42)) > 0 ? configFile.substring(0, starIndex) : null;
        final String suffix = starIndex < configFile.length() - 1 ? configFile.substring(starIndex + 1) : null;
        File dir = new File(context.getRealPath(configDir));
        File[] tmp = dir.listFiles(new FilenameFilter(){

            public boolean accept(File d, String name) {
                if (prefix != null && !name.startsWith(prefix)) {
                    return false;
                }
                return suffix == null || name.endsWith(suffix);
            }
        });
        File template = new File(dir, "template.xml");
        if (tmp != null && template.exists()) {
            files = new File[tmp.length + 1];
            files[0] = template;
            if (tmp.length > 0) {
                System.arraycopy(tmp, 0, files, 1, tmp.length);
            }
        } else {
            files = tmp;
        }
        if (files == null || files.length == 0) {
            throw new ConfigurationException(this.message("m_not_found_config_file", dir + File.separator + configFile));
        }
        return files;
    }

    private void initModuleInfo(String moduleName, File file, ServletConfig config, ServletContext context) throws ConfigurationException, IOException, SAXException, ParserConfigurationException, ServletException {
        Node node;
        String auth;
        Document doc = builderFactory.newDocumentBuilder().parse(file);
        this.includeModule(moduleName, doc, config, context);
        this.initTemplateInfo(doc);
        NodeList list = doc.getElementsByTagName("module");
        if (list.getLength() > 0 && (auth = this.getValue((node = list.item(0)).getAttributes(), "auth")) != null) {
            this.moduleInfo.setAuth(auth);
        }
        this.addResourceInfo(doc);
        this.addPageInfo(doc);
        this.addRequestInfo(doc);
    }

    private void includeModule(String moduleName, Document doc, ServletConfig config, ServletContext context) throws ServletException {
        NodeList list = doc.getElementsByTagName("include");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            NamedNodeMap attr = node.getAttributes();
            String module = this.getValue(attr, "module");
            if (module == null) {
                throw new ConfigurationException(this.message("m_null_include_module", new Object[0]));
            }
            if (moduleName.equals(module)) {
                throw new ConfigurationException(this.message("m_cannot_include_own_module", moduleName));
            }
            this.readModuleInfo(module, config, context);
        }
    }

    private void initTemplateInfo(Document doc) {
        NodeList list = doc.getElementsByTagName("template");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            this.initTemplateInfo(node);
        }
    }

    private void initTemplateInfo(Node node) {
        String base;
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_template_id", new Object[0]));
        }
        TemplateInfo templateInfo = this.templateInfoMap.get(id);
        if (templateInfo == null) {
            templateInfo = new TemplateInfo(id);
            this.templateInfoMap.put(id, templateInfo);
        }
        if ((base = this.getValue(attr, "extends")) != null) {
            TemplateInfo baseTemplateInfo = this.templateInfoMap.get(base);
            if (baseTemplateInfo == null) {
                throw new ConfigurationException(this.message("m_null_template_base", id, base));
            }
            templateInfo.update(baseTemplateInfo);
        }
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            String name = child.getNodeName();
            if ("target".equals(name)) {
                TargetInfo targetInfo = templateInfo.getTargetInfo();
                this.addAttributes(targetInfo, child.getAttributes());
                NodeList children = child.getChildNodes();
                if (children == null || children.getLength() <= 0) continue;
                targetInfo.setChildren(new TargetInfoList());
                this.initTarget(targetInfo.getChildren(), children);
                continue;
            }
            if ("property".equals(name)) {
                this.addAttributes(templateInfo.getPropertyInfo(), child.getAttributes());
                continue;
            }
            if ("result".equals(name)) {
                this.addAttributes(templateInfo.getResultInfo(), child.getAttributes());
                continue;
            }
            if ("on-error".equals(name)) {
                this.addAttributes(templateInfo.getOnErrorInfo(), child.getAttributes());
                continue;
            }
            if ("on-forwarding".equals(name)) {
                this.addAttributes(templateInfo.getOnForwardingInfo(), child.getAttributes());
                continue;
            }
            if (!"parameter".equals(name)) continue;
            this.addAttributes(templateInfo.getParameterInfo(), child.getAttributes());
        }
    }

    private void addAttributes(ConfigurationMap info, NamedNodeMap attr) {
        for (int i = 0; i < attr.getLength(); ++i) {
            Node n = attr.item(i);
            info.put(n.getNodeName(), n.getNodeValue());
        }
    }

    private void addResourceInfo(Document doc) {
        NodeList list = doc.getElementsByTagName("resource");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            ResourceInfo resourceInfo = this.getResourceInfo(node);
            if (this.moduleInfo.setResourceInfo(resourceInfo.getId(), resourceInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_resource", resourceInfo.getId()));
        }
    }

    private ResourceInfo getResourceInfo(Node node) {
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_resource_id", new Object[0]));
        }
        String cls = this.getValue(attr, "class");
        if (cls == null) {
            throw new ConfigurationException(this.message("m_null_resource_class", new Object[0]));
        }
        return new ResourceInfo(id, cls, this.getValue(attr, "parent"));
    }

    private void addPageInfo(Document doc) {
        NodeList list = doc.getElementsByTagName("page");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            PageInfo pageInfo = this.getPageInfo(node);
            if (this.moduleInfo.setPageInfo(pageInfo.getId(), pageInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_page", pageInfo.getId()));
        }
    }

    private PageInfo getPageInfo(Node node) throws ConfigurationException {
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_page_id", new Object[0]));
        }
        PageInfo pageInfo = new PageInfo(id);
        String cls = this.getValue(attr, "class");
        if (cls == null) {
            throw new ConfigurationException(this.message("m_null_page_class", new Object[0]));
        }
        try {
            Class<?> c = Class.forName(cls);
            pageInfo.setPageClass(c);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", cls), e);
        }
        return pageInfo;
    }

    private void addRequestInfo(Document doc) {
        NodeList list = doc.getElementsByTagName("request");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            RequestInfo requestInfo = this.getRequestInfo(node);
            this.moduleInfo.setRequestInfo(requestInfo.getId(), requestInfo);
        }
    }

    private RequestInfo getRequestInfo(Node node) throws ConfigurationException {
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_request_id", new Object[0]));
        }
        RequestInfo requestInfo = this.moduleInfo.getRequestInfo(id);
        if (requestInfo == null) {
            requestInfo = new RequestInfo(id);
        }
        requestInfo.setAuth(this.getValue(attr, "auth"));
        String controller = this.getValue(attr, "controller");
        if (controller != null) {
            int dotIndex = controller.lastIndexOf(46);
            if (dotIndex == -1) {
                requestInfo.setController(null, controller);
            } else {
                if (dotIndex == 0 || dotIndex > controller.length() - 2) {
                    throw new ConfigurationException(this.message("m_invalid_controller_attribute", new Object[0]));
                }
                try {
                    Class<?> c = Class.forName(controller.substring(0, dotIndex));
                    requestInfo.setController(c, controller.substring(dotIndex + 1));
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException(this.message("m_class_not_found", controller.substring(0, dotIndex)), e);
                }
            }
        }
        requestInfo.setPage(this.getValue(attr, "page"));
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            String name = child.getNodeName();
            if ("parameter".equals(name)) {
                this.initParameterInfo(child, requestInfo.getParameterInfo());
                continue;
            }
            if ("result".equals(name)) {
                this.initResultInfo(child, requestInfo.getResultInfo());
                continue;
            }
            if ("on-error".equals(name)) {
                this.initResultInfo(child, requestInfo.getOnErrorInfo());
                continue;
            }
            if (!"on-forwarding".equals(name)) continue;
            this.initResultInfo(child, requestInfo.getOnForwardingInfo());
        }
        return requestInfo;
    }

    private ResultInfo initResultInfo(Node node, ResultInfo resultInfo) {
        resultInfo.setModuleInfo(this.moduleInfo);
        NamedNodeMap attr = node.getAttributes();
        this.initConfigurationInfo(resultInfo, node, attr);
        String writerClass = this.getValue(attr, "writer");
        try {
            if (writerClass != null) {
                resultInfo.setWriter(Class.forName(writerClass));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", writerClass), e);
        }
        this.addAttributes(resultInfo, attr);
        this.initTarget(resultInfo.getTargetInfoList(), node.getChildNodes());
        return resultInfo;
    }

    private void initTarget(TargetInfoList targetInfoList, NodeList nlist) {
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            targetInfoList.add(this.getTargetInfo(child));
        }
    }

    private TargetInfo getTargetInfo(Node node) {
        NamedNodeMap attr = node.getAttributes();
        TargetInfo targetInfo = new TargetInfo(this.moduleInfo);
        this.initConfigurationInfo(targetInfo, node, attr);
        this.addAttributes(targetInfo, attr);
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            targetInfo.setChildren(new TargetInfoList());
            this.initTarget(targetInfo.getChildren(), children);
        }
        return targetInfo;
    }

    private ParameterInfo initParameterInfo(Node node, ParameterInfo parameterInfo) {
        parameterInfo.setModuleInfo(this.moduleInfo);
        parameterInfo.setDefined(true);
        NamedNodeMap attr = node.getAttributes();
        this.initConfigurationInfo(parameterInfo, node, attr);
        String parserClass = this.getValue(attr, "parser");
        try {
            if (parserClass != null) {
                parameterInfo.setParser(Class.forName(parserClass));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", parserClass), e);
        }
        this.addAttributes(parameterInfo, attr);
        this.initProperty(parameterInfo.getPropertyInfoMap(), node.getChildNodes());
        return parameterInfo;
    }

    private void initProperty(PropertyInfoMap propertyMap, NodeList nlist) {
        for (int i = 0; i < nlist.getLength(); ++i) {
            PropertyInfo propertyInfo;
            Node child = nlist.item(i);
            if (child.getNodeType() != 1 || propertyMap.put((propertyInfo = this.getPropertyInfo(child)).getName(), propertyInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_property", propertyInfo.getName()));
        }
    }

    private PropertyInfo getPropertyInfo(Node node) {
        NamedNodeMap attr = node.getAttributes();
        PropertyInfo propertyInfo = new PropertyInfo(this.moduleInfo);
        this.initConfigurationInfo(propertyInfo, node, attr);
        if (propertyInfo.getName() == null) {
            String name = this.getValue(attr, "name");
            if (name == null) {
                throw new ConfigurationException(this.message("m_null_property_name", new Object[0]));
            }
            propertyInfo.setName(name);
        }
        this.addAttributes(propertyInfo, attr);
        return propertyInfo;
    }

    private String getValue(NamedNodeMap attr, String name) {
        if (attr == null) {
            return null;
        }
        Node node = attr.getNamedItem(name);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private String message(String key, Object ... args) {
        return this.messageResource.message(key, args);
    }

    private void initConfigurationInfo(ConfigurationMap config, Node node, NamedNodeMap attr) {
        String template = this.getValue(attr, "template");
        template = template == null ? node.getNodeName() : this.getValue(attr, "template");
        if (template == null) {
            return;
        }
        TemplateInfo templateInfo = this.templateInfoMap.get(template);
        if (templateInfo == null) {
            return;
        }
        if (config instanceof PropertyInfo) {
            config.putAll(templateInfo.getPropertyInfo());
        } else if (config instanceof TargetInfo) {
            config.putAll(templateInfo.getTargetInfo());
        } else if (config instanceof ResultInfo) {
            config.putAll(templateInfo.getResultInfo());
        } else if (config instanceof ParameterInfo) {
            config.putAll(templateInfo.getParameterInfo());
        }
    }
}

