/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nga.servlet.CongaServlet;
import nga.servlet.ErrorInfo;
import nga.servlet.Page;
import nga.servlet.PageStack;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.spi.CongaServletLog;
import nga.servlet.spi.CongaServletRDB;
import nga.sql.RDB;
import nga.util.ConfigurationException;
import nga.util.Log;
import nga.util.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInfo {
    private static final int REMOVE_PAGE = 1;
    private static final int SAVE_PAGE = 2;
    private CongaServlet servlet;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private String systemEncoding;
    private ErrorInfo errorInfo;
    private RequestInfo requestInfo;
    private String requestId;
    private String nextRequestId;
    private Object pageObject;
    private Object resultObject;
    private PageStack pageStack;
    private Page page;
    private int pageStackOperation;
    private Log log;

    ServiceInfo(CongaServlet servlet, HttpServletRequest request, HttpServletResponse response, String systemEncoding) {
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        this.session = request.getSession();
        this.systemEncoding = systemEncoding;
        this.log = this.createLog();
        this.createRDB();
    }

    private Log createLog() {
        CongaServletLog log = this.newInstance(CongaServletLog.class);
        log.init(this);
        Log.setInstance(log);
        return log;
    }

    private RDB createRDB() {
        CongaServletRDB rdb = this.newInstance(CongaServletRDB.class);
        rdb.init(this);
        RDB.setInstance(rdb);
        return rdb;
    }

    public CongaServlet getServlet() {
        return this.servlet;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public ErrorInfo setErrorMessage(String message, Object ... args) {
        return this.getErrorInfo().setMessage(message, args);
    }

    public void setException(Throwable exception) {
        this.getErrorInfo().setException(exception);
    }

    public void setError() {
        this.errorInfo.setError();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
        ResultInfo resultInfo = requestInfo.getResultInfo();
        this.setNextRequestId(resultInfo);
    }

    private void setNextRequestId(ResultInfo resultInfo) {
        String nextRequestId = null;
        nextRequestId = resultInfo.getForward();
        if (nextRequestId != null) {
            this.forward(nextRequestId);
            return;
        }
        nextRequestId = resultInfo.getCall();
        if (nextRequestId != null) {
            String callBackRequestId = resultInfo.getCallBack();
            if (callBackRequestId == null) {
                throw new ConfigurationException(Resource.getMessage(this.getClass().getPackage().getName() + ".Message", "m_null_call_back", new Object[0]));
            }
            this.call(nextRequestId, callBackRequestId);
            return;
        }
        TargetInfoList targetInfoList = resultInfo.getTargetInfoList();
        if (targetInfoList == null || targetInfoList.isEmpty()) {
            this.returnToCaller();
            return;
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getNextRequestId() {
        return this.nextRequestId;
    }

    void setNextRequestId(String requestId) {
        this.nextRequestId = requestId;
    }

    public ResultInfo getResultInfo() {
        if (this.hasError()) {
            if (this.requestInfo.hasOnErrorInfo()) {
                return this.requestInfo.getOnErrorInfo();
            }
            return this.requestInfo.getResultInfo();
        }
        if (this.isForwarding()) {
            return this.requestInfo.getOnForwardingInfo();
        }
        return this.requestInfo.getResultInfo();
    }

    public TargetInfoList getTargetInfoList() {
        return this.getResultInfo().getTargetInfoList();
    }

    public ParameterInfo getParameterInfo() {
        return this.requestInfo.getParameterInfo();
    }

    public PropertyInfoMap getPropertyInfoMap() {
        return this.requestInfo.getParameterInfo().getPropertyInfoMap();
    }

    public Object getPageObject() {
        return this.pageObject;
    }

    void setPageObject(Object pageObject) {
        this.pageObject = pageObject;
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    void setResultObject(Object resultObject) {
        this.resultObject = resultObject;
    }

    public <T> T newInstance(Class<T> cls) {
        return this.servlet.newInstance(cls);
    }

    public <T> T getSingleInstance(Class<T> cls) {
        return this.servlet.getSingleInstance(cls);
    }

    void setPageStack(PageStack pageStack) {
        this.pageStack = pageStack;
        this.page = pageStack.getPage();
    }

    public void forward(String requestId) {
        this.setNextRequestId(requestId);
    }

    public void call(String requestId, String callBackRequestId) {
        this.setNextRequestId(requestId);
        if (this.page != null) {
            this.page.setCallBackRequestId(callBackRequestId);
            this.pageStackOperation = 2;
        }
    }

    public void returnToCaller() {
        Page previousPage = this.pageStack.getPreviousPage();
        if (previousPage != null) {
            String nextRequestId = previousPage.getCallBackRequestId();
            this.setNextRequestId(nextRequestId);
            this.pageStackOperation = 1;
        }
    }

    void updatePageStack() {
        if (this.pageStackOperation == 1) {
            this.pageStack.removePage();
        } else if (this.pageStackOperation == 2) {
            this.pageStack.savePage();
        }
        this.pageStackOperation = 0;
    }

    public boolean hasError() {
        return this.getErrorInfo().hasError();
    }

    public boolean isForwarding() {
        String oldRequestId = this.getRequestId();
        String nextRequestId = this.getNextRequestId();
        return !this.hasError() && nextRequestId != null && !nextRequestId.equals(oldRequestId);
    }

    public Log getLog() {
        return this.log;
    }
}

