/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PageInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.ResultInfo;
import nga.util.ConfigurationException;
import nga.util.Resource;

public class RequestInfo
implements Comparable {
    private String id;
    private String page;
    private Class pageClass;
    private Class controllerClass;
    private Method controllerMethod;
    private String controllerMethodName;
    private ParameterInfo parameterInfo;
    private ResultInfo resultInfo;
    private ResultInfo onErrorInfo;
    private ResultInfo onForwardingInfo;
    private ModuleInfo moduleInfo;
    private String auth;

    public RequestInfo(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public Class getPageClass() throws ClassNotFoundException {
        if (this.pageClass == null) {
            if (this.page == null) {
                return null;
            }
            try {
                this.pageClass = this.getModuleInfo().getPageInfo(this.page).getPageClass();
            }
            catch (NullPointerException e) {
                this.pageClass = Class.forName(this.page);
            }
        }
        return this.pageClass;
    }

    public String getPageId() {
        PageInfo pi = this.getModuleInfo().getPageInfo(this.page);
        if (pi == null) {
            return null;
        }
        return this.page;
    }

    public Class getControllerClass() {
        return this.controllerClass;
    }

    public void setController(Class controllerClass, String methodName) {
        if (controllerClass == null) {
            this.controllerMethodName = methodName;
            return;
        }
        this.setControllerClass(controllerClass);
        this.setControllerMethod(controllerClass, methodName);
    }

    private void setControllerMethod(Class controllerClass, String methodName) {
        Method[] method = controllerClass.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().equals(methodName) || !Modifier.isPublic(method[i].getModifiers())) continue;
            this.setControllerMethod(method[i]);
            break;
        }
        if (this.getControllerMethod() == null) {
            throw new ConfigurationException(new Resource("nga.servlet.Message").message("m_invalid_controller_method", controllerClass.getName(), methodName));
        }
    }

    public void setControllerClass(Class controllerClass) {
        this.controllerClass = controllerClass;
    }

    public Method getControllerMethod() {
        return this.controllerMethod;
    }

    public Method getControllerMethod(Class controllerClass) {
        if (this.controllerMethod == null) {
            this.setControllerMethod(controllerClass, this.controllerMethodName);
        }
        return this.getControllerMethod();
    }

    public void setControllerMethod(Method controllerMethod) {
        this.controllerMethod = controllerMethod;
    }

    public ParameterInfo getParameterInfo() {
        if (this.parameterInfo == null) {
            this.parameterInfo = new ParameterInfo(this.moduleInfo);
        }
        return this.parameterInfo;
    }

    public ResultInfo getResultInfo() {
        if (this.resultInfo == null) {
            this.resultInfo = new ResultInfo(this.moduleInfo);
        }
        return this.resultInfo;
    }

    public ResultInfo getOnErrorInfo() {
        if (this.onErrorInfo == null) {
            this.onErrorInfo = new ResultInfo(this.moduleInfo);
        }
        return this.onErrorInfo;
    }

    public boolean hasOnErrorInfo() {
        return this.onErrorInfo != null;
    }

    public ResultInfo getOnForwardingInfo() {
        if (this.onForwardingInfo == null) {
            this.onForwardingInfo = new ResultInfo(this.moduleInfo);
        }
        return this.onForwardingInfo;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return this.getId().compareTo(((RequestInfo)o).getId());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getId().equals(((RequestInfo)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public void setModuleInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public boolean hasController() {
        return this.controllerClass != null || this.controllerMethodName != null;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public boolean needAuth() {
        String auth = this.getAuth();
        if (auth != null) {
            return auth.equalsIgnoreCase("true");
        }
        auth = this.moduleInfo.getAuth();
        if (auth != null) {
            return auth.equalsIgnoreCase("true");
        }
        return false;
    }
}

