/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.CongaServletRDB;
import nga.util.SystemException;

public class DefaultCongaServletRDB
extends CongaServletRDB {
    public static final String DATASOURCE_NAME = "nga.servlet.dsp.ds";
    private String dataSourceName;
    private Connection connection;

    public void init(ServiceInfo serviceInfo) {
        this.dataSourceName = serviceInfo.getServlet().getServletConfig().getInitParameter(DATASOURCE_NAME);
        if (this.dataSourceName == null) {
            this.dataSourceName = "conga";
        }
    }

    public Connection handleGetConnection() {
        if (this.connection == null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/" + this.dataSourceName);
                this.connection = ds.getConnection();
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return this.connection;
    }

    public void handleClose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
        DefaultCongaServletRDB.rollback();
    }

    public void handleDestroy() {
        this.handleClose();
    }

    public void handleBegin() {
        DefaultCongaServletRDB.rollback();
    }

    public void handleRollback() {
        try {
            this.connection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleCommit() {
        try {
            this.connection.commit();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

