/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.LogWriter;

public class DefaultLogWriter
extends LogWriter {
    private static final int FATAL = 50000;
    private static final int ERROR = 40000;
    private static final int WARN = 30000;
    private static final int INFO = 20000;
    private static final int DEBUG = 10000;
    public static final String LOG_LEVEL = "nga.servlet.dsp.log-level";
    private int logLevel = 20000;

    protected void init(CongaServlet servlet) {
        this.logLevel = this.getLogLevel(servlet);
    }

    private int getLogLevel(CongaServlet servlet) {
        String level = servlet.getInitParameter(LOG_LEVEL);
        if (level == null || level.length() == 0) {
            return 20000;
        }
        try {
            return Integer.parseInt(level);
        }
        catch (Exception exception) {
            if ("WARN".equalsIgnoreCase(level)) {
                return 30000;
            }
            if ("ERROR".equalsIgnoreCase(level)) {
                return 40000;
            }
            if ("FATAL".equalsIgnoreCase(level)) {
                return 50000;
            }
            if ("DEBUG".equalsIgnoreCase(level)) {
                return 10000;
            }
            return 20000;
        }
    }

    private void log(ServiceInfo serviceInfo, String level, Object message, Throwable t) {
        DefaultLogWriter.log(serviceInfo.getServlet(), level, serviceInfo.getSession(), serviceInfo.getRequestId(), message, t);
    }

    public static void log(HttpServlet servlet, String level, HttpSession session, String requestId, Object message, Throwable t) {
        String s = level + ":" + (session != null ? session.getId() : "") + ":" + (requestId != null ? requestId : "") + ":" + message;
        if (t != null) {
            servlet.log(s, t);
        } else {
            servlet.log(s);
        }
    }

    public void debug(ServiceInfo serviceInfo, Object message) {
        this.log(serviceInfo, "DEBUG", message, null);
    }

    public void debug(ServiceInfo serviceInfo, Object message, Throwable t) {
        this.log(serviceInfo, "DEBUG", message, t);
    }

    public boolean isDebugEnabled() {
        return this.logLevel >= 10000;
    }

    public void info(ServiceInfo serviceInfo, Object message) {
        this.log(serviceInfo, "INFO ", message, null);
    }

    public void info(ServiceInfo serviceInfo, Object message, Throwable t) {
        this.log(serviceInfo, "INFO ", message, t);
    }

    public boolean isInfoEnabled() {
        return this.logLevel >= 20000;
    }

    public void warn(ServiceInfo serviceInfo, Object message) {
        this.log(serviceInfo, "WARN ", message, null);
    }

    public void warn(ServiceInfo serviceInfo, Object message, Throwable t) {
        this.log(serviceInfo, "WARN ", message, t);
    }

    public boolean isWarnEnabled() {
        return this.logLevel >= 30000;
    }

    public void error(ServiceInfo serviceInfo, Object message) {
        this.log(serviceInfo, "ERROR", message, null);
    }

    public void error(ServiceInfo serviceInfo, Object message, Throwable t) {
        this.log(serviceInfo, "ERROR", message, t);
    }

    public boolean isErrorEnabled() {
        return this.logLevel >= 40000;
    }

    public void fatal(ServiceInfo serviceInfo, Object message) {
        this.log(serviceInfo, "FATAL", message, null);
    }

    public void fatal(ServiceInfo serviceInfo, Object message, Throwable t) {
        this.log(serviceInfo, "FATAL", message, t);
    }

    public boolean isFatalEnabled() {
        return this.logLevel >= 50000;
    }
}

