/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import nga.model.User;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.dsp.DefaultUserStorage;
import nga.servlet.spi.UserAuth;
import nga.servlet.spi.UserStorage;

public class DefaultUserAuth
extends UserAuth {
    private static final String ENCODING = "UTF-8";
    private static final String USER_KEY = "nga.servlet.dsp.user";

    protected void handleLogin(ServiceInfo serviceInfo, User user) throws ServletException {
        user.setAuthorized(false);
        String userId = user.getUserId();
        if (userId == null || userId.length() == 0) {
            return;
        }
        String password = user.getPassword();
        if (password == null) {
            password = "";
        }
        user.setPassword(null);
        if (this.auth(serviceInfo.getServlet(), user.getUserId(), password)) {
            user.setAuthorized(true);
            UserWrapper userData = new UserWrapper(serviceInfo, user);
            serviceInfo.getSession().setAttribute(USER_KEY, (Object)userData);
        }
    }

    private boolean auth(CongaServlet servlet, String userId, String password) throws ServletException {
        File file = this.getPasswordFile(servlet, userId);
        if (!file.exists()) {
            return false;
        }
        BufferedInputStream is = null;
        try {
            byte[] d = this.digest(password);
            byte[] b = new byte[d.length];
            is = new BufferedInputStream(new FileInputStream(file), b.length);
            is.read(b);
            if (!this.equal(b, d)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    private byte[] digest(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = this.getMessageDigest();
        md.update(password.getBytes(ENCODING));
        return md.digest();
    }

    private File getPasswordFile(CongaServlet servlet, String userId) {
        return DefaultUserStorage.getFile(servlet, userId + ".password");
    }

    private MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-512");
    }

    private boolean equal(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void handleLogout(ServiceInfo serviceInfo) {
        User user = this.handleGetUser(serviceInfo);
        if (user != null) {
            serviceInfo.getSession().invalidate();
        }
    }

    protected User handleGetUser(ServiceInfo serviceInfo) {
        HttpSession session = serviceInfo.getSession();
        UserWrapper userData = (UserWrapper)session.getAttribute(USER_KEY);
        if (userData == null) {
            return null;
        }
        return userData.getUser();
    }

    protected void handleSetPassword(ServiceInfo serviceInfo, User user) throws ServletException {
        File file = this.getPasswordFile(serviceInfo.getServlet(), user.getUserId());
        FilterOutputStream os = null;
        try {
            byte[] d = this.digest(user.getPassword());
            os = new BufferedOutputStream(new FileOutputStream(file), d.length);
            os.write(d);
            ((BufferedOutputStream)os).flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class UserWrapper
    implements HttpSessionBindingListener {
        private User user;
        private ServiceInfo serviceInfo;

        public UserWrapper(ServiceInfo serviceInfo, User user) throws ServletException {
            this.serviceInfo = serviceInfo;
            this.user = user;
            UserStorage.load(serviceInfo, user);
        }

        public User getUser() {
            return this.user;
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            try {
                UserStorage.save(this.serviceInfo, this.user);
                this.user.setAuthorized(false);
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }
    }
}

