/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;
import nga.model.UpdatableByText;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.WriterUtil;
import nga.servlet.spi.UserStorage;
import nga.util.FormatUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultUserStorage
extends UserStorage {
    public static final String USER_DATA_DIR = "nga.servlet.dsp.user-data-dir";
    private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    protected void handleLoad(ServiceInfo serviceInfo, User user) throws ServletException {
        try {
            File file = DefaultUserStorage.getFile(serviceInfo.getServlet(), user.getUserId());
            if (!file.exists()) {
                return;
            }
            Document doc = this.builderFactory.newDocumentBuilder().parse(file);
            Node node = doc.getElementsByTagName("c").item(0);
            NodeList nlist = node.getChildNodes();
            UserAttribute userAttr = user.getAttribute();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node child = nlist.item(i);
                String name = child.getNodeName();
                if (!"e".equals(name)) continue;
                this.addEntry(userAttr, child);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void addEntry(UserAttribute userAttr, Node node) {
        NamedNodeMap attr = node.getAttributes();
        String id = attr.getNamedItem("id").getNodeValue();
        String className = attr.getNamedItem("class").getNodeValue();
        String value = node.getFirstChild().getNodeValue();
        try {
            if (className.equals("java.lang.String")) {
                userAttr.put(id, value);
            } else if (className.equals("java.lang.Integer")) {
                userAttr.put(id, Integer.parseInt(value));
            } else if (className.equals("java.lang.Long")) {
                userAttr.put(id, Long.parseLong(value));
            } else if (className.equals("java.lang.Double")) {
                userAttr.put(id, Double.parseDouble(value));
            } else if (className.equals("java.lang.Float")) {
                userAttr.put(id, Float.valueOf(Float.parseFloat(value)));
            } else if (className.equals("java.lang.Short")) {
                userAttr.put(id, Short.parseShort(value));
            } else if (className.equals("java.lang.Byte")) {
                userAttr.put(id, Byte.parseByte(value));
            } else if (className.equals("java.math.BigDecimal")) {
                userAttr.put(id, new BigDecimal(value));
            } else if (className.equals("java.lang.Character")) {
                userAttr.put(id, Character.valueOf(value.charAt(0)));
            } else if (className.equals("java.util.Date")) {
                userAttr.put(id, this.dateFormat.parse(value));
            } else if (className.equals("java.sql.Date")) {
                userAttr.put(id, FormatUtil.toDate(this.dateFormat.parse(value)));
            } else if (className.equals("java.sql.Time")) {
                userAttr.put(id, FormatUtil.toTime(this.dateFormat.parse(value)));
            } else if (className.equals("java.sql.Timestamp")) {
                userAttr.put(id, FormatUtil.toTimestamp(this.dateFormat.parse(value)));
            } else {
                Class<?> c = Class.forName(className);
                if (UpdatableByText.class.isAssignableFrom(c)) {
                    UpdatableByText obj = (UpdatableByText)c.newInstance();
                    obj.update(value);
                    userAttr.put(id, obj);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void handleSave(ServiceInfo serviceInfo, User user) throws ServletException {
        try {
            this.save(serviceInfo.getServlet(), user);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(CongaServlet servlet, User user) throws IOException {
        String userId = user.getUserId();
        UserAttribute userAttr = user.getAttribute();
        if (userId == null) {
            return;
        }
        File file = DefaultUserStorage.getFile(servlet, userId);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.newLine();
            writer.write("<c>");
            writer.newLine();
            for (Map.Entry entry : userAttr.entrySet()) {
                String id = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                Class<?> c = value.getClass();
                String className = c.getName();
                writer.write("<e");
                WriterUtil.attr(writer, "id", (Object)id);
                WriterUtil.attr(writer, "class", (Object)className);
                writer.write(">");
                if (Date.class.isAssignableFrom(c)) {
                    writer.write(this.dateFormat.format((Date)value));
                } else if (value instanceof String || value instanceof Number || value instanceof UpdatableByText || value instanceof Character || value instanceof Byte) {
                    writer.write(WriterUtil.format(value));
                }
                writer.write("</e>");
                writer.newLine();
            }
            writer.write("</c>");
            writer.newLine();
        }
        finally {
            writer.close();
        }
    }

    public static File getFile(CongaServlet servlet, String fileId) {
        File dir;
        ServletConfig config = servlet.getServletConfig();
        String userDataDir = config.getInitParameter(USER_DATA_DIR);
        if (userDataDir == null || userDataDir.length() == 0) {
            userDataDir = System.getProperty("user.home") + "/.conga/dsp/user-storage";
        }
        if (userDataDir.charAt(0) == '/' || userDataDir.charAt(0) == '\\') {
            userDataDir = userDataDir.substring(1);
        }
        if (!(dir = new File(userDataDir)).exists()) {
            dir.mkdirs();
        }
        return new File(userDataDir, fileId);
    }
}

