/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.adapter;

import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.dsp.DefaultLogWriter;
import nga.servlet.spi.CongaServletAdapter;

public class InfoLogger
extends CongaServletAdapter {
    private static final String INFO_LEVEL = "INFO ";
    private long beginingTime;
    private long checkingTime;

    public void init(CongaServlet servlet) throws ServletException {
        DefaultLogWriter.log(servlet, INFO_LEVEL, null, null, "init", null);
    }

    public void destroy(CongaServlet servlet) {
        DefaultLogWriter.log(servlet, INFO_LEVEL, null, null, "destroy", null);
    }

    public void sessionCreated(ServiceInfo serviceInfo) throws ServletException {
        serviceInfo.getLog().info((Object)"sessionCreated", new Object[0]);
    }

    public void sessionDestroyed(CongaServlet servlet, HttpSession session) {
        DefaultLogWriter.log(servlet, INFO_LEVEL, session, null, "sessionDestroyed", null);
    }

    public void begin(ServiceInfo serviceInfo) throws ServletException {
        serviceInfo.getLog().info((Object)"begin", new Object[0]);
        this.beginingTime = System.currentTimeMillis();
    }

    public void end(ServiceInfo serviceInfo, String requestId) {
        serviceInfo.getLog().info((Object)("end [" + (System.currentTimeMillis() - this.beginingTime) + "ms]"), new Object[0]);
    }

    public void abort(ServiceInfo serviceInfo, Throwable exception) throws ServletException {
        serviceInfo.getLog().error((Object)("abort [" + (System.currentTimeMillis() - this.beginingTime) + "ms]"), new Object[0]);
    }

    public boolean checkParameter(ServiceInfo serviceInfo, Object controller, Method method, Object[] param) throws ServletException {
        if (method != null) {
            serviceInfo.getLog().info((Object)("exec-s (" + method.getDeclaringClass().getName() + "." + method.getName() + ")"), new Object[0]);
            this.checkingTime = System.currentTimeMillis();
        }
        return true;
    }

    public void editResult(ServiceInfo serviceInfo, Object controller, Method method, Object resultObject) throws ServletException {
        if (method != null) {
            serviceInfo.getLog().info((Object)("exec-e (" + method.getDeclaringClass().getName() + "." + method.getName() + ") [" + (System.currentTimeMillis() - this.checkingTime) + "ms]"), new Object[0]);
        }
    }

    public void forwarding(ServiceInfo serviceInfo, String oldRequestId, String newRequestId) throws ServletException {
        serviceInfo.getLog().info((Object)("forward (" + oldRequestId + " -> " + newRequestId + ")"), new Object[0]);
    }
}

