/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.controller;

import javax.servlet.ServletException;
import nga.model.User;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.UserAuth;
import nga.servlet.spi.UserStorage;
import nga.util.UserLocale;

public class UserController {
    private int errorCount;
    private int error;

    public UserController() {
        this.error = this.errorCount = 3;
    }

    public void login(User user, ServiceInfo info) throws ServletException {
        UserAuth.login(info, user);
        if (!user.isAuthorized()) {
            user.setPassword(null);
            info.getErrorInfo().setMessage("dspm.auth_error", new Object[0]);
            if (this.error-- <= 0) {
                info.getServlet().log("auth faild:" + user.getUserId());
                this.error = this.getErrorCount();
            }
        } else {
            UserStorage.load(info, user);
            UserLocale.setLocale(user.getAttribute().getLocale());
        }
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
        this.error = errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void logout(ServiceInfo info) throws ServletException {
        UserAuth.logout(info);
    }

    public void addUser(ServiceInfo serviceInfo, User user) throws ServletException {
        UserAuth.setPassword(serviceInfo, user);
        user.setPassword(null);
    }

    public void setPassword(ServiceInfo serviceInfo, User user) throws ServletException {
        if (user.isAuthorized()) {
            UserAuth.setPassword(serviceInfo, user);
            user.setPassword(null);
        } else {
            serviceInfo.getErrorInfo().setMessage("dspm.not_login", new Object[0]);
        }
    }
}

