/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.parser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import nga.model.History;
import nga.model.UpdatableByText;
import nga.model.User;
import nga.model.UserAttribute;
import nga.servlet.NameUtil;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.dsp.parser.MultipartParameterParser;
import nga.servlet.dsp.parser.PropertyValue;
import nga.servlet.dsp.parser.PropertyValueParser;
import nga.servlet.dsp.parser.PropertyValueParserCollection;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.UserAuth;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParameterParser
implements ParameterParser {
    private Map<Class, PropertyValueParser> valueParserMap = new HashMap<Class, PropertyValueParser>();
    private Map<String, Object> containers = new HashMap<String, Object>(400);
    private Object topContainer;
    private PropertyInfoMap propertyInfoMap;
    private Map<String, String> unusedPropertyInfo = new HashMap<String, String>();
    private ServiceInfo serviceInfo;
    private PropertyInfo emptyPropertyInfo = new PropertyInfo(null);
    private ObjectOperator objectOperator = new ObjectOperator();
    private PropertyValue propertyValue;
    private ModuleInfo moduleInfo;
    private MultipartParameterParser multilpartParameterParser = new MultipartParameterParser();
    private boolean checkUndefinedProperty;

    public void registerValueParser(Class type, PropertyValueParser parser) {
        this.valueParserMap.put(type, parser);
        this.valueParserMap.put(parser.getClass(), parser);
    }

    @Override
    public boolean parse(ServiceInfo serviceInfo) throws IOException, ServletException {
        HttpServletRequest request = serviceInfo.getRequest();
        String contentType = request.getHeader("Content-Type");
        Map<String, String[]> parameterMap = contentType != null && contentType.indexOf("multipart/form-data") > -1 ? this.multilpartParameterParser.parseMultipart(serviceInfo) : serviceInfo.getRequest().getParameterMap();
        return this.parse(serviceInfo, parameterMap);
    }

    protected boolean parse(ServiceInfo serviceInfo, Map<String, String[]> parameterMap) throws ServletException {
        this.containers.clear();
        this.topContainer = serviceInfo.getPageObject();
        this.serviceInfo = serviceInfo;
        this.propertyInfoMap = serviceInfo.getPropertyInfoMap();
        this.propertyValue = new PropertyValue(serviceInfo);
        this.moduleInfo = this.propertyValue.getModuleInfo();
        this.checkUndefinedProperty = serviceInfo.getParameterInfo().get("check-undefined", false);
        this.initUnusedPropertyInfo();
        try {
            boolean success = this.updateProperty(parameterMap);
            this.checkUnusedPropertyInfo();
            return success;
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getCause());
        }
    }

    protected boolean updateProperty(Map<String, String[]> parameterMap) throws IllegalAccessException, InvocationTargetException {
        boolean success = true;
        for (String key : parameterMap.keySet()) {
            if (key.charAt(0) == '_' || this.set(key, parameterMap.get(key)[0])) continue;
            success = false;
        }
        return success;
    }

    private void initUnusedPropertyInfo() {
        this.unusedPropertyInfo.clear();
        for (String propertyName : this.propertyInfoMap.keySet()) {
            this.unusedPropertyInfo.put(propertyName, propertyName);
        }
    }

    private void checkUnusedPropertyInfo() {
        if (!this.unusedPropertyInfo.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String name : this.unusedPropertyInfo.keySet()) {
                sb.append(name).append(", ");
            }
            throw new ConfigurationException(this.message("dspm.no_parameter", sb.substring(0, sb.length() - 2)));
        }
    }

    private PropertyInfo getPropertyInfo(String fieldName) {
        PropertyInfo pi = (PropertyInfo)this.propertyInfoMap.get(fieldName);
        if (pi != null) {
            this.unusedPropertyInfo.remove(fieldName);
        }
        return pi;
    }

    private boolean set(String fullName, String value) throws IllegalAccessException, InvocationTargetException {
        Object container = this.getContainer(NameUtil.getContainerName(fullName));
        if (container == null) {
            throw new ConfigurationException(this.message("dspm.no_container", NameUtil.getContainerName(fullName)));
        }
        String fieldName = NameUtil.getFieldName(fullName);
        PropertyInfo pi = this.getPropertyInfo(fieldName);
        if (this.checkUndefinedProperty && pi == null) {
            throw new ConfigurationException(this.message("dspm.undefined_property", fieldName));
        }
        if (!this.objectOperator.init(container, fieldName, NameUtil.getIndex(fullName), pi != null)) {
            return true;
        }
        if (pi == null) {
            this.emptyPropertyInfo.setName(fullName);
            this.emptyPropertyInfo.setModuleInfo(this.propertyValue.getModuleInfo());
            pi = this.emptyPropertyInfo;
        }
        UpdatableByText forUpdate = this.objectOperator.getUpdatableObject();
        this.propertyValue.setup(fullName, value, pi, forUpdate);
        PropertyValueParser parser = this.getParameterValueParser(pi, this.objectOperator.type);
        if (parser.parse(this.propertyValue)) {
            this.objectOperator.set(this.propertyValue.getObject());
            this.updateHistory(this.propertyValue);
            return true;
        }
        return false;
    }

    private void updateHistory(PropertyValue propertyValue) {
        String historyId = propertyValue.getPropertyInfo().get("history-id");
        if (historyId != null) {
            User user = UserAuth.getUser(this.serviceInfo);
            if (user == null) {
                return;
            }
            UserAttribute userAttr = user.getAttribute();
            History history = (History)userAttr.get(historyId);
            if (history == null) {
                history = new History();
                userAttr.put(historyId, history);
            }
            Object obj = propertyValue.getObject();
            try {
                if (obj != null) {
                    history.add((String)obj);
                }
            }
            catch (ClassCastException e) {
                history.add(obj.toString());
            }
        }
    }

    private PropertyValueParser getParameterValueParser(PropertyInfo pi, Class type) {
        String parserName;
        if (pi != null && (parserName = PropertyValueParser.getParser(pi)) != null) {
            return this.getPropertyParser(parserName);
        }
        PropertyValueParser parser = this.valueParserMap.get(type);
        if (parser == null) {
            if (UpdatableByText.class.isAssignableFrom(type)) {
                parser = PropertyValueParserCollection.FOR_TEXTCONVERTIBLE;
            } else {
                throw new ConfigurationException(this.message("dspm.no_parser", type.getSimpleName()));
            }
        }
        return parser;
    }

    private PropertyValueParser getPropertyParser(String parserName) {
        PropertyValueParser parser = this.valueParserMap.get(parserName);
        if (parser == null) {
            try {
                Class<?> c = Class.forName(parserName);
                parser = (PropertyValueParser)c.newInstance();
                this.valueParserMap.put(c, parser);
            }
            catch (Exception e) {
                throw new ConfigurationException(this.message("invalid_class", parserName), e);
            }
        }
        return parser;
    }

    private Object getContainer(String name) throws IllegalAccessException, InvocationTargetException {
        if (name == null) {
            return this.topContainer;
        }
        Object o = this.containers.get(name);
        if (o == null) {
            Object con = this.getContainer(NameUtil.getContainerName(name));
            if (con == null) {
                return null;
            }
            Method m = MethodOperator.getGetterMethod(con.getClass(), NameUtil.getFieldName(name));
            Class<?> rt = m.getReturnType();
            o = MethodOperator.get(m, con);
            if (o == null) {
                return null;
            }
            if (rt.isArray()) {
                o = Array.get(o, NameUtil.getIndex(name));
            } else if (List.class.isAssignableFrom(rt)) {
                o = ((List)o).get(NameUtil.getIndex(name));
            }
            this.containers.put(name, o);
        }
        return o;
    }

    private String message(String key, Object ... args) {
        return this.moduleInfo.getMessage(key, args);
    }

    private class ObjectOperator {
        Class type;
        Object container;
        Method setterMethod;
        UpdatableByText object;
        Class arrayType;
        Object array;
        String fieldName;
        int index;

        private ObjectOperator() {
        }

        public UpdatableByText getUpdatableObject() {
            return this.object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(Object value) throws IllegalAccessException, InvocationTargetException {
            if (this.array != null) {
                if (this.arrayType.isArray()) {
                    Array.set(this.array, this.index, value);
                    return;
                } else {
                    if (!List.class.isAssignableFrom(this.arrayType)) throw new ConfigurationException(DefaultParameterParser.this.message("dspm.invalid_list_type", new Object[]{this.fieldName, this.arrayType}));
                    ((List)this.array).set(this.index, value);
                }
                return;
            } else {
                if (this.setterMethod == null) return;
                MethodOperator.set(this.setterMethod, this.container, value);
            }
        }

        private void initArrayType(Object container, String propertyName) throws IllegalAccessException, InvocationTargetException {
            Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
            if (getterMethod == null) {
                throw new ConfigurationException(DefaultParameterParser.this.message("dspm.no_getter_method", new Object[]{container.getClass().getName(), propertyName}));
            }
            this.arrayType = getterMethod.getReturnType();
            this.array = MethodOperator.get(getterMethod, container);
            if (this.array == null) {
                throw new ConfigurationException(DefaultParameterParser.this.message("dspm.null_array", new Object[]{propertyName}));
            }
            if (this.arrayType.isArray()) {
                this.type = this.arrayType.getComponentType();
                if (UpdatableByText.class.isAssignableFrom(this.type)) {
                    this.object = (UpdatableByText)Array.get(this.array, this.index);
                }
            } else if (List.class.isAssignableFrom(this.arrayType)) {
                this.type = this.getClass((List)this.array);
                if (UpdatableByText.class.isAssignableFrom(this.type)) {
                    this.object = (UpdatableByText)((List)this.array).get(this.index);
                }
            } else {
                throw new ConfigurationException(DefaultParameterParser.this.message("dspm.invalid_list_type", new Object[]{propertyName, this.arrayType}));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean init(Object container, String propertyName, int index, boolean required) throws IllegalAccessException, InvocationTargetException {
            this.type = null;
            this.object = null;
            this.array = null;
            this.arrayType = null;
            this.setterMethod = null;
            this.container = container;
            this.fieldName = propertyName;
            this.index = index;
            if (index > -1) {
                this.initArrayType(container, propertyName);
                return true;
            }
            this.setterMethod = MethodOperator.getSetterMethod(container.getClass(), propertyName);
            if (this.setterMethod == null) {
                Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
                if (getterMethod == null) {
                    if (!required) return false;
                    throw new ConfigurationException(DefaultParameterParser.this.message("dspm.no_setter_method", new Object[]{container.getClass().getName(), propertyName}));
                }
                this.type = getterMethod.getReturnType();
                if (UpdatableByText.class.isAssignableFrom(this.type)) {
                    this.object = (UpdatableByText)MethodOperator.get(getterMethod, container);
                    return true;
                }
                if (!required) return false;
                throw new ConfigurationException(DefaultParameterParser.this.message("dspm.no_setter_method", new Object[]{container.getClass().getName(), propertyName}));
            }
            Class<?>[] pt = this.setterMethod.getParameterTypes();
            if (pt != null && pt.length != 0) {
                this.type = pt[0];
                if (!UpdatableByText.class.isAssignableFrom(this.type)) return true;
                Method getterMethod = MethodOperator.getGetterMethod(container.getClass(), propertyName);
                if (getterMethod == null) return true;
                this.type = getterMethod.getReturnType();
                this.object = (UpdatableByText)MethodOperator.get(getterMethod, container);
                return true;
            }
            if (!required) return false;
            throw new ConfigurationException(DefaultParameterParser.this.message("dspm.invalid_setter_method", new Object[]{container.getClass().getName(), propertyName}));
        }

        private Class getClass(List list) {
            for (int i = 0; i < list.size(); ++i) {
                Object o = list.get(i);
                if (o == null) continue;
                return o.getClass();
            }
            return null;
        }
    }
}

