/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import nga.servlet.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartParameterParser {
    private static final int BUFSIZE = 4096;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CRLF = new byte[]{13, 10};
    public static final String UPLOAD_DIR = "nga.servlet.dsp.upload-dir";
    private static final String BOUNDARY_KEY = "boundary=";
    private static final String CONTENT_DISPOSITION_KEY = "Content-Disposition";
    private static final String FILE_DATA_KEY = "; filename=";
    private static final String NAME_KEY = "; name=";
    private boolean eof;
    private byte[] boundary;
    private byte[] buff;
    private int buffPosition;
    private int buffLength;

    protected Map<String, String[]> parseMultipart(ServiceInfo serviceInfo) throws IOException {
        HttpServletRequest request = serviceInfo.getRequest();
        String contentType = request.getHeader("Content-Type");
        String encoding = request.getCharacterEncoding();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        int pos = contentType.indexOf(BOUNDARY_KEY) + BOUNDARY_KEY.length();
        this.boundary = ("--" + contentType.substring(pos)).getBytes("8859_1");
        ServletInputStream is = request.getInputStream();
        this.buff = new byte[4096];
        this.buffPosition = 4096;
        this.buffLength = 4096;
        this.eof = false;
        this.readLine((InputStream)is);
        do {
            this.readPart(serviceInfo, (InputStream)is, encoding, parameterMap);
        } while (!this.eof);
        return parameterMap;
    }

    private void readPart(ServiceInfo serviceInfo, InputStream is, String encoding, Map<String, String[]> parameterMap) throws IOException {
        String line = this.readLine(is, encoding);
        if (line.startsWith(CONTENT_DISPOSITION_KEY)) {
            int nameIndex = line.indexOf(NAME_KEY);
            if (nameIndex < 0) {
                return;
            }
            String name = this.getName(line, nameIndex);
            if (line.indexOf(FILE_DATA_KEY) > 0) {
                File file = this.getFile(serviceInfo);
                parameterMap.put(name, new String[]{file.getAbsolutePath()});
                this.writeFile(is, file);
            } else {
                this.readLine(is);
                StringBuilder sb = new StringBuilder();
                while ((line = this.readLine(is, encoding)) != null) {
                    sb.append(line).append("\r\n");
                    if (!this.eof) continue;
                }
                if (sb.length() > 2) {
                    line = sb.substring(0, sb.length() - 2);
                }
                parameterMap.put(name, new String[]{line});
            }
        }
    }

    private String getName(String line, int nameIndex) {
        int startIndex = line.indexOf(34, nameIndex) + 1;
        if (startIndex <= 0) {
            return null;
        }
        int endIndex = line.indexOf(34, startIndex);
        return line.substring(startIndex, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(InputStream is, File file) throws IOException {
        this.readLine(is);
        this.readLine(is);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.writeFile(is, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private void writeFile(InputStream is, OutputStream os) throws IOException {
        byte[] line;
        boolean writeCRLF = false;
        while (!this.isBoundary(line = this.readLine(is))) {
            if (writeCRLF) {
                os.write(CRLF);
            }
            os.write(line);
            writeCRLF = true;
            if (!this.eof) continue;
        }
    }

    private String readLine(InputStream is, String encoding) throws IOException {
        byte[] bytes = this.readLine(is);
        if (this.isBoundary(bytes)) {
            return null;
        }
        return new String(bytes, encoding);
    }

    private boolean isBoundary(byte[] line) {
        if (line.length < this.boundary.length) {
            return false;
        }
        for (int i = 0; i < this.boundary.length; ++i) {
            if (line[i] == this.boundary[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] readLine(InputStream is) throws IOException {
        byte[] temp = new byte[]{};
        boolean checkLF = false;
        while (true) {
            if (this.buffPosition == this.buffLength) {
                this.buffLength = is.read(this.buff);
                this.buffPosition = 0;
                if (this.buffLength == 0) {
                    Thread.yield();
                    continue;
                }
                if (this.buffLength < 0) {
                    this.eof = true;
                    return temp;
                }
                if (checkLF && this.buff[0] == 10) {
                    byte[] newBytes = new byte[temp.length - 1];
                    System.arraycopy(temp, 0, newBytes, 0, newBytes.length);
                    this.buffPosition = 1;
                    return newBytes;
                }
            }
            checkLF = false;
            for (int i = this.buffPosition; i < this.buffLength; ++i) {
                if (this.buff[i] != 13) continue;
                if (i + 1 == this.buffLength) {
                    checkLF = true;
                    break;
                }
                if (this.buff[i + 1] != 10) continue;
                byte[] newBytes = this.concat(temp, this.buff, i - this.buffPosition);
                this.buffPosition = i + 2;
                return newBytes;
            }
            temp = this.concat(temp, this.buff, this.buffLength - this.buffPosition);
            this.buffPosition = this.buffLength;
        }
    }

    private byte[] concat(byte[] oldBytes, byte[] newBytes, int length) {
        int oldBytesLength = 0;
        if (oldBytes != null) {
            oldBytesLength = oldBytes.length;
        }
        byte[] b = new byte[oldBytesLength + length];
        if (oldBytesLength > 0) {
            System.arraycopy(oldBytes, 0, b, 0, oldBytesLength);
        }
        if (length > 0) {
            System.arraycopy(newBytes, this.buffPosition, b, oldBytesLength, length);
        }
        return b;
    }

    protected File getFile(ServiceInfo serviceInfo) throws IOException {
        File dir = this.getDirectory(serviceInfo);
        return File.createTempFile(this.getTempFilePrefix(), null, dir);
    }

    protected String getTempFilePrefix() {
        return "nga-servlet-dsp-upload";
    }

    protected File getDirectory(ServiceInfo serviceInfo) {
        String dir = serviceInfo.getServlet().getInitParameter(UPLOAD_DIR);
        if (dir != null) {
            File f = new File(dir);
            if (!f.exists()) {
                f.mkdirs();
            }
            return f;
        }
        return null;
    }
}

