/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.parser;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import nga.servlet.ErrorInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.dsp.parser.PropertyValue;
import nga.util.ConfigurationException;
import nga.util.FormatUtil;

public abstract class PropertyValueParser {
    public abstract boolean parse(PropertyValue var1);

    protected boolean checkRequired(PropertyValue pv) {
        String value = pv.getValue();
        PropertyInfo constraints = pv.getPropertyInfo();
        if (value == null || value.length() == 0) {
            if (!PropertyValueParser.isRequired(constraints)) {
                return true;
            }
            ErrorInfo errorInfo = pv.getErrorInfo();
            String name = pv.getName();
            String label = PropertyValueParser.getLabel(constraints);
            if (label != null) {
                errorInfo.add(name, null, "dspm.required2", label);
            } else {
                errorInfo.add(name, null, "dspm.required1", new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected String delC(String val) {
        if (val == null) {
            return null;
        }
        int len = val.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c == ',') continue;
            sb.append(c);
        }
        if (len != sb.length()) {
            return new String(sb);
        }
        return val;
    }

    protected boolean check(long value, int len) {
        return (double)value < Math.pow(10.0, len);
    }

    protected boolean checkNum(PropertyValue pv) {
        long num;
        int ilen;
        if (!this.checkRequired(pv)) {
            return false;
        }
        PropertyInfo constraints = pv.getPropertyInfo();
        int length = PropertyValueParser.getLength(constraints);
        int scale = PropertyValueParser.getScale(constraints);
        if (length == -1) {
            scale = -1;
            ilen = -1;
        } else {
            ilen = scale == -1 ? length : length - scale;
        }
        String label = PropertyValueParser.getLabel(constraints);
        String name = pv.getName();
        String value = pv.getValue();
        ErrorInfo errorInfo = pv.getErrorInfo();
        if (scale > -1) {
            BigDecimal num2 = new BigDecimal(value);
            double d = num2.setScale(0, 1).doubleValue();
            if (num2.scale() > scale || d >= Math.pow(10.0, ilen)) {
                if (label != null) {
                    errorInfo.add(name, value, "dspm.ilen_flen2", ilen, scale, label);
                } else {
                    errorInfo.add(name, value, "dspm.ilen_flen1", ilen, scale);
                }
                return false;
            }
            return true;
        }
        if (ilen > 0 && (double)(num = Long.parseLong(value)) >= Math.pow(10.0, ilen)) {
            if (label != null) {
                errorInfo.add(name, value, "dspm.ilen2", ilen, label);
            } else {
                errorInfo.add(name, value, "dspm.ilen1", ilen);
            }
        }
        return true;
    }

    protected boolean handleNumberFormatException(PropertyValue pv) {
        String label = PropertyValueParser.getLabel(pv.getPropertyInfo());
        String name = pv.getName();
        String value = pv.getValue();
        ErrorInfo errorInfo = pv.getErrorInfo();
        if (label != null) {
            errorInfo.add(name, value, "dspm.number_format_exception2", label);
        } else {
            errorInfo.add(name, value, "dspm.number_format_exception1", new Object[0]);
        }
        return false;
    }

    protected boolean toDate(PropertyValue pv, String defaultFormat) {
        if (!this.checkRequired(pv)) {
            return false;
        }
        String value = pv.getValue();
        if (value == null || value.length() == 0) {
            pv.setObject(null);
            return true;
        }
        PropertyInfo pi = pv.getPropertyInfo();
        String name = pv.getName();
        ErrorInfo errorInfo = pv.getErrorInfo();
        String format = PropertyValueParser.getFormat(pi, defaultFormat);
        Date d = FormatUtil.parse(value, format);
        if (d == null) {
            String label = PropertyValueParser.getLabel(pi);
            if (label != null) {
                errorInfo.add(name, value, "dspm.format_exception2", format, label);
            } else {
                errorInfo.add(name, value, "dspm.format_exception1", format);
            }
            return false;
        }
        pv.setObject(d);
        return true;
    }

    protected boolean checkLength(PropertyValue pv) {
        PropertyInfo constraints = pv.getPropertyInfo();
        String value = pv.getValue();
        int length = PropertyValueParser.getLength(constraints);
        if (length > 0 && value.length() > length) {
            ErrorInfo errorInfo = pv.getErrorInfo();
            String name = pv.getName();
            String label = PropertyValueParser.getLabel(constraints);
            if (label != null) {
                errorInfo.add(name, value, "dspm.length2", length, label);
            } else {
                errorInfo.add(name, value, "dspm.length1", length);
            }
            return false;
        }
        return true;
    }

    protected boolean checkByteLength(PropertyValue pv) {
        PropertyInfo constraints = pv.getPropertyInfo();
        int bytelength = PropertyValueParser.getBytelength(constraints);
        String systemEncoding = pv.getServiceInfo().getSystemEncoding();
        try {
            String value = pv.getValue();
            if (bytelength > 0 && value.getBytes(systemEncoding).length > bytelength) {
                ErrorInfo errorInfo = pv.getErrorInfo();
                String name = pv.getName();
                String label = PropertyValueParser.getLabel(constraints);
                if (label != null) {
                    errorInfo.add(name, value, "dspm.bytelength2", bytelength, label);
                } else {
                    errorInfo.add(name, value, "dspm.bytelength1", bytelength);
                }
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException(pv.getModuleInfo().getMessage("dspm.unsupported_encoding", systemEncoding), e);
        }
        return true;
    }

    protected boolean checkCharType(PropertyValue pv) {
        PropertyInfo constraints = pv.getPropertyInfo();
        String chartype = PropertyValueParser.getChartype(constraints);
        String value = pv.getValue();
        if (chartype != null && !value.matches(chartype)) {
            ErrorInfo errorInfo = pv.getErrorInfo();
            String name = pv.getName();
            String label = PropertyValueParser.getLabel(constraints);
            String comment = PropertyValueParser.getChartypeComment(constraints);
            if (label != null) {
                errorInfo.add(name, value, "dspm.chartype2", comment, label);
            } else {
                errorInfo.add(name, value, "dspm.chartype1", comment);
            }
            return false;
        }
        return true;
    }

    public static String getParser(PropertyInfo propertyInfo) {
        return propertyInfo.get("parser");
    }

    public static boolean isRequired(PropertyInfo propertyInfo) {
        return propertyInfo.get("required", false);
    }

    public static String getLabel(PropertyInfo propertyInfo) {
        return propertyInfo.get("label");
    }

    public static int getLength(PropertyInfo propertyInfo) {
        return propertyInfo.get("length", -1);
    }

    public static int getScale(PropertyInfo propertyInfo) {
        return propertyInfo.get("scale", -1);
    }

    public static int getBytelength(PropertyInfo propertyInfo) {
        return propertyInfo.get("bytelength", -1);
    }

    public static String getFormat(PropertyInfo propertyInfo, String defaultFormat) {
        return propertyInfo.get("format", defaultFormat);
    }

    public static String getChartype(PropertyInfo propertyInfo) {
        return propertyInfo.get("chartype");
    }

    public static String getChartypeComment(PropertyInfo propertyInfo) {
        return propertyInfo.get("chartype-comment", PropertyValueParser.getChartype(propertyInfo));
    }
}

