/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nga.servlet.ErrorInfo;
import nga.servlet.ServiceInfo;
import nga.servlet.WriterUtil;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.AbstractResultWriter;
import nga.servlet.dsp.writer.DefaultTargetValueWriter;
import nga.servlet.dsp.writer.TargetValue;
import nga.servlet.dsp.writer.TargetValueWriter;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

public class DefaultResultWriter
extends AbstractResultWriter {
    public static final TargetValueWriter DEFAULT = new DefaultTargetValueWriter();
    private static final String TARGET_VALUE = "nga.dsp.target.value";
    private static final String BUFFER = "nga.dsp.DefaultResultWriter.buffer";
    private Map<Class, TargetValueWriter> valueWriterMap = new HashMap<Class, TargetValueWriter>();
    private Map<String, Method> methodMap;

    protected void handleWrite(ServiceInfo serviceInfo) throws IOException, ServletException {
        PrintWriter writer;
        Object resultObject = serviceInfo.getResultObject();
        HttpServletResponse response = serviceInfo.getResponse();
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("text/xml; charset=UTF-8");
        HttpServletRequest request = serviceInfo.getRequest();
        CharArrayWriter buffer = (CharArrayWriter)request.getAttribute(BUFFER);
        if (buffer == null) {
            if (serviceInfo.isForwarding()) {
                buffer = new CharArrayWriter();
                writer = new PrintWriter(buffer);
                request.setAttribute(BUFFER, (Object)buffer);
            } else {
                writer = response.getWriter();
            }
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print("<c");
        } else if (serviceInfo.isForwarding()) {
            writer = new PrintWriter(buffer);
        } else {
            writer = response.getWriter();
            writer.print(buffer.toString());
        }
        ErrorInfo errorInfo = serviceInfo.getErrorInfo();
        if (errorInfo.getException() != null) {
            errorInfo.getException().printStackTrace();
            String s = errorInfo.getException().getMessage();
            if (s == null) {
                s = errorInfo.getException().getClass().getName();
            }
            this.printMessage(writer, s);
        } else if (errorInfo.getErrorMessage() != null) {
            System.err.println(errorInfo.getErrorMessage());
            this.printMessage(writer, errorInfo.getErrorMessage());
        }
        if (errorInfo.hasError()) {
            writer.print(" is-error=\"true\"");
        }
        writer.println(">");
        if (resultObject != null) {
            this.methodMap = MethodOperator.getGetterMethods(resultObject.getClass());
        }
        TargetInfoList targetInfoList = serviceInfo.getTargetInfoList();
        for (int i = 0; i < targetInfoList.size(); ++i) {
            String type;
            TargetInfo ti = (TargetInfo)targetInfoList.get(i);
            String include = ti.getInclude();
            String tagName = "e";
            boolean cdata = true;
            TargetValueWriter valueWriter = null;
            if (include == null) {
                valueWriter = this.getWriter(ti);
                cdata = valueWriter.isCdataSection();
                tagName = valueWriter.isContainer() ? "c" : "e";
            }
            writer.print("<");
            writer.print(tagName);
            ErrorInfo.Item item = (ErrorInfo.Item)errorInfo.get(ti.getName());
            if (item != null) {
                writer.print(" is-error=\"true\"");
                String message = item.getMessage();
                if (message != null) {
                    this.printMessage(writer, message);
                }
            }
            if ((type = ti.getType()) != null) {
                WriterUtil.attr(writer, "type", (Object)type);
            }
            Object o = null;
            try {
                String valueName = ti.getName();
                if (valueName != null && resultObject != null) {
                    Method method = this.methodMap.get(valueName);
                    if (method == null) {
                        throw new ConfigurationException(ti.getModuleInfo().getMessage("dspm.no_getter_method", resultObject.getClass(), valueName));
                    }
                    o = MethodOperator.get(method, resultObject);
                }
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException(e.getCause());
            }
            TargetValue targetValue = new TargetValue(serviceInfo, writer, resultObject);
            targetValue.setup(o, ti);
            request.setAttribute(TARGET_VALUE, (Object)targetValue);
            for (Map.Entry attrEntry : ti.entrySet()) {
                String attrName = (String)attrEntry.getKey();
                if ("name".equals(attrName) || "type".equals(attrName) || "include".equals(attrName) || "writer".equals(attrName)) continue;
                WriterUtil.attr((Writer)writer, attrName, ti, resultObject);
            }
            if (valueWriter != null) {
                valueWriter.setTargetValue(targetValue);
                valueWriter.writeAttribute();
            }
            if (cdata) {
                writer.print("><![CDATA[");
            } else {
                writer.print(">");
            }
            if (include != null) {
                request.getRequestDispatcher(include).include((ServletRequest)request, (ServletResponse)response);
            } else {
                valueWriter.write();
            }
            if (cdata) {
                writer.println("]]>");
            }
            writer.print("</");
            writer.print(tagName);
            writer.println(">");
        }
        if (!serviceInfo.isForwarding()) {
            writer.println("</c>");
        }
    }

    private void printMessage(PrintWriter writer, String message) {
        WriterUtil.attr(writer, "message", (Object)message);
    }

    private TargetValueWriter getWriter(TargetInfo ti) {
        String writerName = ti.get("writer");
        if (writerName != null) {
            return this.getWriter(writerName, ti.getModuleInfo());
        }
        return DEFAULT;
    }

    private TargetValueWriter getWriter(String writerName, ModuleInfo moduleInfo) {
        TargetValueWriter writer = this.valueWriterMap.get(writerName);
        if (writer == null) {
            try {
                Class<?> c = Class.forName(writerName);
                writer = (TargetValueWriter)c.newInstance();
                this.valueWriterMap.put(c, writer);
            }
            catch (Exception e) {
                throw new ConfigurationException(moduleInfo.getMessage("dspm.invalid_writer_class", writerName), e);
            }
        }
        return writer;
    }

    public static TargetValue getTargetValue(HttpServletRequest request) {
        return (TargetValue)request.getAttribute(TARGET_VALUE);
    }
}

